/*!***************************************************************************

  module      : gbd470.h

  -------------------------------------------------------------------------

  author      : AlexanderK
  responsible : UweH

  special area: logging ...
  description : description ...


  last changed: 1999-09-15  10:16
  see also    : example.html ...

  -------------------------------------------------------------------------

  copyright:    (c) 1999-2004 SAP AG



    ========== licence begin  GPL
    Copyright (c) 1999-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

*****************************************************************************/


#ifndef GBD470_H
#define GBD470_H

/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include <new.h>

#include "gbd300.h"
#include "gbd460.h"
#include "gbd500.h"
#include "gbd510.h"
#include "gbd600.h"

#include "hbd06_1.h"

/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/

#define SKIP_INV_ERROR_HANDLING false

#ifdef BIT64
# define ALIGNMENT_BD470 8
#else
# define ALIGNMENT_BD470 4
#endif

/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/

#define ALIGN_BD470(LEN) (char *) (((tsp00_Longint ((char*) (LEN))-1) & ~(ALIGNMENT_BD470-1)) + ALIGNMENT_BD470)

/*===========================================================================*
 *  CLASSES, STRUCTURES, TYPES, UNIONS ...                                   *
 *===========================================================================*/

template <class T> class cbd470_AutoDestructPtr
{
	/* This template is used for pointers which point to objects        */
	/* defined by a placement new. Similar to the auto_ptr template     */
	/* of the std.lib the template calls automatically the destructor   */
	/* of the object it points on if the pointer is destroyed. However, */
	/* in contrast to the auto_ptr the memory is not released           */ 

	public:  
		cbd470_AutoDestructPtr (T * Ptr=NULL):m_Ptr(Ptr){};
		cbd470_AutoDestructPtr<T> & operator = (T * Ptr) {m_Ptr=Ptr; return *this;}
		~cbd470_AutoDestructPtr ()  {if (NULL != m_Ptr){m_Ptr->~T();};};
		T * operator ->(){return m_Ptr;};
		T & operator * (){return *m_Ptr;}

	private:
		T* m_Ptr;
};

/*---------------------------------------------------------------------------*/

class cbd470_PrimKeyIterator
{
public:
	virtual cbd470_PrimKeyIterator &  operator ++ ()                                              = 0;
	virtual void                      bd470Deref (tsp00_KeyPtr &pPrimKey, tsp00_Int2 &PrimKeyLen) = 0;
	virtual ~cbd470_PrimKeyIterator(){};
};

/*---------------------------------------------------------------------------*/

class cbd470_PrimKeyIteratorOnPrimTree : public cbd470_PrimKeyIterator
{
public:

	cbd470_PrimKeyIteratorOnPrimTree (cbd300_InvCurrent &Current,
		                              tsp00_KeyPtr       pStartPrimKey,
		                              tsp00_Int4         StartPrimKeyLen,
		                              tsp00_KeyPtr       pStopPrimKey,
		                              tsp00_Int4         StopPrimKeyLen,
		                              const bool         bAscendingKeyOrder,
		                              const bool         bIncludeStartPrimKey,
		                              tsp00_PageNo      &ErrorRootPno,
		                              bool              &bStartPrimKeyFound);

	~cbd470_PrimKeyIteratorOnPrimTree();

	cbd470_PrimKeyIterator & operator ++ ();
	void                     bd470Deref  (tsp00_KeyPtr &pPrimKey, tsp00_Int2 &PrimKeyLen);

private:
	cbd300_InvCurrent     &m_Current;
	cbd600_Node            m_Node;
//	tsp00_Key              m_RePositionKey;          
//	tsp00_Int2             m_RePositionKeyLen;  
	cbd500_Tree            m_Tree;
	cbd510_RecordIterator  m_RecIter;
	tgg00_BasisError      &m_TrError;
	tsp00_PageNo          &m_ErrorRootPno;  //=root of the file which throw the error in case TrError != e_ok 
};

/*---------------------------------------------------------------------------*/

class cbd470_PrimKeyIteratorOnInvTree : public cbd470_PrimKeyIterator
{
public:

	cbd470_PrimKeyIteratorOnInvTree (cbd300_InvCurrent  &Current,
									 tsp00_KeyPtr        pSecKey,
									 tsp00_Int4          SecKeyLen,
									 tsp00_KeyPtr        pStartPrimKey,
									 tsp00_Int4          StartPrimKeyLen,
									 tsp00_KeyPtr        pStopPrimKey,
									 tsp00_Int4          StopPrimKeyLen,
									 const bool          bAscendingKeyOrder,
									 const bool          bIncludeStartPrimKey,
 									 tsp00_PageNo       &ErrorRootPno);

	~cbd470_PrimKeyIteratorOnInvTree();

	cbd470_PrimKeyIterator & operator ++ ();
	void                     bd470Deref  (tsp00_KeyPtr &pPrimKey, tsp00_Int2 &PrimKeyLen);

private:
	cbd300_InvCurrent                             &m_Current;
	cbd600_Node                                    m_Node;
	cbd500_Tree                                    m_Tree;
	cbd470_AutoDestructPtr<cbd460_InvListIterator> m_pInvListIterator;
	tgg00_BasisError                              &m_TrError;
	tsp00_PageNo                                  &m_ErrorRootPno;  //=root of the file which throw the error in case TrError != e_ok 
    char                                           m_Buffer [ALIGNMENT_BD470 + 
		                                                     MAX_EO00(sizeof(cbd460_InvListArrayIterator), sizeof(cbd460_InvListSubtreeIterator))];
};

/*===========================================================================*
 *  METHOD IMPLEMENTATION                                                    *
 *===========================================================================*/

inline
cbd470_PrimKeyIteratorOnPrimTree::cbd470_PrimKeyIteratorOnPrimTree (cbd300_InvCurrent	   &Current,
																	tsp00_KeyPtr            pStartPrimKey,
																	tsp00_Int4              StartPrimKeyLen,
																	tsp00_KeyPtr            pStopPrimKey,
																	tsp00_Int4              StopPrimKeyLen,
																	const bool              bAscendingKeyOrder,
																	const bool              bIncludeStartPrimKey,
																	tsp00_PageNo           &ErrorRootPno,
																	bool                   &bStartPrimKeyFound)
:m_Current (Current),
 m_Node    (m_Current),
 m_Tree    (m_Node), // (tsp00_KeyPtr) (&m_RePositionKey), &m_RePositionKeyLen),
 m_RecIter (m_Tree, pStartPrimKey, StartPrimKeyLen,  pStopPrimKey, StopPrimKeyLen, 
            bAscendingKeyOrder, bIncludeStartPrimKey, bStartPrimKeyFound),
 m_TrError (m_Current.curr_trans->trError_gg00),
 m_ErrorRootPno (ErrorRootPno)
{
	ROUTINE_DBG_MEO00 ("cbd470_PrimKeyIteratorOnPrimTree");
														
	if (e_ok != m_TrError)
		m_ErrorRootPno = m_Current.curr_tree_id.fileRoot_gg00();
}

/*---------------------------------------------------------------------------*/

inline cbd470_PrimKeyIterator &  
cbd470_PrimKeyIteratorOnPrimTree::operator ++ ()
{
	ROUTINE_DBG_MEO00 ("cbd470_PrimKeyIteratorOnPrimTree++");
	
	++m_RecIter;
	if (e_ok != m_TrError) {m_ErrorRootPno = m_Current.curr_tree_id.fileRoot_gg00();};
	return *this;
}

/*---------------------------------------------------------------------------*/

inline void
cbd470_PrimKeyIteratorOnPrimTree::bd470Deref (tsp00_KeyPtr &pPrimKey, tsp00_Int2 &PrimKeyLen)
{
	ROUTINE_DBG_MEO00 ("bd470Deref_OnPrimTree");
	
	if (NULL != *m_RecIter)
	{
		pPrimKey   = (tsp00_KeyPtr) &(*m_RecIter)->recKey_gg00().keyVal_gg00();
		PrimKeyLen = (*m_RecIter)->recKeyLen_gg00();
	}
	else
	{
		pPrimKey   = NULL;
		PrimKeyLen = 0;
	}

	if (e_ok != m_TrError) {m_ErrorRootPno = m_Current.curr_tree_id.fileRoot_gg00();};
}

/*---------------------------------------------------------------------------*/

inline 
cbd470_PrimKeyIteratorOnPrimTree::~cbd470_PrimKeyIteratorOnPrimTree()
{
	if (m_TrError != e_ok) 
	{
		if (m_ErrorRootPno != m_Current.curr_tree_id.fileRoot_gg00())
			m_Current.bd300SkipErrorHandling();
		else
            bd06IllegalRootAccess (*m_Current.curr_trans, m_Current.curr_tree_id);
	}
}
	
/*---------------------------------------------------------------------------*/

inline
cbd470_PrimKeyIteratorOnInvTree::cbd470_PrimKeyIteratorOnInvTree (cbd300_InvCurrent  &Current,
																  tsp00_KeyPtr        pSecKey,
																  tsp00_Int4          SecKeyLen,
																  tsp00_KeyPtr        pStartPrimKey,
																  tsp00_Int4          StartPrimKeyLen,
																  tsp00_KeyPtr        pStopPrimKey,
																  tsp00_Int4          StopPrimKeyLen,
																  const bool          bAscendingKeyOrder,
																  const bool          bIncludeStartPrimKey,
									    						  tsp00_PageNo       &ErrorRootPno)
:m_Current          (Current),
 m_Node             (m_Current),
 m_Tree             (m_Node),
 m_pInvListIterator (NULL),
 m_TrError          (m_Current.curr_trans->trError_gg00),
 m_ErrorRootPno     (ErrorRootPno)
{
	
	ROUTINE_DBG_MEO00 ("cbd470_PrimKeyIteratorOnInvTree");
	
	if (m_TrError != e_ok)
	{
		m_ErrorRootPno = m_Current.curr_tree_id.fileRoot_gg00();
		return;
	}

	tbd_searchresult    SecKeySearchResult;
	tsp00_Int4          SecKeyIndex; 
	
	/* search secondary key in index */
	m_Tree.bd500FindNode (pSecKey, SecKeyLen, LEAF_LEVEL_BD00);
	if (m_TrError != e_ok)
	{
		m_ErrorRootPno = m_Current.curr_tree_id.fileRoot_gg00();
		return;
	}
		
	SecKeySearchResult.becomes  (nonefound);
	m_Node.bd600SearchRecord (pSecKey, SecKeyLen, SecKeyIndex, SecKeySearchResult);
	
	if (thisfound != SecKeySearchResult)
		m_TrError = e_inv_list_not_found;
	else
	{
		const tgg00_RecPtr pRec = m_Node.bd600RecPtr (SecKeyIndex);
		
		switch (pRec->recInvListKind_gg00()) 
		{
		case ilkArray_egg00:
			{   /* get primkey iterator on arrays */
				m_pInvListIterator = new (ALIGN_BD470 (m_Buffer)) 
					cbd460_InvListArrayIterator  (pRec, pStartPrimKey, StartPrimKeyLen,
					pStopPrimKey, StopPrimKeyLen, bAscendingKeyOrder, bIncludeStartPrimKey);	
			}
			break;

		case ilkSubTree_egg00:
			{	/* get primkey iterator on subtrees */
				cbd450_InvListRefSubTree InvListRefSubTree (pRec);

				m_pInvListIterator = new (ALIGN_BD470 (m_Buffer)) 
					cbd460_InvListSubtreeIterator (m_Tree, InvListRefSubTree, // PTS 1116651 TS 2002-07-16
					pStartPrimKey, StartPrimKeyLen, pStopPrimKey , StopPrimKeyLen, 
					bAscendingKeyOrder, bIncludeStartPrimKey);
			}
			break;
			
		default:
			m_TrError = e_illegal_record;
			m_Node.bd600Dump (bd470c1IllegalRecord_csp03, "bd470PrimKeyItOnInvTree ");
		}
	}

	if (m_TrError != e_ok)
		m_ErrorRootPno = m_Current.curr_tree_id.fileRoot_gg00();
}

/*---------------------------------------------------------------------------*/

inline cbd470_PrimKeyIterator &
cbd470_PrimKeyIteratorOnInvTree::operator ++ ()
{
	ROUTINE_DBG_MEO00 ("cbd470_PrimKeyIteratorOnInvTree++");
	
	++ (*m_pInvListIterator);
	if (e_ok != m_TrError){	m_ErrorRootPno = m_Current.curr_tree_id.fileRoot_gg00();};
	return (*this);
}

/*---------------------------------------------------------------------------*/

inline void
cbd470_PrimKeyIteratorOnInvTree::bd470Deref (tsp00_KeyPtr &pPrimKey, tsp00_Int2 &PrimKeyLen)
{
	ROUTINE_DBG_MEO00 ("bd470Deref_OnSecTree");
	
	m_pInvListIterator->bd460Deref (pPrimKey, PrimKeyLen);
	if (e_ok != m_TrError) {m_ErrorRootPno = m_Current.curr_tree_id.fileRoot_gg00();};
};

/*---------------------------------------------------------------------------*/

inline 
cbd470_PrimKeyIteratorOnInvTree::~cbd470_PrimKeyIteratorOnInvTree()
{
	if (m_TrError != e_ok) 
	{
		if (m_ErrorRootPno != m_Current.curr_tree_id.fileRoot_gg00())
			m_Current.bd300SkipErrorHandling();
		else
			bd06IllegalRootAccess (*m_Current.curr_trans, m_Current.curr_tree_id);
	}
}
	
/*---------------------------------------------------------------------------*/

#endif  /* GBD470_H */
