/*!
 * \file    LVC_ProcServerExtender.cpp
 * \author  IvanS
 * \brief   Extender for processing calls from out-of-process procedures in liveCache kernel.
 */
/*

    ========== licence begin  GPL
    Copyright (c) 2002-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

#include "liveCache/LVC_ProcServerExtender.hpp"
#include "hsp77.h"

/*---------------------------------------------------------------------------*/

LVC_ProcServerExtender::LVC_ProcServerExtender(SAPDBMem_IRawAllocator *alloc,
  IliveCacheSink *sink)
: LVC_ProcServerInterface(alloc), LVC_ProcServerExecutor(sink, NULL), 
  m_alloc(alloc), m_cRef(0)
{
  executorAdviseInterface(this);
  m_pIUnknown = sink;
}

/*---------------------------------------------------------------------------*/

void LVC_ProcServerExtender::processPacket()
{
}

/*---------------------------------------------------------------------------*/

void LVC_ProcServerExtender::getSendArea(void* &addr, size_t &maxSize)
{
}

/*---------------------------------------------------------------------------*/

void LVC_ProcServerExtender::getSecondarySendArea(void* &addr, size_t &maxSize)
{
}

/*---------------------------------------------------------------------------*/

void LVC_ProcServerExtender::getReceiveArea(void* &addr, size_t &maxSize)
{
}

/*---------------------------------------------------------------------------*/

void LVC_ProcServerExtender::sendData(size_t size)
{
}

/*---------------------------------------------------------------------------*/

void LVC_ProcServerExtender::receiveData()
{
}

/*---------------------------------------------------------------------------*/

size_t LVC_ProcServerExtender::getOffsetForAddress(void *addr)
{
  return 0;
}

/*---------------------------------------------------------------------------*/

void *LVC_ProcServerExtender::getAddressForOffset(size_t offs)
{
  return NULL;
}

/*---------------------------------------------------------------------------*/
#if 0
STDMETHODIMP LVC_ProcServerExtender::QueryInterface ( REFIID iid, PVOID *ppv)
{
  if (memcmp (&iid, &IID_IUnknown, sizeof (IID)) == 0)
    *ppv = (void *) this;
  else if (memcmp (&iid, &IID_LVC_ProcServerExtender, sizeof (IID)) == 0)
    *ppv = (void *) this;
  else
  {
    *ppv = 0;
    return E_NOINTERFACE;
  }
  this->AddRef();
  return S_OK;
}
#endif
/*---------------------------------------------------------------------------*/

STDMETHODIMP LVC_ProcServerExtender::sysRequest(int __RPC_FAR *lpbuflen, unsigned char __RPC_FAR *lpv)
{
  // TODO
  return S_OK;
}

/*---------------------------------------------------------------------------*/

STDMETHODIMP LVC_ProcServerExtender::sysMonitorInit(void)
{
  // TODO
  return S_OK;
}

/*---------------------------------------------------------------------------*/

STDMETHODIMP LVC_ProcServerExtender::sysMonitorProlog(int dispId, unsigned char __RPC_FAR *lpMethodName)
{
  // TODO
  return S_OK;
}

/*---------------------------------------------------------------------------*/

STDMETHODIMP LVC_ProcServerExtender::sysMonitorEpilog(int dispId, int runTime)
{
  // TODO
  return S_OK;
}

/*---------------------------------------------------------------------------*/

STDMETHODIMP LVC_ProcServerExtender::Register(void)
{
  // TODO
  return S_OK;
}

/*---------------------------------------------------------------------------*/
