/*


    ========== licence begin  GPL
    Copyright (c) 2002-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

#ifndef LVC_NEWOBJECTCHECKER_HPP
#define LVC_NEWOBJECTCHECKER_HPP

#include "ggg250.h"

template 
<class T>
class LVC_Compare
{
  public :
	  int Compare(const T& t1, const T& t2) 
	  {
		  int cmp = memcmp(&t1, &t2, 6);
		  if (0 == cmp) 
		  {
			  return 0;
		  }
		  else
		  {
			  return ((cmp > 0) ? 1 : -1);
		  }
	  }
};

class LVC_Allocator
{
public :
	void* allocate(size_t size)
	{
		return malloc(size);
	}
	void deallocate(void* p)
	{
		free(p);
	}
};

template
<class T>
class LVC_NewObjectChecker
{
public :
    typedef typename cgg250AvlTree<T, LVC_Compare<T>, LVC_Allocator>::Iterator Iterator;

	LVC_NewObjectChecker() 
		: m_allocator()
		, m_compare()
		, m_newOids(&m_compare, &m_allocator)
	{
	}
	void Insert(const T& oid)
	{
		if (m_newOids.Insert(oid))
		{
		}
	}
	void Delete(const T& oid)
	{
      m_newOids.Delete(oid);
	}
	Iterator Check()
	{
		return m_newOids.First();
	}
	void Reset()
	{
       m_newOids.DeleteAll();
	}
private :
  typedef T* TPtr;
  LVC_Allocator                                   m_allocator;
  LVC_Compare<T>                                  m_compare;
  TPtr           m_head;

  cgg250AvlTree<T, LVC_Compare<T>, LVC_Allocator> m_newOids;
};

#endif