/*! 
  -----------------------------------------------------------------------------
 
  module: Tools_Vector.hpp
 
  -----------------------------------------------------------------------------
 
  responsible:  BerndV
 
  special area: universal stuff for web access
   
  description:  a vector class like STL vector

  version:      7.3 and higher 
  -----------------------------------------------------------------------------
 
                          Copyright (c) 2000-2004 SAP AG
 
  -----------------------------------------------------------------------------



    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



*/

#ifndef _TOOLS_VECTOR_HPP_
#define _TOOLS_VECTOR_HPP_

/*
  -----------------------------------------------------------------------------
  macros
  -----------------------------------------------------------------------------
 */
#define Tools_VECTOR_SIZE_STEP 10
#define Tools_EMPTY            -1

/*
  -----------------------------------------------------------------------------
  Class:        Tools_Vector
  -----------------------------------------------------------------------------

  description:  Vector

  -----------------------------------------------------------------------------
 */
template <class E> class Tools_Vector
{
  public:
    Tools_Vector          ( );
    ~Tools_Vector         ( );

    void      push_back(const E & aElement);
    void      pop_back();
    bool      empty() {return (m_nCurrent == Tools_EMPTY);}

    typedef E * iterator;
    iterator  begin() const {return &( m_theVector[0]);}
    iterator  end() const {return &(m_theVector[m_nCurrent + 1]); }

    E & back();

  private:

    E   * m_theVector;
    int   m_nCurrent;
    int   m_nSize;
};

/* EndClass: Tools_Vector */

/*
  =============================================================================
  implementation 
  =============================================================================
 */


/*
  -----------------------------------------------------------------------------
  public constructor Tools_Vector :: Tools_Vector
  -----------------------------------------------------------------------------
 */
template <class E>
inline Tools_Vector<E> :: Tools_Vector ( )
{
  m_nSize    = Tools_VECTOR_SIZE_STEP;
  m_nCurrent = Tools_EMPTY;

  m_theVector = new E[m_nSize + 1];

} // end Tools_Vector :: Tools_Vector

/*
  -----------------------------------------------------------------------------
  public destructor Tools_Vector :: ~Tools_Vector
  -----------------------------------------------------------------------------
 */
template <class E>
inline Tools_Vector<E> :: ~Tools_Vector ( )
{
  if (m_theVector != 0) {
    delete [] m_theVector;
    m_theVector = 0;
  } // end if
} // end Tools_Vector :: ~Tools_Vector

/*
  -----------------------------------------------------------------------------
  public function Tools_Vector :: push_back
  -----------------------------------------------------------------------------
 */
template <class E>
inline void Tools_Vector<E> :: push_back ( const E & aElement )
{
  int nIndex = 0;

  if ((m_nSize - 1) == m_nCurrent) {
    m_nSize =  m_nSize + Tools_VECTOR_SIZE_STEP;

    E *  m_newVector = new E[m_nSize + 1];

    for (nIndex = 0;nIndex < (m_nSize - Tools_VECTOR_SIZE_STEP);++nIndex) {
      m_newVector[nIndex] = m_theVector[nIndex];
    } // end for

    delete [] m_theVector;
    m_theVector = m_newVector;
  } // end if

  ++m_nCurrent;

  m_theVector[m_nCurrent] = aElement;

} // end Tools_Vector :: push_back


//  -----------------------------------------------------------------------------
//  public function Tools_Vector::pop_back()
//  -----------------------------------------------------------------------------

template <class E> inline void Tools_Vector<E>::pop_back()
{
    m_nCurrent--;
}


//  -----------------------------------------------------------------------------
//  public function Tools_Vector::back()
//  -----------------------------------------------------------------------------

template <class E> inline E & Tools_Vector<E>::back()
{
    return m_theVector[m_nCurrent];
}

#endif // _TOOLS_VECTOR_HPP_
