#    module      : import_loader.py
#
#    responsible : 
#
#    special area: 
#
#    description : 
#
#    prerequisite: 
#
#    remarks:  
#    
#
#    ========== licence begin  GPL
#    Copyright (c) 2000-2004 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
#

#
#system
import sys
import os
import optlib
import socket
#string
import re
import regsub
import string
import tempfile
#sapdb
from sapdb import dbm,loader,sql

def _options ():
    return [
    ('demo', 'demo'             , ':', 'false'                 , 'specifies debug  mode'),                 # TRUE, FALSE
    ('n'   , 'node'             , ':', socket.gethostname()    , 'specifies servernode'),
    ('r'   , 'instroot'         , ':', ''                      , 'specifies INSTROOT path'),
    ('d'   , 'dbname'           , ':', 'sourcedb'              , 'specifies sapdb to create'),
    ('a'   , 'dbaUser'          , ':', 'DBA,DBA'               , 'specifies sapdb sysdba user'),
    ('i'   , 'init'             , ':', 'system'                , 'init sapdb'),                            # DELETE, SYSTEM, USER, CATALOG, DATA, DAV          
]

def connect ( node, instroot, dbname, dbaUser ):
    session = None
    if  node == '':
        node = socket.gethostname()
    try:
        session = loader.Loader(node, '', instroot )
        if session <> None:
           session.cmd ('use user %s %s serverdb %s on %s' % ( regsub.split(dbaUser,',') [0], regsub.split(dbaUser,',') [1], dbname, node ))
    except loader.CommunicationError, err :
           print 'command failed:', err
    except loader.LoaderError, err:
           print 'command failed:', err
    
    return session

def main (options, args):
    
    options.demo = string.upper(options.demo)
    options.init = string.upper(options.init )

    session = connect( options.node, options.instroot, options.dbname, options.dbaUser )
    
    if  session <> None:
        #DELETE
        if options.init == 'DELETE' :
           print 'Cleaning  Databasesystem %s' % options.dbname
           dbauser = regsub.split  (options.dbaUser,',')[1] 
           try:
              sqlsession = sql.connect ( dbauser, dbauser, options.dbname, options.node ) 
           except sql.SQLError, err :
              print 'command failed:' , err 

           try:  
              sqlsession.sql ( 'delete from transformationmodel' )
           except sapdb.SQLError, err :
              print 'command failed:' , err 
           
           try:  
              sqlsession.sql ( 'commit' )
           except sql.SQLError, err :
              print 'command failed:' , err 

        #DAV    
        if options.init == 'WEBDAV'  and socket.gethostname()  == 'p66796' and options.dbname <> 'LO74T' and options.dbname <> 'TARGETDB'  :
           try:
              if options.demo == 'TRUE':
                 input('Import    DAV Database ')
              if options.demo == 'FALSE':
                 print 'Import    DAV Database '
                 i = 1/0
           except:
              pass    
           davLoad (session, options) 
        #DB
        else:
           try:
              if options.demo == 'TRUE':
                 input('Import    Database ')
              if options.demo == 'FALSE':
                 print 'Import    Database '
                 i = 1/0
           except:
              pass    
           demoLoad (session, options)
       
def davLoad(session, options): 
    loaderCmd(session, ' USE USER %s %s '  % (regsub.split(options.dbaUser,',')[0], regsub.split(options.dbaUser,',')[1] ))
    
    dataLoad (session, """
             LOAD DATA TABLE "XML_ASSIGN_DC_IDX"
                             "DCID"       1 CHAR
                             "IDXID"      2 CHAR
             INFILE *
             COMPRESSED ASCII
             DECIMAL '//./' 
             DATE ISO 
             TIME ISO 
             TIMESTAMP ISO 
             NULL '?                   ' 
             BOOLEAN 'TRUE/FALSE'
             ""","""
"060000000F0EC0F46406000054420000AB7FBF2ABEFFF2AC","01000000170DC0F46406000054420000AB7FBF2ABEFFF2AC"
"060000000F0EC0F46406000054420000AB7FBF2ABEFFF2AC","020000005D0DC0F46406000054420000AB7FBF2ABEFFF2AC"
"060000000F0EC0F46406000054420000AB7FBF2ABEFFF2AC","03000000880DC0F46406000054420000AB7FBF2ABEFFF2AC"
"060000000F0EC0F46406000054420000AB7FBF2ABEFFF2AC","04000000C40DC0F46406000054420000AB7FBF2ABEFFF2AC"
"060000000F0EC0F46406000054420000AB7FBF2ABEFFF2AC","05000000F70DC0F46406000054420000AB7FBF2ABEFFF2AC"
"060000000F0EC0F46406000054420000AB7FBF2ABEFFF2AC","06000000C40DC0F46406000054420000AB7FBF2ABEFFF2AC"
"060000000F0EC0F46406000054420000AB7FBF2ABEFFF2AC","07000000F70DC0F46406000054420000AB7FBF2ABEFFF2AC"             
""")

    dataLoad (session, """
              LOAD DATA TABLE "XML_DOCUMENTCLASS" 
              "DCID"        1 CHAR 
              "NAME"        2 CHAR 
              "DESCRIPTION" 3 CHAR DEFAULT NULL 
              INFILE  *
              COMPRESSED ASCII 
              DECIMAL '//./' 
              DATE ISO 
              TIME ISO 
              TIMESTAMP ISO 
              NULL '?                   ' 
              BOOLEAN 'TRUE/FALSE'   
              ""","""
"060000000F0EC0F46406000054420000AB7FBF2ABEFFF2AC","OIM:Catalog",""
""")
    
    dataLoad (session, """
    LOAD DATA TABLE "XML_XMLINDEX" 
    "IDXID"       1 CHAR 
    "NAME"        2 CHAR DEFAULT NULL 
    "DESCRIPTION" 3 CHAR DEFAULT NULL 
    "XPATHBASE"   4 CHAR DEFAULT NULL 
    "XPATHVALUE"  5 CHAR DEFAULT NULL 
    INFILE  *
    COMPRESSED ASCII 
    DECIMAL '//./' 
    DATE ISO 
    TIME ISO 
    TIMESTAMP ISO 
    NULL '?                   ' 
    BOOLEAN 'TRUE/FALSE'    
    ""","""
"01000000110DC0F46406000054420000AB7FBF2ABEFFF2AC","Connection","","/oim:Transfer/uml:System/uml:SystemModels/uml:Model/uml:ModelPackages/dbm:ConnectionSet/dbm:ConnectionSetConnections","/sapdbm:Connection/@dbm:ConnectString"
"020000005D0DC0F46406000054420000AB7FBF2ABEFFF2AC","Catalog","","/oim:Transfer/uml:System/uml:SystemModels/uml:Model/uml:ModelPackages/dbm:DataSource/dbm:DataSourceDeployedCatalogs","/dbm:DeployedCatalog/@name"
"03000000880DC0F46406000054420000AB7FBF2ABEFFF2AC","Schema","","/oim:Transfer/uml:System/uml:SystemModels/uml:Model/uml:ModelPackages/dbm:DataSource/dbm:DataSourceDeployedCatalogs/dbm:DeployedCatalog/dbm:CatalogSchemas/uml:NamespaceOwnedElement","/sapdbm:DeployedSchema/@oim:id"
"04000000C40DC0F46406000054420000AB7FBF2ABEFFF2AC","Table","","/oim:Transfer/uml:System/uml:SystemModels/uml:Model/uml:ModelPackages/dbm:DataSource/dbm:DataSourceDeployedCatalogs/dbm:DeployedCatalog/dbm:CatalogSchemas/uml:NamespaceOwnedElement/sapdbm:DeployedSchema/uml:NamespaceOwnedElement","/sapdbm:DeployedTable/@oim:id"
"05000000F70DC0F46406000054420000AB7FBF2ABEFFF2AC","View","","/oim:Transfer/uml:System/uml:SystemModels/uml:Model/uml:ModelPackages/dbm:DataSource/dbm:DataSourceDeployedCatalogs/dbm:DeployedCatalog/dbm:CatalogSchemas/uml:NamespaceOwnedElement/sapdbm:DeployedSchema/uml:NamespaceOwnedElement","/dbm:DeployedView/@oim:id"
"06000000C40DC0F46406000054420000AB7FBF2ABEFFF2AC","Synonym","","/oim:Transfer/uml:System/uml:SystemModels/uml:Model/uml:ModelPackages/dbm:DataSource/dbm:DataSourceDeployedCatalogs/dbm:DeployedCatalog/dbm:CatalogSchemas/uml:NamespaceOwnedElement/sapdbm:DeployedSchema/uml:NamespaceOwnedElement","/dbm:TableSynonym/@oim:id"
"07000000F70DC0F46406000054420000AB7FBF2ABEFFF2AC","Column","","/oim:Transfer/uml:System/uml:SystemModels/uml:Model/uml:ModelPackages/dbm:DataSource/dbm:DataSourceDeployedCatalogs/dbm:DeployedCatalog/dbm:CatalogSchemas/uml:NamespaceOwnedElement/sapdbm:DeployedSchema/uml:NamespaceOwnedElement/sapdbm:DeployedTable/dbm:ColumnSetColumns/uml:ClassifierFeature","/dbm:DeployedColumn/@oim:id"
""") 
     
    #dav import     
    cmd = 'x_python %s -d %s -s %s -h %s -t %s' % ( os.path.join (os.environ ['INSTROOT'],'misc','sapdb','pythondef','davdoc'   ,'demo','import.py' ), options.dbname, 
                                                    os.path.join (os.environ ['INSTROOT'],'misc','sapdb','pythondef','loaderdoc','demo','sourcedb'  ), 
                                                   '%s:%s' % ( socket.gethostname(), '85'), '/webdav' )
    try:
        os.system (cmd)
    except OSError, err:
        print 'command failed:', err                                            
    
def demoLoad(session, options) :
    
    loaderCmd(session, 'SQLMODE INTERNAL')
    #format
    loaderCmd(session, 'SET COMPRESSED       \'/,/\"/\'') 
    loaderCmd(session, 'SET LANGUAGE         \'ENG\' ') 
    #datatypes
    loaderCmd(session, 'SET CODETYPE         ASCII ')
    loaderCmd(session, 'SET CODEPAGE         ISO-8859-1 ')
    loaderCmd(session, 'SET BOOLEAN          \'TRUE/FALSE\' ')
    loaderCmd(session, 'SET DECIMAL          \'//./\'') 
    loaderCmd(session, 'SET NULL             \'?                   \'')
    loaderCmd(session, 'SET DATE             ISO')
    loaderCmd(session, 'SET TIME             ISO')
    loaderCmd(session, 'SET TIMESTAMP        ISO')
    #transaction
    loaderCmd(session, 'AUTOCOMMIT ON')
    loaderCmd(session, 'SET TRANSACTION SIZE 1000')
    loaderCmd(session, 'SET MAXERRORCOUNT    100')
    #medium
    loaderCmd(session, 'SET BACKUPTOOL       NETWORKER ')
    #protocol
    loaderCmd(session, 'SET ODBCTRACE        OFF ')
                                        
    # CREATE USER
    if  options.init  == 'USER' or options.init == 'CATALOG' or options.init == 'DATA' :
        
        try:
           if options.demo == 'TRUE':
              input('Import    Database       USERS')
           if options.demo == 'FALSE':
              print 'Import    Database       USERS'
              i = 1/0
        except:
           pass

        loaderCmd(session, 'USE USER DBA DBA')
        
        if  ExistsTable (session, 'TRANSFORMATIONMODEL'):
        
            dataLoad (session, 
                      """
                      LOAD DATA TABLE TRANSFORMATIONMODEL   
                      OWNER                 1 DEFAULT      NULL TABLENAME            2 DEFAULT      NULL DATASTREAMNAME          3 DEFAULT      NULL 
                      DATASTREAMHEADERBLOCK 4 DEFAULT      NULL DATASTREAMHEADERPOS  5 DEFAULT      NULL DATASTREAMTRAILERBLOCK  6 DEFAULT      NULL DATASTREAMTRAILERPOS  7 DEFAULT      NULL  DATASTREAMDATABLOCK  8 DEFAULT      NULL DATASTREAMDATAPOS    9  DEFAULT    NULL 
                      \"EXCLUDE\"           10 DEFAULT     NULL 
                      PACKAGEGUID           11 DEFAULT     NULL TASKID              12 DEFAULT      NULL STEPID                 13 DEFAULT      NULL SERVERNODE           14 DEFAULT      NULL 
                      \"SERVERDB\"          15 DEFAULT     NULL USERNAME            16 DEFAULT      NULL \"CODETYPE\"           17 DEFAULT      NULL CODEPAGEID           18 DEFAULT      NULL 
                      \"STORAGEDEVICE\"     19 DEFAULT     NULL TRANSACTIONSIZE     20 DEFAULT      NULL TRANSFORMATION         21 DEFAULT      NULL PART                 22 DEFAULT      NULL  TABLETYPE            23 DEFAULT      NULL 
                      CATALOGSTREAMNAME     24 DEFAULT     NULL CATALOGSTREAMTYPE   25 DEFAULT      NULL CATALOGSTREAMEBID      26 DEFAULT      NULL CATALOGSTREAMFORMAT  27 DEFAULT      NULL  DATASTREAMTYPE       28 DEFAULT      NULL  DATASTREAMEBID     29 DEFAULT     NULL 
                      DATASTREAMFORMAT      30 DEFAULT     NULL \"RESTART\"         31 DEFAULT      NULL RESTORE                32 DEFAULT      NULL PAGECOUNT            33 DEFAULT      NULL 
                      ROWCOUNT              34 DEFAULT     NULL STARTTIME           35 DEFAULT      NULL ENDTIME                36 DEFAULT      NULL REQUESTTIME          37 DEFAULT      NULL 
                      RECEIVETIME           38 DEFAULT     NULL IOTIME              39 DEFAULT      NULL LOGTIME                40 DEFAULT      NULL 
                      INFILE *  COMPRESSED 
                      DECIMAL '/ /./' DATE INTERNAL TIME INTERNAL TIMESTAMP INTERNAL NULL '?                   ' BOOLEAN 'TRUE/FALSE' ""","""
"EDEMO","PHOTOS","SOURCEDB.data","0","0","0","431972","0","432996","FALSE","100000000000000000000000000000000000000000000000","1","1","LOCALHOST","SOURCEDB","DBA","ASCII","ISO-8859-1","NSR","1000","EXTRACT","ALL","TABLE","SOURCEDB.catalog","FILE","","DDL","FILE","","RECORDS","FALSE","FALSE","0","14","20021206112910213000","20021206112915440000","0.0300000000","5.1480000000","0.0000000000","0.0100000000"
"EDEMO","REQUESTS","SOURCEDB.data","0","432996","0","435838","0","436862","FALSE","100000000000000000000000000000000000000000000000","1","2","LOCALHOST","SOURCEDB","DBA","ASCII","ISO-8859-1","NSR","1000","EXTRACT","ALL","TABLE","SOURCEDB.catalog","FILE","","DDL","FILE","","RECORDS","FALSE","FALSE","0","6","20021206112915450000","20021206112915511000","0.0000000000","0.0000000000","0.0000000000","0.0100000000"
"SQLTRAVEL00","ACCOUNT","SOURCEDB.data","0","436862","0","438415","0","439439","FALSE","100000000000000000000000000000000000000000000000","1","3","LOCALHOST","SOURCEDB","DBA","ASCII","ISO-8859-1","NSR","1000","EXTRACT","ALL","TABLE","SOURCEDB.catalog","FILE","","DDL","FILE","","RECORDS","FALSE","FALSE","0","28","20021206112915521000","20021206112915601000","0.0000000000","0.0000000000","0.0000000000","0.0200000000"
"SQLTRAVEL00","CITY","SOURCEDB.data","0","439439","0","441014","0","442038","FALSE","100000000000000000000000000000000000000000000000","1","15","LOCALHOST","SOURCEDB","DBA","ASCII","ISO-8859-1","NSR","1000","EXTRACT","ALL","TABLE","SOURCEDB.catalog","FILE","","DDL","FILE","","RECORDS","FALSE","FALSE","0","25","20021206112915621000","20021206112915701000","0.0000000000","0.0000000000","0.0000000000","0.0200000000"
"EDEMO","CATEGORIES","SOURCEDB.data","0","442038","0","528899","0","529923","FALSE","100000000000000000000000000000000000000000000000","1","29","LOCALHOST","SOURCEDB","DBA","ASCII","ISO-8859-1","NSR","1000","EXTRACT","ALL","TABLE","SOURCEDB.catalog","FILE","","DDL","FILE","","RECORDS","FALSE","FALSE","0","8","20021206112915711000","20021206112920938000","0.0000000000","5.1480000000","0.0000000000","0.0200000000"
"EDEMO","SUPPLIERS","SOURCEDB.data","0","529923","0","534800","0","535824","FALSE","100000000000000000000000000000000000000000000000","1","30","LOCALHOST","SOURCEDB","DBA","ASCII","ISO-8859-1","NSR","1000","EXTRACT","ALL","TABLE","SOURCEDB.catalog","FILE","","DDL","FILE","","RECORDS","FALSE","FALSE","0","29","20021206112920948000","20021206112921008000","0.0100000000","0.0000000000","0.0000000000","0.0200000000"
"EDEMO","CUSTOMERS","SOURCEDB.data","0","535824","0","549174","0","550198","FALSE","100000000000000000000000000000000000000000000000","1","31","LOCALHOST","SOURCEDB","DBA","ASCII","ISO-8859-1","NSR","1000","EXTRACT","ALL","TABLE","SOURCEDB.catalog","FILE","","DDL","FILE","","RECORDS","FALSE","FALSE","0","91","20021206112921018000","20021206112921089000","0.0000000000","0.0000000000","0.0000000000","0.0100000000"
"EDEMO","EMPLOYEES","SOURCEDB.data","0","550198","0","880876","0","881900","FALSE","100000000000000000000000000000000000000000000000","1","32","LOCALHOST","SOURCEDB","DBA","ASCII","ISO-8859-1","NSR","1000","EXTRACT","ALL","TABLE","SOURCEDB.catalog","FILE","","DDL","FILE","","RECORDS","FALSE","FALSE","0","15","20021206112921099000","20021206112926556000","0.0100000000","5.3980000000","0.0000000000","0.0200000000"
"EDEMO","SHIPPERS","SOURCEDB.data","0","881900","0","882983","0","884007","FALSE","100000000000000000000000000000000000000000000000","1","33","LOCALHOST","SOURCEDB","DBA","ASCII","ISO-8859-1","NSR","1000","EXTRACT","ALL","TABLE","SOURCEDB.catalog","FILE","","DDL","FILE","","RECORDS","FALSE","FALSE","0","3","20021206112926566000","20021206112926627000","0.0000000000","0.0000000000","0.0000000000","0.0000000000"
"SQLTRAVEL00","CUSTOMER","SOURCEDB.data","0","884007","0","885841","0","886865","FALSE","100000000000000000000000000000000000000000000000","1","34","LOCALHOST","SOURCEDB","DBA","ASCII","ISO-8859-1","NSR","1000","EXTRACT","ALL","TABLE","SOURCEDB.catalog","FILE","","DDL","FILE","","RECORDS","FALSE","FALSE","0","15","20021206112926637000","20021206112926727000","0.0000000000","0.0000000000","0.0000000000","0.0200000000"
"SQLTRAVEL10","HOTEL","SOURCEDB.data","0","886865","0","890496","0","891520","FALSE","100000000000000000000000000000000000000000000000","1","48","LOCALHOST","SOURCEDB","DBA","ASCII","ISO-8859-1","NSR","1000","EXTRACT","ALL","TABLE","SOURCEDB.catalog","FILE","","DDL","FILE","","RECORDS","FALSE","FALSE","0","15","20021206112926737000","20021206112926817000","0.0000000000","0.0000000000","0.0000000000","0.0200000000"
"EDEMO","PRODUCTS","SOURCEDB.data","0","891520","0","898933","0","899957","FALSE","100000000000000000000000000000000000000000000000","1","62","LOCALHOST","SOURCEDB","DBA","ASCII","ISO-8859-1","NSR","1000","EXTRACT","ALL","TABLE","SOURCEDB.catalog","FILE","","DDL","FILE","","RECORDS","FALSE","FALSE","0","77","20021206112926827000","20021206112926887000","0.0000000000","0.0000000000","0.0000000000","0.0100000000"
"EDEMO","ORDERS","SOURCEDB.data","0","899957","0","1045100","0","1046124","FALSE","100000000000000000000000000000000000000000000000","1","63","LOCALHOST","SOURCEDB","DBA","ASCII","ISO-8859-1","NSR","1000","EXTRACT","ALL","TABLE","SOURCEDB.catalog","FILE","","DDL","FILE","","RECORDS","FALSE","FALSE","0","1078","20021206112926907000","20021206112927007000","0.0300000000","0.0000000000","0.0000000000","0.0100000000"
"SQLTRAVEL10","ROOM","SOURCEDB.data","0","1046124","0","1048059","0","1049083","FALSE","100000000000000000000000000000000000000000000000","1","64","LOCALHOST","SOURCEDB","DBA","ASCII","ISO-8859-1","NSR","1000","EXTRACT","ALL","TABLE","SOURCEDB.catalog","FILE","","DDL","FILE","","RECORDS","FALSE","FALSE","0","38","20021206112927017000","20021206112927097000","0.0000000000","0.0000000000","0.0000000000","0.0100000000"
"EDEMO","ORDERDETAILS","SOURCEDB.data","0","1049083","0","1164945","0","1165969","FALSE","100000000000000000000000000000000000000000000000","1","78","LOCALHOST","SOURCEDB","DBA","ASCII","ISO-8859-1","NSR","1000","EXTRACT","ALL","TABLE","SOURCEDB.catalog","FILE","","DDL","FILE","","RECORDS","FALSE","FALSE","0","2820","20021206112927107000","20021206112927217000","0.0000000000","0.0000000000","0.0100000000","0.0100000000"
"SQLTRAVEL20","RESERVATION","SOURCEDB.data","0","1165969","0","1167426","0","1168450","FALSE","100000000000000000000000000000000000000000000000","1","79","LOCALHOST","SOURCEDB","DBA","ASCII","ISO-8859-1","NSR","1000","EXTRACT","ALL","TABLE","SOURCEDB.catalog","FILE","","DDL","FILE","","RECORDS","FALSE","FALSE","0","10","20021206112927227000","20021206112927307000","0.0000000000","0.0000000000","0.0000000000","0.0100000000"
""")
              
        if not ExistsUser (session, 'MIGRATE'):
           loaderCmd(session, 'CREATE USER MIGRATE PASSWORD initial DBA NOT EXCLUSIVE')

        if not ExistsUser (session, 'EDEMO'):
           loaderCmd(session, 'CREATE USER EDEMO PASSWORD initial DBA NOT EXCLUSIVE')

        if not ExistsUser (session, 'SQLTRAVEL00'):
           loaderCmd(session, 'CREATE USER sqltravel00 PASSWORD initial DBA NOT EXCLUSIVE')

        if not ExistsUser (session, 'SQLTRAVEL10'):
           loaderCmd(session, 'CREATE USER sqltravel10 PASSWORD initial DBA NOT EXCLUSIVE')

        if not ExistsUser (session, 'SQLTRAVEL20'):
           loaderCmd(session, 'CREATE USER sqltravel20 PASSWORD initial DBA NOT EXCLUSIVE')


        loaderCmd(session, 'USE USER sqltravel00 initial')

        if not ExistsUser (session, 'SQLTRAVEL01'):
           loaderCmd(session, 'CREATE USER sqltravel01 PASSWORD initial RESOURCE')
        if not ExistsUser (session, 'SQLTRAVEL02'):
           loaderCmd(session, 'CREATE USER sqltravel02 PASSWORD initial RESOURCE')
        if not ExistsUser (session, 'SQLTRAVEL03'):
           loaderCmd(session, 'CREATE USER sqltravel03 PASSWORD initial RESOURCE')

        loaderCmd(session, 'USE USER sqltravel10 initial')

        if not ExistsUser (session, 'SQLTRAVEL11'):
           loaderCmd(session, 'CREATE USER sqltravel11 PASSWORD initial RESOURCE')
        if not ExistsUser (session, 'SQLTRAVEL12'):
           loaderCmd(session, 'CREATE USER sqltravel12 PASSWORD initial RESOURCE')
        if not ExistsUser (session, 'SQLTRAVEL13'):
           loaderCmd(session, 'CREATE USER sqltravel13 PASSWORD initial RESOURCE')

        loaderCmd(session, 'USE USER sqltravel20 initial')

        if not ExistsUser (session, 'SQLTRAVEL21'):
           loaderCmd(session, """CREATE USER sqltravel21 PASSWORD initial RESOURCE""")
        if not ExistsUser (session, 'SQLTRAVEL22'):
           loaderCmd(session, 'CREATE USER sqltravel22 PASSWORD initial RESOURCE')
        if not ExistsUser (session, 'SQLTRAVEL23'):
           loaderCmd(session, 'CREATE USER sqltravel23 PASSWORD initial RESOURCE')


    #CREATE CATALOG
    if  options.init == 'CATALOG' or options.init == 'DATA' :
        
        try:
           if options.demo == 'TRUE':
              input('Import    Database       CATALOG')
           if options.demo == 'FALSE':
              print 'Import    Database       CATALOG'
              i = 1/0
        except:
           pass

        loaderCmd(session, 'USE USER sqltravel00 initial')

        if not ExistsUser (session, 'SQLTRAVEL01'):
           loaderCmd(session, 'CREATE USER sqltravel01 PASSWORD initial RESOURCE')
        if not ExistsUser (session, 'SQLTRAVEL02'):
           loaderCmd(session, 'CREATE USER sqltravel02 PASSWORD initial RESOURCE')
        if not ExistsUser (session, 'SQLTRAVEL03'):
           loaderCmd(session, 'CREATE USER sqltravel03 PASSWORD initial RESOURCE')

        loaderCmd(session, 'USE USER sqltravel10 initial')

        if not ExistsUser (session, 'SQLTRAVEL11'):
           loaderCmd(session, 'CREATE USER sqltravel11 PASSWORD initial RESOURCE')
        if not ExistsUser (session, 'SQLTRAVEL12'):
           loaderCmd(session, 'CREATE USER sqltravel12 PASSWORD initial RESOURCE')
        if not ExistsUser (session, 'SQLTRAVEL13'):
           loaderCmd(session, 'CREATE USER sqltravel13 PASSWORD initial RESOURCE')

        loaderCmd(session, 'USE USER sqltravel20 initial')

        if not ExistsUser (session, 'SQLTRAVEL21'):
           loaderCmd(session, """CREATE USER sqltravel21 PASSWORD initial RESOURCE""")
        if not ExistsUser (session, 'SQLTRAVEL22'):
           loaderCmd(session, 'CREATE USER sqltravel22 PASSWORD initial RESOURCE')
        if not ExistsUser (session, 'SQLTRAVEL23'):
           loaderCmd(session, 'CREATE USER sqltravel23 PASSWORD initial RESOURCE')

        # CREATE TABLES
        loaderCmd(session, 'USE USER sqltravel00 initial')

        if ExistsDomain (session, 'CNO_DOM'):
           loaderCmd(session, 'DROP DOMAIN cno_dom')
        loaderCmd(session, """CREATE DOMAIN cno_dom FIXED (4)
            CONSTRAINT cno_dom BETWEEN 1 AND 9999""")

        if ExistsDomain (session, 'ZIP_DOM'):
           loaderCmd(session, 'DROP DOMAIN zip_dom')
        loaderCmd(session, """CREATE DOMAIN zip_dom CHAR (5) 
        CONSTRAINT \n
        SUBSTR(zip_dom,1,1) between '1' AND '9' AND 
        SUBSTR(zip_dom,2,1) between '0' AND '9' AND 
        SUBSTR(zip_dom,3,1) between '0' AND '9' AND 
        SUBSTR(zip_dom,4,1) between '0' AND '9' AND 
        SUBSTR(zip_dom,5,1) between '0' AND '9' """)

        if ExistsTable (session, 'CITY'):
           loaderCmd(session, 'DROP TABLE city')
        loaderCmd(session, """ CREATE TABLE city
            (zip                zip_dom     KEY,
             name               CHAR(20)    NOT NULL,
             state              CHAR(2)     NOT NULL)""")

        if ExistsTable (session, 'CUSTOMER'):
           loaderCmd(session, 'DROP TABLE customer')
        loaderCmd(session, """CREATE TABLE customer
            (cno                cno_dom     KEY,
             title              CHAR (7)    CONSTRAINT title IN ('Mr', 'Mrs', 'Company'),
             firstname          CHAR (10)   ,
             name               CHAR (10)   NOT NULL,
             zip                zip_dom     ,
             address            CHAR (25)   NOT NULL,
             FOREIGN KEY (zip) REFERENCES sqltravel00.city ON DELETE RESTRICT)""")

        loaderCmd(session, """CREATE INDEX customer_index ON customer (name)""")

        loaderCmd(session, """CREATE VIEW customer_addr
            (c_no, c_title, c_name, c_firstname,
            c_zip, c_city, c_state, c_address)
            AS SELECT cno, title, customer.name, firstname,
            customer.zip, city.name, state,
            customer.address
            FROM   customer, city
            WHERE  customer.zip = city.zip
            WITH CHECK OPTION""")



        if ExistsTable (session, 'ACCOUNT'):
            loaderCmd(session, 'DROP TABLE account')

        loaderCmd(session,"""CREATE TABLE account
            (booking_day                           DATE      KEY,
            booking_day_default_date_value         DATE      DEFAULT '19670302',
            booking_day_default_time_value         TIME      DEFAULT '00051600',
            booking_day_default_timestamp_va       TIMESTAMP DEFAULT '19670302051600000000',
            booking_day_default_date_fu            DATE      DEFAULT DATE,
            booking_day_default_time_fu            TIME      DEFAULT TIME,
            booking_day_default_timestamp_fu       TIMESTAMP DEFAULT TIMESTAMP,
            activities                             FIXED (6,2) )""")

        loaderCmd(session,"""GRANT ALL ON city TO
            sqltravel01,sqltravel02,sqltravel03,
            sqltravel11,sqltravel12,sqltravel13,
            sqltravel21,sqltravel22,sqltravel23""")

        loaderCmd(session,"""GRANT ALL ON city TO
            sqltravel10, sqltravel20 WITH GRANT OPTION""")

        loaderCmd(session,"""GRANT ALL ON customer TO
            sqltravel01,sqltravel02,sqltravel03,
            sqltravel11,sqltravel12,sqltravel13,
            sqltravel21,sqltravel22,sqltravel23""")

        loaderCmd(session,"""GRANT ALL ON customer TO
            sqltravel10,sqltravel20 WITH GRANT OPTION""")

        loaderCmd(session,"""GRANT ALL ON customer_addr TO
            sqltravel01,sqltravel02,sqltravel03,
            sqltravel11,sqltravel12,sqltravel13,
            sqltravel21,sqltravel22,sqltravel23""")

        loaderCmd(session,"""GRANT ALL ON customer_addr TO
            sqltravel10,sqltravel20 WITH GRANT OPTION""")

        loaderCmd(session,"""GRANT ALL ON account TO
            sqltravel01,sqltravel02,sqltravel03,
            sqltravel10,sqltravel11,sqltravel12,sqltravel13,
            sqltravel20,sqltravel21,sqltravel22,sqltravel23""")


        loaderCmd(session, 'USE USER sqltravel10 initial')

        if ExistsDomain (session, 'HNO_DOM'):
            loaderCmd(session, 'DROP DOMAIN hno_dom')
        loaderCmd(session, """CREATE DOMAIN hno_dom FIXED (4) CONSTRAINT hno_dom BETWEEN 1 AND 9999""")

        if ExistsDomain (session, 'ROOM_DOM'):
            loaderCmd(session, 'DROP DOMAIN room_dom')
        loaderCmd(session, """CREATE DOMAIN room_dom CHAR (6) CONSTRAINT room_dom IN ('single', 'double','suite')""")

        if ExistsTable (session, 'HOTEL'):
            loaderCmd(session, 'DROP TABLE hotel')

        loaderCmd(session,"""CREATE TABLE hotel
            (hno                hno_dom     KEY,
             name               CHAR (15)   NOT NULL,
             zip                sqltravel00.zip_dom     NOT NULL,
             address            CHAR (25)   NOT NULL,
             info               LONG        ,
             FOREIGN KEY (zip) REFERENCES sqltravel00.city ON DELETE RESTRICT)""")

        if ExistsTable (session, 'ROOM'):
            loaderCmd(session, 'DROP TABLE room')

        loaderCmd(session,"""CREATE TABLE room
            (hno                hno_dom     KEY,
             roomtype           room_dom    KEY,
             max_free           FIXED(3,0)  CONSTRAINT max_free >= 0,
             price              FIXED(6,2)  CONSTRAINT price BETWEEN 0.00 AND 5000.00,
             FOREIGN KEY (hno) REFERENCES sqltravel10.hotel ON DELETE CASCADE)""")

        loaderCmd(session,"""CREATE VIEW hotel_addr (h_no, h_name, h_zip, h_city, h_state, h_address)
              AS SELECT hno, hotel.name, hotel.zip, city.name,
                        state, hotel.address
                        FROM   hotel, sqltravel00.city
                        WHERE  hotel.zip = city.zip
                        WITH CHECK OPTION""")

        loaderCmd(session,"""GRANT ALL ON hotel TO sqltravel01,sqltravel02,sqltravel03,
                          sqltravel11,sqltravel12,sqltravel13,
                          sqltravel21,sqltravel22,sqltravel23""")
                          
        #loaderCmd(session,"""GRANT SELECT,INSERT ON hotel TO PUBLIC""") #                     

        loaderCmd(session,"""GRANT ALL ON hotel TO sqltravel00,sqltravel20 WITH GRANT OPTION""")

        loaderCmd(session,"""GRANT ALL ON room TO sqltravel01,sqltravel02,sqltravel03,
                         sqltravel11,sqltravel12,sqltravel13,
                         sqltravel21,sqltravel22,sqltravel23""")

        loaderCmd(session,"""GRANT ALL ON room TO sqltravel00,sqltravel20 WITH GRANT OPTION""")

        loaderCmd(session,"""GRANT ALL ON hotel_addr TO sqltravel01,sqltravel02,sqltravel03,
                               sqltravel11,sqltravel12,sqltravel13,
                               sqltravel21,sqltravel22,sqltravel23""")

        loaderCmd(session,"""GRANT ALL ON hotel_addr TO sqltravel00,sqltravel20 WITH GRANT OPTION""")

        loaderCmd(session, 'USE USER sqltravel20 initial')

        if ExistsDomain (session, 'RNO_DOM'):
            loaderCmd(session, 'DROP DOMAIN rno_dom')
        loaderCmd(session, """CREATE DOMAIN rno_dom FIXED (4)
            CONSTRAINT rno_dom BETWEEN 1 AND 9999""")

        if ExistsTable (session, 'RESERVATION'):
            loaderCmd(session, 'DROP TABLE reservation')
        loaderCmd(session, """ CREATE TABLE reservation
            (rno                rno_dom     KEY,
             cno                sqltravel00.cno_dom     ,
             hno                sqltravel10.hno_dom     ,
             roomtype           sqltravel10.room_dom    ,
             arrival            DATE        NOT NULL,
             departure          DATE        NOT NULL CONSTRAINT departure > arrival,
             FOREIGN KEY (cno) REFERENCES sqltravel00.customer ON DELETE CASCADE,
             FOREIGN KEY (hno,roomtype) REFERENCES sqltravel10.room ON DELETE CASCADE)""")

        loaderCmd(session,"""GRANT ALL ON reservation TO
             sqltravel00,sqltravel01,sqltravel02,sqltravel03,
             sqltravel10,sqltravel11,sqltravel12,sqltravel13,
             sqltravel21,sqltravel22,sqltravel23""")

        loaderCmd(session,"""CREATE VIEW custom_hotel
            (customname, customcity, hotelname, hotelcity)
              AS SELECT c_name, c_city, h_name, h_city
              FROM  sqltravel00.customer_addr,
                    sqltravel10.hotel_addr,
                    reservation
              WHERE c_no = reservation.cno
              AND   h_no = reservation.hno""")

        loaderCmd(session,"""GRANT ALL ON custom_hotel TO
                sqltravel00,sqltravel01,sqltravel02,sqltravel03,
                sqltravel10,sqltravel11,sqltravel12,sqltravel13,
                sqltravel21,sqltravel22,sqltravel23""")

        loaderCmd(session,"""USE USER sqltravel00 initial""")

        loaderCmd(session,"""CREATE SYNONYM hotel        FOR sqltravel10.hotel""")
        loaderCmd(session,"""CREATE SYNONYM room         FOR sqltravel10.room""")
        loaderCmd(session,"""CREATE SYNONYM reservation  FOR sqltravel20.reservation""")
        loaderCmd(session,"""CREATE SYNONYM hotel_addr   FOR sqltravel10.hotel_addr""")
        loaderCmd(session,"""CREATE SYNONYM custom_hotel FOR sqltravel20.custom_hotel""")
        
        #loaderCmd(session,"""GRANT SELECT ON hotel TO PUBLIC """) #

        loaderCmd(session,"""USE USER sqltravel10 initial""")

        loaderCmd(session,"""CREATE SYNONYM city          FOR sqltravel00.city""")
        loaderCmd(session,"""CREATE SYNONYM customer      FOR sqltravel00.customer""")
        loaderCmd(session,"""CREATE SYNONYM account       FOR sqltravel00.account""")
        loaderCmd(session,"""CREATE SYNONYM reservation   FOR sqltravel20.reservation""")
        loaderCmd(session,"""CREATE SYNONYM customer_addr FOR sqltravel00.customer_addr""")
        loaderCmd(session,"""CREATE SYNONYM custom_hotel  FOR sqltravel20.custom_hotel""")



        loaderCmd(session,"""USE USER sqltravel20 initial""")

        loaderCmd(session,"""CREATE SYNONYM city          FOR sqltravel00.city""")
        loaderCmd(session,"""CREATE SYNONYM customer      FOR sqltravel00.customer""")
        loaderCmd(session,"""CREATE SYNONYM account       FOR sqltravel00.account""")
        loaderCmd(session,"""CREATE SYNONYM hotel         FOR sqltravel10.hotel""")
        loaderCmd(session,"""CREATE SYNONYM room          FOR sqltravel10.room""")
        loaderCmd(session,"""CREATE SYNONYM customer_addr FOR sqltravel00.customer_addr""")
        loaderCmd(session,"""CREATE SYNONYM hotel_addr    FOR sqltravel10.hotel_addr""")


        loaderCmd(session,"""USE USER EDEMO initial""")
        if ExistsSequence (session, 'SEQ1') :
           loaderCmd(session, 'DROP SEQUENCE SEQ1')
        loaderCmd(session, 'CREATE SEQUENCE  SEQ1 MINVALUE 2    NOMAXVALUE         START  WITH 2    INCREMENT BY   2  NOCYCLE  NOCACHE')
        if ExistsSequence (session, 'SEQ2') :
           loaderCmd(session, 'DROP SEQUENCE SEQ2')
        loaderCmd(session, 'CREATE SEQUENCE  SEQ2 MINVALUE 10   MAXVALUE 200       START  WITH 190  INCREMENT BY  10  NOCYCLE  NOCACHE')
        if ExistsSequence (session, 'SEQ3') :
           loaderCmd(session, 'DROP SEQUENCE SEQ3')
        loaderCmd(session, 'CREATE SEQUENCE  SEQ3 MINVALUE 1    MAXVALUE 100000000 START  WITH 226  INCREMENT BY   1  NOCYCLE  CACHE 1 ORDER') 
        if ExistsSequence (session, 'SEQ4') :
           loaderCmd(session, 'DROP SEQUENCE SEQ4')
        loaderCmd(session, 'CREATE SEQUENCE  SEQ4 NOMINVALUE    MAXVALUE 10        START  WITH 10   INCREMENT BY -10  NOCYCLE  NOCACHE')
        if ExistsSequence (session, 'SEQ5') :
           loaderCmd(session, 'DROP SEQUENCE SEQ5')
        loaderCmd(session, 'CREATE SEQUENCE  SEQ5 MINVALUE 100  NOMAXVALUE         START  WITH 2235 INCREMENT BY   1  NOCYCLE  CACHE 1 ORDER')
        
        #select OWNER, SEQUENCE_NAME, MIN_VALUE, MAX_VALUE,LAST_NUMBER,INCREMENT_BY, CYCLE_FLAG, CACHE_SIZE, ORDER_FLAG from sequences where SEQUENCE_NAME ='SEQ'

        if ExistsDBProcedure (session, 'DO_INSERTS_1') :
           loaderCmd(session, 'DROP DBPROCEDURE DO_INSERTS_1')
        loaderCmd(session,"""CREATE DBPROC DO_INSERTS_1
	                     AS VAR I INTEGER;
		             SET I = 1;
		             WHILE I <= 20 DO BEGIN
			           SET I = I + 1;
		             END;""")
        if ExistsDBProcedure (session, 'DO_INSERTS_2') :
           loaderCmd(session, 'DROP DBPROCEDURE DO_INSERTS_2')
        loaderCmd(session,"""CREATE DBPROC DO_INSERTS_2
	                     AS VAR I INTEGER;
		             SET I = 1;
		             WHILE I <= 20 DO BEGIN
			           SET I = I + 1;
		             END;""")


        if ExistsTable (session, 'CATEGORIES'):
            loaderCmd(session, 'DROP TABLE categories')
        loaderCmd(session,"""CREATE TABLE CATEGORIES (
            CATEGORYID       INTEGER   ,
            CATEGORYNAME     VARCHAR   (16)     NOT NULL,
            DESCRIPTION      LONG          ,
            PICTURE          LONG      BYTE
            , PRIMARY KEY (CATEGORYID))""")

        loaderCmd(session,"""CREATE UNIQUE INDEX CATEGORYNAME ON
            EDEMO.CATEGORIES (CATEGORYNAME ASC )""")

        if ExistsTable (session, 'SUPPLIERS'):
            loaderCmd(session, 'DROP TABLE suppliers')
        loaderCmd(session,"""CREATE TABLE SUPPLIERS (
            SUPPLIERID        INTEGER   ,
            COMPANYNAME       VARCHAR   (40)     NOT NULL,
            CONTACTNAME       VARCHAR   (30)     ,
            CONTACTTITLE      VARCHAR   (32)     ,
            ADDRESS           VARCHAR   (60)     ,
            CITY              VARCHAR   (15)     ,
            REGION            VARCHAR   (15)     ,
            POSTALCODE        VARCHAR   (10)     ,
            COUNTRY           VARCHAR   (15)     ,
            PHONE             VARCHAR   (24)     ,
            FAX               VARCHAR   (24) 
            , PRIMARY KEY (SUPPLIERID))""")

        loaderCmd(session,"""CREATE INDEX CompanyName ON EDEMO.Suppliers (CompanyName ASC )""")

        if ExistsTable (session, 'CUSTOMERS'):
            loaderCmd(session, 'DROP TABLE Customers')
        loaderCmd(session,"""CREATE TABLE Customers (
            CustomerID        VARCHAR   (5)     ,
            CompanyName       VARCHAR   (40)     NOT NULL,
            ContactName       VARCHAR   (30)     ,
            ContactTitle      VARCHAR   (30)     ,
            Address           VARCHAR   (60)     ,
            City              VARCHAR   (15)     ,
            Region            VARCHAR   (15)     ,
            PostalCode        VARCHAR   (10)     ,
            Country           VARCHAR   (15)     ,
            Phone             VARCHAR   (24)     ,
            Fax               VARCHAR   (24) 
            , PRIMARY KEY (CustomerID))""")

        loaderCmd(session,"""CREATE INDEX CompanyName ON EDEMO.Customers (CompanyName ASC )""")
        loaderCmd(session,"""CREATE INDEX City ON EDEMO.Customers (City ASC )""")
        loaderCmd(session,"""CREATE INDEX Region ON EDEMO.Customers (Region ASC )""")



        if ExistsTable (session, 'EMPLOYEES'):
            loaderCmd(session, 'DROP TABLE Employees')
        loaderCmd(session,"""CREATE TABLE EDEMO.Employees (
            EmployeeID        INTEGER   ,
            LastName          VARCHAR   (20)     NOT NULL,
            FirstName         VARCHAR   (10)     NOT NULL,
            Title             VARCHAR   (30)     ,
            BirthDate         DATE    ,
            HireDate          DATE    ,
            Address           VARCHAR   (60)     ,
            City              VARCHAR   (15)     ,
            Region            VARCHAR   (15)     ,
            PostalCode        VARCHAR   (10)     ,
            Country           VARCHAR   (15)     ,
            HomePhone         VARCHAR   (24)     ,
            Extension         VARCHAR   (4)      ,
            Photo             LONG      BYTE     ,
            Notes             LONG          ,
            ReportsTo         INTEGER
            , PRIMARY KEY (EmployeeID))""")

        loaderCmd(session,"""CREATE INDEX LastName ON EDEMO.Employees (LastName ASC )""")


        if ExistsTable (session, 'SHIPPERS'):
            loaderCmd(session, 'DROP TABLE Shippers')
        loaderCmd(session,"""CREATE TABLE Shippers (
            ShipperID         INTEGER   ,
            Companyname       VARCHAR   (40)     NOT NULL
            , PRIMARY KEY (ShipperID))""")
            
        if ExistsTable (session, 'PRODUCTS'):
            loaderCmd(session, 'DROP TABLE PRODUCTS')
        loaderCmd(session,"""CREATE TABLE PRODUCTS (
            ProductID         INTEGER   ,
            SupplierID        INTEGER   ,
            CategoryID        INTEGER   ,
            Productname       VARCHAR   (40) ,
            QuantityPerUnit   VARCHAR   (23) ,
            UnitPrice         FLOAT     (8)  ,
            UnitsInStock      SMALLINT  ,
            UnitsOnOrder      SMALLINT  ,
            ReorderLevel      SMALLINT  ,
            Discontinued      BOOLEAN DEFAULT  FALSE,
            BarcodeID         CHAR      (10)   BYTE DEFAULT x'0086B22A318528A4D7' ,
            PRIMARY KEY (ProductID))""")

        loaderCmd(session,"""ALTER TABLE EDEMO.Products FOREIGN KEY CategoryProduct
            (CategoryID
            ) REFERENCES EDEMO.Categories
            (CategoryID
            ) ON DELETE RESTRICT""")



        loaderCmd(session,"""ALTER TABLE EDEMO.Products FOREIGN KEY SupplierProduct
            (SupplierID
            ) REFERENCES EDEMO.Suppliers
            (SupplierID
            ) ON DELETE RESTRICT""")


        loaderCmd(session,"""CREATE INDEX ProductName ON EDEMO.Products (Productname ASC )""")
        loaderCmd(session,"""CREATE INDEX CategoryID  ON EDEMO.Products (CategoryID ASC )""")
        loaderCmd(session,"""CREATE INDEX SupplierID  ON EDEMO.Products (SupplierID ASC )""")

        if ExistsTable (session, 'ORDERS'):
            loaderCmd(session, 'DROP TABLE ORDERS')
        loaderCmd(session,"""CREATE TABLE EDEMO.ORDERS (
            OrderID           INTEGER   ,
            CustomerID        VARCHAR   (5)     NOT NULL,
            EmployeeID        INTEGER   ,
            Shipname          VARCHAR   (40)     ,
            ShipAddress       VARCHAR   (60)     ,
            ShipCity          VARCHAR   (15)     ,
            ShipRegion        VARCHAR   (15)     ,
            ShipPostalCode    VARCHAR   (10)     ,
            ShipCountry       VARCHAR   (15)     ,
            ShipVia           INTEGER   ,
            OrderDate         DATE    ,
            RequiredDate      DATE    ,
            ShippedDate       DATE    ,
            Freight           FLOAT     (8)
            , PRIMARY KEY (OrderID
            ))""")

        loaderCmd(session,"""ALTER TABLE EDEMO.Orders FOREIGN KEY CustomerOrder
            (CustomerID
            ) REFERENCES EDEMO.Customers
            (CustomerID
            ) ON DELETE RESTRICT""")



        loaderCmd(session,"""ALTER TABLE EDEMO.Orders FOREIGN KEY EmployeeOrder
            (EmployeeID
            ) REFERENCES EDEMO.Employees
            (EmployeeID
            ) ON DELETE RESTRICT""")



        loaderCmd(session,"""ALTER TABLE EDEMO.Orders FOREIGN KEY ShipperOrder
            (ShipVia
            ) REFERENCES EDEMO.Shippers
            (ShipperID
            ) ON DELETE RESTRICT""")

        loaderCmd(session,"""CREATE INDEX OrderDate  ON EDEMO.Orders (OrderDate ASC )""")
        loaderCmd(session,"""CREATE INDEX CustomerID ON EDEMO.Orders (CustomerID ASC )""")
        loaderCmd(session,"""CREATE INDEX EmployeeID ON EDEMO.Orders (EmployeeID ASC )""")

        if ExistsTable (session, 'ORDERDETAILS'):
            loaderCmd(session, 'DROP TABLE ORDERDETAILS')
        loaderCmd(session,"""CREATE TABLE EDEMO.ORDERDETAILS (
            OrderID           INTEGER   ,
            ProductID         INTEGER   ,
            UnitPrice         FLOAT     (8) NOT NULL,
            Quantity          SMALLINT DEFAULT  1,
            Discount          FLOAT(4) DEFAULT  0.000E+00,
            CONSTRAINT Quantity CHECK Quantity>0,
            CONSTRAINT Discount CHECK Discount BETWEEN 0 AND 1
            , PRIMARY KEY (OrderID,ProductID))""")

        loaderCmd(session,"""ALTER TABLE EDEMO.OrderDetails FOREIGN KEY ProductOrderDetails
            (ProductID
            ) REFERENCES EDEMO.Products
            (ProductID
            ) ON DELETE RESTRICT""")



        loaderCmd(session,"""ALTER TABLE EDEMO.OrderDetails FOREIGN KEY OrderOrderDetail
            (OrderID
            ) REFERENCES EDEMO.Orders
            (OrderID
            ) ON DELETE CASCADE""")

        loaderCmd(session,"""CREATE INDEX ProductID ON EDEMO.OrderDetails (ProductID ASC )""")
        loaderCmd(session,"""COMMENT ON COLUMN OrderDetails.OrderID     IS 'Same as OrderID in Orders Table.'""")
        loaderCmd(session,"""COMMENT ON COLUMN OrderDetails.ProductID   IS 'Same as ProductID in Products table.'""")
        loaderCmd(session,"""COMMENT ON COLUMN Products.ProductID       IS 'Number automatically assigned to new product.'""")
        loaderCmd(session,"""COMMENT ON COLUMN Products.SupplierID      IS 'Same as SupplierID in Suppliers table.'""")
        loaderCmd(session,"""COMMENT ON COLUMN Products.CategoryID      IS 'Same as CategoryID in Categoriers table.'""")
        loaderCmd(session,"""COMMENT ON COLUMN Products.QuantityPerUnit IS '(e.g., 24-count case, 1-liter bottle).'""")
        loaderCmd(session,"""COMMENT ON COLUMN Products.ReorderLevel    IS 'Minimum units to maintain in stock.'""")
        loaderCmd(session,"""COMMENT ON COLUMN Products.Discontinued    IS 'Yes means item no longer available.'""")
        loaderCmd(session,"""COMMENT ON COLUMN Orders.OrderID           IS 'Unique order number from invoice.'""")
        loaderCmd(session,"""COMMENT ON COLUMN Orders.CustomerID        IS 'Same as CustomerID in Customers table.'""")
        loaderCmd(session,"""COMMENT ON COLUMN Orders.EmployeeID        IS 'Same as EmployeeID in Employees table.'""")
        loaderCmd(session,"""COMMENT ON COLUMN Orders.ShipName          IS 'Name of person or company to receive the shipment.'""")
        loaderCmd(session,"""COMMENT ON COLUMN Orders.ShipAddress       IS 'Street address only -- no post-office box allowed.'""")
        loaderCmd(session,"""COMMENT ON COLUMN Orders.ShipRegion        IS 'State or Province'""")
        loaderCmd(session,"""COMMENT ON COLUMN Orders.ShipVia           IS 'Same as ShipperID in Shippers table.'""")
        loaderCmd(session,"""COMMENT ON COLUMN Categories.CategoryID    IS 'Number automatically assigned to new category.'""")
        loaderCmd(session,"""COMMENT ON COLUMN Categories.CategoryName  IS 'Name of food category.'""")
        loaderCmd(session,"""COMMENT ON COLUMN Categories.Picture       IS 'A picture representing the food category.'""")
        loaderCmd(session,"""COMMENT ON COLUMN Customers.CustomerID     IS 'Unique five-character code based on customer name.'""")
        loaderCmd(session,"""COMMENT ON COLUMN Customers.Address        IS 'Street or post-office box.'""")
        loaderCmd(session,"""COMMENT ON COLUMN Customers.Region         IS 'State or province.'""")
        loaderCmd(session,"""COMMENT ON COLUMN Customers.Phone          IS 'Phone number includes country code or area code.'""")
        loaderCmd(session,"""COMMENT ON COLUMN Customers.Fax            IS 'Phone number includes country code or area code.'""")
        loaderCmd(session,"""COMMENT ON COLUMN Suppliers.SupplierID     IS 'Number automatically assigned to new supplier.'""")
        loaderCmd(session,"""COMMENT ON COLUMN Suppliers.Address        IS 'Street or post-office box.'""")
        loaderCmd(session,"""COMMENT ON COLUMN Suppliers.Region         IS 'State or province.'""")
        loaderCmd(session,"""COMMENT ON COLUMN Suppliers.Phone          IS 'Phone number includes country code or area code.'""")
        loaderCmd(session,"""COMMENT ON COLUMN Suppliers.Fax            IS 'Phone number includes country code or area code.'""")
        loaderCmd(session,"""COMMENT ON TABLE EMPLOYEES                 IS 'This table holds the data of all employees.'""")
        loaderCmd(session,"""COMMENT ON COLUMN Employees.EmployeeID     IS 'Number automatically assigned to new employees.'""")
        loaderCmd(session,"""COMMENT ON COLUMN Employees.Title          IS 'Employee''s title.'""")
        loaderCmd(session,"""COMMENT ON COLUMN Employees.LastName       IS 'This is a ''test'' comment for SAPDBLOADER.'""") 
        loaderCmd(session,"""COMMENT ON COLUMN Employees.Address        IS 'Street or post-office box.'""")
        loaderCmd(session,"""COMMENT ON COLUMN Employees.Region         IS 'State or province.'""")
        loaderCmd(session,"""COMMENT ON COLUMN Employees.HomePhone      IS 'Phone number includes country code or area code.'""")
        loaderCmd(session,"""COMMENT ON COLUMN Employees.Extension      IS 'Phone number includes country code or area code.'""")
        loaderCmd(session,"""COMMENT ON COLUMN Employees.Photo          IS 'Picture of employee.'""")
        loaderCmd(session,"""COMMENT ON COLUMN Employees.Notes          IS 'General information about employee''s background.'""")
        loaderCmd(session,"""COMMENT ON COLUMN Employees.ReportsTo      IS 'Employee''s supervisor.'""")
        loaderCmd(session,"""COMMENT ON COLUMN Shippers.ShipperID       IS 'Number automatically assigned to new shipper.'""")
        loaderCmd(session,"""COMMENT ON COLUMN Shippers.CompanyName     IS 'Name of shipping company.'""")


        loaderCmd(session,"""CREATE VIEW EDEMO.OrderSubtotals AS
            SELECT OrderID, Subtotal = Sum(UnitPrice * Quantity * (1 - Discount) * 100 / 100)
            FROM OrderDetails
            GROUP BY OrderID""")

        if ExistsTable (session, 'REQUESTS'):
            loaderCmd(session, 'DROP TABLE REQUESTS')
        loaderCmd(session,"""CREATE TABLE EDEMO.REQUESTS (
            Requestname VARCHAR (40)  NOT NULL,
            Request     LONG  NOT NULL,
            PRIMARY KEY (RequestName))""")
            
        if ExistsTable (session, 'PHOTOS'):
            loaderCmd(session, 'DROP TABLE PHOTOS')
        loaderCmd(session,"""CREATE TABLE EDEMO.PHOTOS (
            Name    CHAR (18)  NOT NULL,
            Photo    LONG BYTE)""")


        if ExistsTable (session, 'NL_TEST'):
            loaderCmd(session, 'DROP TABLE NL_TEST')
        loaderCmd(session,"""CREATE TABLE EDEMO.NL_TEST (
            Number       INTEGER,
            Description  CHAR(500),
            Prenumber    INTEGER,
            CHANGED      TIMESTAMP)""")

    #DATA    
    if  options.init == 'DATA' :
        
        try:
           if options.demo == 'TRUE':
              input('Import    Database       DATA')
           if options.demo == 'FALSE': 
              print 'Import    Database       DATA'
              i = 1/0
        except:
           pass
        
        loaderCmd(session, 'USE USER sqltravel00 initial')

        dataLoad (session, """
            DATALOAD TABLE city
            zip       1
            name      2
            state     3
            INFILE *
            COMPRESSED
            SEPARATOR ','
            DELIMITER ''""","""
12203,Albany,NY
60601,Chicago,IL
60615,Chicago,IL
45211,Cincinnati,OH
33575,Clearwater,FL
75243,Dallas,TX
32018,DaytonaBeach,FL
33441,DeerfieldBeach,FL
48226,Detroit,MI
90029,Hollywood,CA
92714,Irvine,CA
90804,LongBeach,CA
11788,LongIsland,NY
90018,LosAngeles,CA
70112,NewOrleans,LA
10580,NewYork,NY
10019,NewYork,NY
92262,PalmSprings,CA
97213,Portland,OR
60018,Rosemont,IL
95054,SantaClara,CA
20903,SilverSpring,MD
20037,Washington,DC
20005,Washington,DC
20019,Washington,DC
""")

        dataLoad (session, """
            DATALOAD TABLE customer
             cno                1
             title              2
             firstname          3 DEFAULT NULL
             name               4
             zip                5
             address            6
            INFILE *
            NULL '-'""","""
"3000","Mrs","Jenny  ","Porter  ","10580","1340 N.Ash Street, #3"
"3100","Mr ","Peter  ","Brown   ","48226","1001 34th Str., APT.3"
"3200","Company","-","Datasoft","90018","486 Maple Str."
"3300","Mrs","Rose   ","Brian   ","75243","500 Yellowstone Drive, #2"
"3400","Mrs","Mary   ","Griffith","20005","3401 Elder Lane"
"3500","Mr ","Martin ","Randolph","60615","340 MAIN STREET, #7"
"3600","Mrs","Sally  ","Smith   ","75243","250 Curtis Street"
"3700","Mr ","Michael","Jackson ","45211","133 BROADWAY APT. 1"
"3800","Mrs","Rita   ","Doe     ","97213","2000 Humboldt Str., #6"
"3900","Mr ","George ","Howe    ","75243","111 B Parkway, #23"
"4000","Mr ","Frank  ","Miller  ","95054","27 5th Str., 76"
"4100","Mrs","Susan  ","Baker   ","90018","200 MAIN STREET, #94"
"4200","Mr ","Joseph ","Peters  ","92714","700 S. Ash Str., APT. 12"
"4300","Company","-","TOOLware","20019","410 Mariposa Str., # 10"
"4400","Mr ","Antony ","Jenkins ","20903","55 A Parkway, #15"
""")

        dataLoad (session, """
            DATALOAD TABLE account
             booking_day   1
             activities    2
            INFILE *""","""
"19960901","5000.00"
"19960902","-350.00"
"19960903","-350.00"
"19960904","4500.00"
"19960905","1500.00"
"19960906","-1000.00"
"19960907","-1000.00"
"19960908","1500.00"
"19960909","1000.00"
"19960910","6000.00"
"19960911","-100.00"
"19960912","2500.00"
"19960913","350.00"
"19960914","-2000.00"
"19960915","50.00"
"19960916","100.00"
"19960917","-1250.00"
"19960918","8000.00"
"19960919","-2000.00"
"19960920","500.00"
"19960921","-1100.00"
"19960922","1000.00"
"19960923","-200.00"
"19960924","10.00"
"19960925","540.00"
"19960926","-100.00"
"19960927","100.00"
"19960928","1000.00"
""")

        loaderCmd(session, 'USE USER sqltravel10 initial')

        dataLoad (session, """
            DATALOAD TABLE hotel
             hno     1
             name    2
             zip     3
             address 4
             info    5 DEFAULT NULL
            INFILE *
            NULL '-'
            LONGFILE Info ASCII""","""
"10","Congress     ","20005","155 Beechwood Str. "," """ + CreateFileName(os.path.join('SQLTRAVEL10','HOTEL','SQLTRAVEL10_HOTEL_INFO.long001')) + """
"30","Regency      ","20037","477 17th Avenue    "," """ + CreateFileName(os.path.join('SQLTRAVEL10','HOTEL','SQLTRAVEL10_HOTEL_INFO.long003')) + """
"20","Long Island  ","11788","1499 Grove Street  ","-"
"70","Empire State ","12203","65 Yellowstone Dr. ","-"
"80","Midtown      ","10019","12 Barnard Str.    ","-"
"40","Eight Avenue ","10019","112 8th Avenue     ","-"
"50","Lake Michigan","60601","354 OAK Terrace    ","-"
"60","Airport      ","60018","650 C Parkway      "," """ + CreateFileName(os.path.join('SQLTRAVEL10','HOTEL','SQLTRAVEL10_HOTEL_INFO.long006')) + """
"90","Sunshine     ","33575","200 Yellowstone Dr."," """ + CreateFileName(os.path.join('SQLTRAVEL10','HOTEL','SQLTRAVEL10_HOTEL_INFO.long009')) + """
"100","Beach       ","32018","1980 34th Str.     ","-"
"110","Atlantic    ","33441","111 78th Str.      ","-"
"120","Long Beach  ","90804","35 Broadway        ","-"
"150","Indian Horse","92262","16 MAIN STREET     ","-"
"130","Star        ","90029","13 Beechwood Place ","-"
"140","River Boat  ","70112","788 MAIN STREET    ","-"
""")

        dataLoad (session, """
            DATALOAD TABLE room
             hno           1
             roomtype      2
             max_free      3
             price         4
            INFILE *""","""
"10","single","20","135.00"
"10","double","45","200.00"
"30","single","12","45.00"
"30","double","15","80.00"
"20","single","10","70.00"
"20","double","13","100.00"
"70","single","4","115.00"
"70","double","11","180.00"
"80","single","15","90.00"
"80","double","19","150.00"
"80","suite","5","400.00"
"40","single","20","85.00"
"40","double","35","140.00"
"50","single","50","105.00"
"50","double","230","180.00"
"50","suite","12","500.00"
"60","single","10","120.00"
"60","double","39","200.00"
"60","suite","20","500.00"
"90","single","45","90.00"
"90","double","145","150.00"
"90","suite","60","300.00"
"100","single","11","60.00"
"100","double","24","100.00"
"110","single","2","70.00"
"110","double","10","130.00"
"120","single","34","80.00"
"120","double","78","140.00"
"120","suite","55","350.00"
"150","single","44","100.00"
"150","double","115","190.00"
"150","suite ","6","450.00"
"130","single","89","160.00"
"130","double","300","270.00"
"130","suite","100","700.00"
"140","single","10","125.00"
"140","double","9","200.00"
"140","suite","78","600.00"
""")

        loaderCmd(session, 'USE USER sqltravel20 initial')

        dataLoad (session, """
            DATALOAD TABLE reservation
             rno           1
             cno           2
             hno           3
             roomtype      4
             arrival       5
             departure     6
            INFILE *
            DATE 'YY-MM-DD'
            NULL '-'""","""
"100","3000","80","single","95-11-13","95-11-15"
"110","3000","100","double","95-12-24","96-01-06"
"120","3200","50","suite ","95-11-14","95-11-18"
"130","3900","110","single","96-02-01","96-02-03"
"150","3600","70","double","96-03-14","96-03-24"
"140","4300","80","double","95-04-12","95-04-30"
"160","4100","70","single","95-04-12","95-04-15"
"170","4400","150","suite ","95-09-01","95-09-03"
"180","3100","120","double","95-12-23","96-01-08"
"190","4300","140","double","95-11-14","95-11-17"
""")

        loaderCmd(session,"""USE USER EDEMO initial""")

        dataLoad (session, """
            DATALOAD TABLE CATEGORIES
            CATEGORYID      1
            CATEGORYNAME    2
            DESCRIPTION     3 DEFAULT NULL
            PICTURE         4 DEFAULT NULL
            INFILE *
            NULL '-'
            LONGFILE DESCRIPTION ASCII""","""
"1","Beverages     "," """ + CreateFileName(os.path.join('EDEMO','CATEGORIES','EDEMO_CATEGORIES_DESCRIPTION.long001')) + """ "," """ + CreateFileName(os.path.join('EDEMO','CATEGORIES','EDEMO_CATEGORIES_PICTURE.long001')) + """ "
"2","Condiments    "," """ + CreateFileName(os.path.join('EDEMO','CATEGORIES','EDEMO_CATEGORIES_DESCRIPTION.long002')) + """ "," """ + CreateFileName(os.path.join('EDEMO','CATEGORIES','EDEMO_CATEGORIES_PICTURE.long002')) + """ "
"3","Confections   "," """ + CreateFileName(os.path.join('EDEMO','CATEGORIES','EDEMO_CATEGORIES_DESCRIPTION.long003')) + """ "," """ + CreateFileName(os.path.join('EDEMO','CATEGORIES','EDEMO_CATEGORIES_PICTURE.long003')) + """ "
"4","Dairy Products"," """ + CreateFileName(os.path.join('EDEMO','CATEGORIES','EDEMO_CATEGORIES_DESCRIPTION.long004')) + """ "," """ + CreateFileName(os.path.join('EDEMO','CATEGORIES','EDEMO_CATEGORIES_PICTURE.long004')) + """ "
"5","GrainsCereals "," """ + CreateFileName(os.path.join('EDEMO','CATEGORIES','EDEMO_CATEGORIES_DESCRIPTION.long005')) + """ "," """ + CreateFileName(os.path.join('EDEMO','CATEGORIES','EDEMO_CATEGORIES_PICTURE.long005')) + """ "
"6","MeatPoultry   "," """ + CreateFileName(os.path.join('EDEMO','CATEGORIES','EDEMO_CATEGORIES_DESCRIPTION.long006')) + """ "," """ + CreateFileName(os.path.join('EDEMO','CATEGORIES','EDEMO_CATEGORIES_PICTURE.long006')) + """ "
"7","Produce       "," """ + CreateFileName(os.path.join('EDEMO','CATEGORIES','EDEMO_CATEGORIES_DESCRIPTION.long007')) + """ "," """ + CreateFileName(os.path.join('EDEMO','CATEGORIES','EDEMO_CATEGORIES_PICTURE.long007')) + """ "
"8","Seafood       "," """ + CreateFileName(os.path.join('EDEMO','CATEGORIES','EDEMO_CATEGORIES_DESCRIPTION.long008')) + """ "," """ + CreateFileName(os.path.join('EDEMO','CATEGORIES','EDEMO_CATEGORIES_PICTURE.long008')) + """ "
""")

        dataLoad (session, """
            DATALOAD TABLE Suppliers
            SupplierID    1
            CompanyName   2
            ContactName   3 DEFAULT NULL
            ContactTitle  4 DEFAULT NULL
            Address       5 DEFAULT NULL
            City          6 DEFAULT NULL
            Region        7 DEFAULT NULL
            PostalCode    8 DEFAULT NULL
            Country       9 DEFAULT NULL
            Phone        10 DEFAULT NULL
            Fax          11 DEFAULT NULL
            INFILE """ + CreateFileName(os.path.join('EDEMO','SUPPLIERS','EDEMO_SUPPLIERS.data')))

        dataLoad (session, """
            DATALOAD TABLE Customers
            CustomerID    1  CHAR
            CompanyName   2  CHAR
            ContactName   3  CHAR   DEFAULT NULL
            ContactTitle  4  CHAR   DEFAULT NULL
            Address       5  CHAR   DEFAULT NULL
            City          6  CHAR   DEFAULT NULL
            Region        7  CHAR   DEFAULT NULL
            PostalCode    8  CHAR   DEFAULT NULL
            Country       9  CHAR   DEFAULT NULL
            Phone         10 CHAR   DEFAULT NULL
            Fax           11 CHAR   DEFAULT NULL
            INFILE """ + CreateFileName(os.path.join('EDEMO','CUSTOMERS','EDEMO_CUSTOMERS.data')))

        dataLoad (session, """
            DATALOAD TABLE Employees
            EmployeeID  1 CHAR
            LastName    2 CHAR
            FirstName   3 CHAR
            Title       4 CHAR DEFAULT NULL
            BirthDate   5 CHAR DEFAULT NULL
            HireDate    6 CHAR DEFAULT NULL
            Address     7 CHAR DEFAULT NULL
            City        8 CHAR DEFAULT NULL
            Region      9 CHAR DEFAULT NULL
            PostalCode 10 CHAR DEFAULT NULL
            Country    11 CHAR DEFAULT NULL
            HomePhone  12 CHAR DEFAULT NULL
            Extension  13 CHAR DEFAULT NULL
            Photo      14 CHAR DEFAULT NULL
            Notes      15 CHAR DEFAULT NULL
            ReportsTo  16 CHAR DEFAULT NULL
            INFILE *
            DATE 'MMDDYYYY'
            LONGFILE PHOTO """ + CreateFileName(os.path.join('EDEMO','EMPLOYEES','EDEMO_EMPLOYEES_PHOTO.long'))  + """
            LONGFILE NOTES """ + CreateFileName(os.path.join('EDEMO','EMPLOYEES','EDEMO_EMPLOYEES_NOTES.long'))  + "ASCII","""
"1","Davolio","Nancy","Sales Representative","12081948","03291991","507 - 20th Ave. E. Apt. 2A","Seattle","WA","98122","USA","(206) 555-9857","5467","1-21526","1-175","2"
"2","Fuller","Andrew","Vice President, Sales","02191942","07121991","908 W. Capital Way","Tacoma","WA","98401","USA","(206) 555-9482","3457","21527-43052","176-622","?"
"3","Leverling","Janet","Sales Representative","08301963","02271991","722 Moss Bay Blvd.","Kirkland","WA","98033","USA","(206) 555-3412","3355","43053-64578","623-861","2"
"4","Peacock","Margaret","Sales Representative","09191937","03301992","4110 Old Redmond Rd.","Redmond","WA","98052","USA","(206) 555-8122","5176","64579-86104","862-1079","2"
"5","Buchanan","Steven","Sales Manager","03041955","09131992","14 Garrett Hill","London","?","SW1 8JR","UK","(71) 555-4848","3453","86105-107630","1080-1522","2"
"6","Suyama","Michael","Sales Representative","07021963","09131992","Coventry House Miner Rd.","London","?","EC2 7JR","UK","(71) 555-7773","428","107631-129156","1523-1841","5"
"7","King","Robert","Sales Representative","05291960","11291992","Edgeham Hollow Winchester Way","London","?","RG1 9SP","UK","(71) 555-5598","465","129157-150682","1842-2126","5"
"8","Callahan","Laura","Inside Sales Coordinator","01091958","01301993","4726 - 11th Ave. N.E.","Seattle","WA","98105","USA","(206) 555-1189","2344","150683-172208","2127-2277","2"
"9","Dodsworth","Anne","Sales Representative","01271966","10121993","7 Houndstooth Rd.","London","?","WG2 7LT","UK","(71) 555-4444","452","172209-193734","2278-2372","5"
"10","Hellstern","Albert","Business Manager","03131960","03011993","13920 S.E. 40th Street","Bellevue","WA","98006","USA","(206) 555-4869","7559","193735-215260","2373-2926","2"
"11","Smith","Tim","Mail Clerk","06061973","01151993","30301 - 166th Ave. N.E.","Kent","WA","98042","USA","(206) 555-3857","6261","215261-236786","2927-3255","3"
"12","Patterson","Caroline","Receptionist","09111972","05151993","16 Maple Lane","Auburn","WA","98002","USA","(206) 555-3487","1411","236787-258312","3256-3550","3"
"13","Brid","Justin","Marketing Director","10081962","01011994","2 impasse du Soleil","Haguenau","Bas-Rhin","67500","France","88 83 83 16","377","258313-279838","3551-4018","2"
"14","Martin","Xavier","Marketing Associate","11301960","01151994","9 place de la Libert","Schiltigheim","Bas-Rhin","67300","France","88 62 43 53","380","279839-301364","4019-4477","13"
"15","Pereira","Laurent","Advertising Specialist","12091965","02011994","7 rue Nationale","Strasbourg","Bas-Rhin","67000","France","88 01 01 68","376","301365-322890","4478-4650","?"
""")

        dataLoad (session, """
            DATALOAD TABLE Shippers
            ShipperID   1 
            CompanyName 2 
            INFILE *""","""
"1","Speedy Express"
"2","United Package"
"3","Federal Shipping"
""")

        dataLoad (session, """
            DATALOAD TABLE Products
            ProductID        1  CHAR
            SupplierID       2  CHAR        DEFAULT NULL
            CategoryID       3  CHAR        DEFAULT NULL
            Productname      4  CHAR        DEFAULT NULL
            QuantityPerUnit  5  CHAR        DEFAULT NULL
            UnitPrice        6  CHAR        DEFAULT NULL
            UnitsInStock     7  CHAR        DEFAULT NULL
            UnitsOnOrder     8  CHAR        DEFAULT NULL
            ReorderLevel     9  CHAR        DEFAULT NULL
            Discontinued     10 CHAR        DEFAULT NULL
            INFILE  """ + CreateFileName(os.path.join('EDEMO','PRODUCTS','EDEMO_PRODUCTS.data')))
            
        dataLoad (session, """
            DATALOAD TABLE Orders
            OrderID          1 CHAR
            CustomerID       2 CHAR
            EmployeeID       3 CHAR DEFAULT NULL
            Shipname         4 CHAR DEFAULT NULL
            ShipAddress      5 CHAR DEFAULT NULL
            ShipCity         6 CHAR DEFAULT NULL
            ShipRegion       7 CHAR DEFAULT NULL
            ShipPostalCode   8 CHAR DEFAULT NULL
            ShipCountry      9 CHAR DEFAULT NULL
            ShipVia         10 CHAR DEFAULT NULL
            OrderDate       11 CHAR DEFAULT NULL
            RequiredDate    12 CHAR DEFAULT NULL
            ShippedDate     13 CHAR DEFAULT NULL
            Freight         14 CHAR DEFAULT NULL
            INFILE  """ + CreateFileName(os.path.join('EDEMO','ORDERS','EDEMO_ORDERS.data')) + """
            DATE 'MM/DD/YYYY'""")

        dataLoad (session, """
            DATALOAD TABLE OrderDetails
            OrderID    1 CHAR
            ProductID  2 CHAR
            UnitPrice  3 CHAR
            Quantity   4 CHAR DEFAULT NULL
            Discount   5 CHAR DEFAULT NULL
            INFILE  """ + CreateFileName(os.path.join('EDEMO','ORDERDETAILS','EDEMO_ORDERDETAILS.data')))

        dataLoad (session, """
            DATALOAD TABLE Requests
            Requestname  1
            Request      2
            INFILE *
            LONGFILE Request ASCII""","""
"Order Subtotals       "," """ + CreateFileName(os.path.join('EDEMO','REQUESTS','EDEMO_REQUESTS_REQUEST.long001')) + """ "
"Products on Order     "," """ + CreateFileName(os.path.join('EDEMO','REQUESTS','EDEMO_REQUESTS_REQUEST.long002')) + """ "
"Daily Order Totals    "," """ + CreateFileName(os.path.join('EDEMO','REQUESTS','EDEMO_REQUESTS_REQUEST.long003')) + """ "
"Product List          "," """ + CreateFileName(os.path.join('EDEMO','REQUESTS','EDEMO_REQUESTS_REQUEST.long004')) + """ "
"Products and Suppliers"," """ + CreateFileName(os.path.join('EDEMO','REQUESTS','EDEMO_REQUESTS_REQUEST.long005')) + """ "
"Sales for 1993        "," """ + CreateFileName(os.path.join('EDEMO','REQUESTS','EDEMO_REQUESTS_REQUEST.long006')) + """ "
""")

        dataLoad (session, """
            DATALOAD TABLE Photos
            Name   1 
            Photo  2 
            INFILE *""","""
"Photo: R. Meinecke"," """ + CreateFileName(os.path.join('EDEMO','PHOTOS','EDEMO_PHOTOS_PHOTO.long001')) + """ "
"Photo: R. Meinecke"," """ + CreateFileName(os.path.join('EDEMO','PHOTOS','EDEMO_PHOTOS_PHOTO.long002')) + """ "
"Photo: R. Meinecke"," """ + CreateFileName(os.path.join('EDEMO','PHOTOS','EDEMO_PHOTOS_PHOTO.long003')) + """ "
"Photo: R. Meinecke"," """ + CreateFileName(os.path.join('EDEMO','PHOTOS','EDEMO_PHOTOS_PHOTO.long004')) + """ "
"Photo: R. Meinecke"," """ + CreateFileName(os.path.join('EDEMO','PHOTOS','EDEMO_PHOTOS_PHOTO.long005')) + """ "
"Photo: R. Meinecke"," """ + CreateFileName(os.path.join('EDEMO','PHOTOS','EDEMO_PHOTOS_PHOTO.long006')) + """ "
"Photo: R. Meinecke"," """ + CreateFileName(os.path.join('EDEMO','PHOTOS','EDEMO_PHOTOS_PHOTO.long007')) + """ "
"Photo: R. Meinecke"," """ + CreateFileName(os.path.join('EDEMO','PHOTOS','EDEMO_PHOTOS_PHOTO.long008')) + """ "
"Photo: R. Meinecke"," """ + CreateFileName(os.path.join('EDEMO','PHOTOS','EDEMO_PHOTOS_PHOTO.long009')) + """ "
"Photo: R. Meinecke"," """ + CreateFileName(os.path.join('EDEMO','PHOTOS','EDEMO_PHOTOS_PHOTO.long010')) + """ "
"Photo: R. Meinecke"," """ + CreateFileName(os.path.join('EDEMO','PHOTOS','EDEMO_PHOTOS_PHOTO.long011')) + """ "
"Photo: R. Meinecke"," """ + CreateFileName(os.path.join('EDEMO','PHOTOS','EDEMO_PHOTOS_PHOTO.long012')) + """ "
"Photo: R. Meinecke"," """ + CreateFileName(os.path.join('EDEMO','PHOTOS','EDEMO_PHOTOS_PHOTO.long013')) + """ "
"Photo: R. Meinecke"," """ + CreateFileName(os.path.join('EDEMO','PHOTOS','EDEMO_PHOTOS_PHOTO.long014')) + """ "
""")


        dataLoad (session, """
            DATALOAD TABLE NL_TEST
            "NUMBER"      1  CHAR DEFAULT NULL
            Description   2  CHAR DEFAULT NULL
            Prenumber     3  CHAR DEFAULT NULL
            Changed       TIMESTAMP
            INFILE  """ + CreateFileName(os.path.join('EDEMO','NL_TEST','EDEMO_NL_TEST.data')))


    loaderCmd(session, 'COMMIT')

def CreateFileName (filename):
    absFname = os.path.join (os.environ ['INSTROOT'],'misc','sapdb','pythondef','loaderdoc','demo','sourcedb', filename)
    return "'" + absFname + "'"
    
def dataLoad (session, loadcmd, data = None):
    if data != None:
        # write data to tmpfile
        tmpname = tempfile.mktemp ()
        stream = open (tmpname, 'w')
        stream.write (data)
        stream.close ()
        # patch load cmd
        match = re.search ('INFILE +[*]', loadcmd)
        if match != None:
            start, end = match.span ()
            loadcmd = loadcmd [:start] + ("INFILE '%s'" % tmpname) + loadcmd [end:]
    # execute command
    loaderCmd (session, loadcmd)
    # clean up
    if data != None:
       os.unlink (tmpname)                      
    
def loaderCmd (session, cmdStr):
    try:
        result = session.cmd (cmdStr)
    except loader.LoaderError, err:
        raise loader.LoaderError, err, sys.exc_traceback
    except:
        kind, val, traceback = sys.exc_info()
        raise kind, val, traceback

def ExistsUser (session, user):
    try:
        loaderCmd (session, ("select * from users where username = '%s'") % user)
        ok = 1
    except loader.LoaderError, err:
        if (err.sqlCode == 100):
            ok = None
        else:
            raise err  # this is a Loader error
    return ok

def ExistsDomain (session, domain):
    try:
        loaderCmd (session, ("select * from domains where owner = usergroup and domainname = '%s'") % domain)
        ok = 1
    except loader.LoaderError, err:
        if (err.sqlCode == 100):
            ok = None
        else:
            raise err  # this is a Loader error
    return ok

def ExistsTable (session, table):
    try:
        loaderCmd (session, ("select * from tables where owner = usergroup and tablename = '%s'") % table)
        ok = 1
    except loader.LoaderError, err:
        if (err.sqlCode == 100):
            ok = None
        else:
            raise err  # this is a Loader error
    return ok
    
def ExistsSequence (session, sequence):
    try:
        loaderCmd (session, ("select * from sequences where sequence_name = '%s'") % sequence)
        ok = 1
    except loader.LoaderError, err:
        if (err.sqlCode == 100):
            ok = None
        else:
            raise err  # this is a Loader error
    return ok
    
def ExistsDBProcedure (session, dbprocedure) :
    try:
        loaderCmd (session, ("select * from dbprocedures where dbprocname = '%s'") % dbprocedure)
        ok = 1
    except loader.LoaderError, err:
        if (err.sqlCode == 100):
            ok = None
        else:
            raise err  # this is a Loader error
    return ok
 
if __name__ == '__main__':
    optlib.optMain2 (main, _options ())
    
    
##      if not ExistsUser (session, 'SAPR3'):
##         loaderCmd(session, 'CREATE USER SAPR3 PASSWORD initial DBA NOT EXCLUSIVE')              
##      loaderCmd(session, 'USE USER SAPR3 initial')

##      loaderCmd(session, """
##        CREATE TABLE SAMTT(
##	"TEST"               Varchar (3)  ASCII    NOT NULL    DEFAULT '000',
##	"PROGSET"            Varchar (3)  ASCII    NOT NULL    DEFAULT '000',
##	"VERSION"            Varchar (3)  ASCII    NOT NULL    DEFAULT '000',
##	"PROG"               Varchar (40) ASCII    NOT NULL    DEFAULT ' ',
##	"LINE"               Varchar (4)  ASCII    NOT NULL    DEFAULT '0000',
## 	"CATEGORY"           Varchar (1)  ASCII    NOT NULL    DEFAULT ' ',
##	"TXT"                Varchar (80) ASCII    NOT NULL    DEFAULT ' ',
##	"CODE"               Varchar (10) ASCII    NOT NULL    DEFAULT ' ',
##	"FLAG_FLINE"         Varchar (1)  ASCII    NOT NULL    DEFAULT ' ' )
##	""")

##      loaderCmd(session, """
##              CREATE DBPROC SAMTT_DO_INSERTS
##	        AS VAR I INTEGER;
##		        SET I = 1;
##		        WHILE I <= 5000 DO BEGIN
##			        INSERT INTO SAPR3.SAMTT  VALUES  (
##				        RFILL(' '    , 'abc' , 3),
##				        RFILL(' '    , 'def' , 3),
##				        RFILL(' '    , 'ghi' , 3),
##                                      RFILL(' '    , 'jklm', 40),
##				        RFILL(' '    , 'nopq', 4),
##				        RFILL(' '    , 'r'   , 1),
##				        RFILL(' '    , 'stuv', 80),
##				        RFILL(' '    , 'wx'  , 10),
##				        RFILL(' '    , 'y'   , 1) );
##        		        IF $RC <> 0 THEN
##                        	        STOP ($RC, $ERRMSG);
##			        SET I = I + 1;
##		        END;
##        """)    

##      loaderCmd(session, 'CALL SAMTT_DO_INSERTS')

