/*!
  @file           SQLMan_Types.hpp
  @author         ThomasA
  @brief          types used in sql manager
 
\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


\endif
*/

#ifndef SQLMan_TYPES_HPP
#define SQLMan_TYPES_HPP

#include "vak001.h"

typedef tgg00_DateTimeFormat SQLMan_DateTimeFormat;  //!< new name for tgg00_DateTimeFormat
typedef tgg00_Surrogate      SQLMan_Surrogate;       //!< new name for SQLMan_Surrogate
typedef tgg00_FileId         SQLMan_FileId;          //!< new name for tgg00_FileId
typedef pasbool              SQLMan_PascalBool;      //!< new name for pasbool  
typedef tgg00_MessType       SQLMan_MessType;        //!< new name for tgg00_MessType
typedef tgg00_MessType2      SQLMan_MessType2;       //!< new name for tgg00_MessType2
typedef tsp00_SqlMode        SQLMan_SqlMode;         //!< new name for tsp00_SqlMode
typedef tgg00_StackEntry     SQLMan_StackEntry;      //!< new name for tgg00_StackEntry
typedef tgg00_TransContext   SQLMan_TransContext;    //!< new name for tgg00_TransContext
typedef tsp00_DataType       SQLMan_DataType;        //!< new name for tsp00_DataType

/*!
   @brief defines layout of an identifier
*/
class SQLMan_Identifier : public tsp00_KnlIdentifier
{
public :
    /*!
       @brief constructor, initializes an blank identifier
    */
    inline SQLMan_Identifier();
    /*!
       @brief contructor, initializes with a null terminated string
       @param source identifier to be copied, must ne ascii and null terminated
    */
    inline SQLMan_Identifier(const char* source);
};

inline SQLMan_Identifier::SQLMan_Identifier() // TODO
{
    memset (this, ' ', sizeof(*this));
}

inline SQLMan_Identifier::SQLMan_Identifier(const char* id) // TODO
{
    int len = (int) strlen(id);
    memcpy (this, id, len);
    memset ((char*) this + len, ' ', sizeof(*this) - len);
}

class SharedSQL_ParseID;

/*!
   @brief identifier of a sql execution plan 
*/
class SQLMan_ParseId : public tak_parsid
{
public :
    /*!
       @brief copy constructor
       @param source the plan identifier to be copied
    */
    SQLMan_ParseId(const tak_parsid& source)
    {
        memcpy(this, &source, sizeof(*this));
    }
    /*!
       @brief SharedSQL_ParseID and SQLMan_ParseId are the same
    */
    operator SharedSQL_ParseID&()
    {
        return *REINTERPRET_CAST(SharedSQL_ParseID*, this);
    }
};

#endif