/*!***************************************************************************

  module      : SQLMan_MessBlock.cpp

  -------------------------------------------------------------------------

  responsible : ThomasA

  special area: SQL Manager
  description : encapsulation of pascal type tgg00_MessBlock

  last changed: 2000-12-06  19:04
  see also    : example.html ...
  first created:2000-03-09  18:21

  -------------------------------------------------------------------------

  copyright:    (c) 2000-2004 SAP AG




    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



*****************************************************************************/

#include "SQLManager/SQLMan_MessBlock.hpp"
#include "SQLManager/SQLMan_Tracing.hpp"
#include "SAPDBCommon/MemoryManagement/SAPDBMem_IRawAllocator.hpp"

void* SQLMan_MessBlock::CreateCopy(const SQLMan_MessBlock& source, 
                                   SAPDBMem_IRawAllocator& allocator, 
                                   int                     offset,
								   SAPDB_UInt4&            memoryUsage)
{
    SAPDBTRACE_ROUTINE_DEBUG ("SQLMan_MessBlock::CreateCopy", SQLMan_Trace, 5);
	memoryUsage = offset + sizeof(tgg00_MessBlock);
    void* p = allocator.Allocate(memoryUsage);
    if (p)
    {
        int   allocatedIdx = 0;
        void* allocatedBlocks[5];
        bool  ok = true;

        allocatedBlocks[0] = p;
        SQLMan_MessBlock* pMessBlock = REINTERPRET_CAST (SQLMan_MessBlock*,
            REINTERPRET_CAST(char*, p) + offset);
        memcpy (pMessBlock, &source, sizeof(source));
        // initialize all pointers and sizes to 0
        pMessBlock->SetData();
        pMessBlock->SetQual();
        pMessBlock->SetStack();
        pMessBlock->SetStrat();
        
        // create qual and stack code part
        if (source.QualLength() > 0)
        {
            allocatedBlocks[allocatedIdx+1] = allocator.Allocate(source.QualLength());
            if (allocatedBlocks[allocatedIdx+1])
            {
				memoryUsage += source.QualLength();
                ++allocatedIdx;
                pMessBlock->SetQual(allocatedBlocks[allocatedIdx], source.QualLength());
                memcpy (allocatedBlocks[allocatedIdx], source.mb_qual(), source.QualLength()); 
                pMessBlock->QualLength() = source.QualLength();
                int stackLength = (source.mb_st()) ? (source.FirstFree() - 1) * sizeof(SQLMan_StackEntry) : 0;
                if (stackLength > 0)
                {
                    allocatedBlocks[allocatedIdx+1] = allocator.Allocate(stackLength);
                    if (allocatedBlocks[allocatedIdx+1])
                    {
						memoryUsage += stackLength;
                        ++allocatedIdx;
                        pMessBlock->SetStack(allocatedBlocks[allocatedIdx], stackLength);
                        memcpy (allocatedBlocks[allocatedIdx], source.mb_st(), stackLength);
                    }
                    else
                    {
                        ok = false;
                    }
                }
            }
            else
            {
                ok = false;
            }
        }
        // create required data part
        if (ok && (source.DataLength() > 0))
        {
            allocatedBlocks[allocatedIdx+1] = allocator.Allocate(source.DataLength());
            if (allocatedBlocks[allocatedIdx+1])
            {
				memoryUsage += source.DataLength();
                ++allocatedIdx;
                pMessBlock->SetData(allocatedBlocks[allocatedIdx], source.DataLength());
                memcpy (allocatedBlocks[allocatedIdx], source.mb_data(), source.DataLength());
                pMessBlock->DataLength() = source.DataLength();
            }
            else
            {
                ok = false;
            }
        }
        // create required strategy part
        if (ok && (source.StratLength() > 0))
        {
            allocatedBlocks[allocatedIdx+1] = allocator.Allocate(source.StratLength());
            if (allocatedBlocks[allocatedIdx+1])
            {
				memoryUsage += source.StratLength();
                ++allocatedIdx;
                pMessBlock->SetStrat(allocatedBlocks[allocatedIdx], source.StratLength());
                memcpy (allocatedBlocks[allocatedIdx], source.mb_strat(), source.StratLength());
                pMessBlock->StratLength() = source.StratLength();
            }
        }
        if (!ok)
        {
            while (allocatedIdx >= 0)
            {
                allocator.Deallocate(allocatedBlocks[allocatedIdx]);
                --allocatedIdx;
            }
            p = NULL;
        }
    }
    return p;
}

//----------------------------------------------------------------------------------

void SQLMan_MessBlock::DestroyParts(SAPDBMem_IRawAllocator& allocator)
{
	allocator.Deallocate(mb_data());
    allocator.Deallocate(mb_qual());
	allocator.Deallocate(mb_st());
	allocator.Deallocate(mb_strat());
}

//----------------------------------------------------------------------------------

void SQLMan_MessBlock::InvalidateTransaction()
{
    mb_trns() = NULL;
}