/*!
  @file           RTEThread_ConsoleRequest.h
  @author         StefanP
  @special area   Console
  @brief          Data struct for communication between 
              console thread and worker threads
  @see            

\if EMIT_LICENCE
  ========== licence begin  GPL
  Copyright (c) 2002-2004 SAP AG

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  ========== licence end
\endif
*/



#ifndef RTETHREAD_CONSOLEREQUEST_H
#define RTETHREAD_CONSOLEREQUEST_H



/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/
#include    "RunTime/RTE_ConsoleCommon.hpp"

/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/



/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/


/*===========================================================================*
 *  CLASSES, STRUCTURES, TYPES, UNIONS ...                                   *
 *===========================================================================*/

/*!
   @description    Communication structure (console thread &lt;-> worker threads)


  This type definition defines the structure for a command queue list element

 */


typedef struct
{
    SAPDB_UInt1                 reqType;
    SAPDB_UInt4                 senderRef;
    SAPDB_UInt4                 receiverRef;
    RTE_ConsoleRequestData      data;
} RTEThread_ConsoleRequest;


#endif  /* RTETHREAD_CONSOLEREQUEST_H */
