/*!---------------------------------------------------------------------
  @file           RTE_FileUser.h
  @author         Christoph
  @brief          Find any process who is using a file as executable or module
  @see            

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2001-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


\endif
---------------------------------------------------------------------*/

#ifndef RTE_FILEUSER_H
#define RTE_FILEUSER_H RTE_FILEUSER_H

/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/

 /*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/

/*===========================================================================*
 *  LOCAL CLASSES, STRUCTURES, TYPES, UNIONS ...                             *
 *===========================================================================*/

#ifndef WIN32
#define UNIX UNIX
#endif

#ifdef _WIN64
typedef __int64 ptr_t;
#else
typedef long ptr_t;
#endif

#ifdef UNIX
#include <sys/types.h>
#endif

struct modinfo {
	char *name;
	ptr_t pid;
	modinfo *next;
};

struct procinfo {
	ptr_t pid;
	ptr_t ppid;
	ptr_t uid;
	char *cmd;
	procinfo *next;
};

class RTE_ProcInfo {
public:
	RTE_ProcInfo (procinfo *);
	~RTE_ProcInfo ();
	procinfo *Next (procinfo *);
	procinfo *First ();
	int Terminate (procinfo *);
private:
	procinfo *pi;
};

class RTE_FileUser {
public:
	RTE_FileUser ();
	~RTE_FileUser ();

	RTE_ProcInfo WhoUsesModule (const char *);

private:
	modinfo  *mi;
	procinfo *ps;
};

/*===========================================================================*
 *  END OF CODE                                                              *
 *===========================================================================*/
#endif

