#include "Oms/OMS_ContainerInfo.hpp"
#include "Oms/OMS_Globals.hpp"

/*----------------------------------------------------------------------------------*/

OMS_ContainerInfo::OMS_ContainerInfo (OMS_ClassInfo* pClassInfo, const tgg01_ContainerId& t, 
                                      tsp00_Uint4 containerHandle, size_t psz, OmsSchemaHandle sh, OmsContainerNo cno) :
m_clsidHashNext(NULL), m_guidHashNext(NULL), m_clsInfo(pClassInfo),
m_PersistentSize(psz), m_ContainerNo(cno), m_schema(sh), m_dropped(false), m_refCnt(0) 
{
  memcpy (&m_ContainerId, &t, sizeof (m_ContainerId));
}

/*----------------------------------------------------------------------------------*/

void* OMS_ContainerInfo::operator new(size_t sz)
{
  return OMS_Globals::m_sharedMemAllocatorInstance.allocate(sz);
}

/*----------------------------------------------------------------------------------*/

void OMS_ContainerInfo::DeleteSelf() 
{
#if defined(_ASSERT_OMS)
  memset (this, 0, sizeof(*this));
#endif
  OMS_Globals::m_sharedMemAllocatorInstance.deallocate(this);
}

/*----------------------------------------------------------------------------------*/
#if defined(OMS_PLACEMENT_DELETE)

void  OMS_ContainerInfo::operator delete (void* p) 
{
  OMS_Globals::m_sharedMemAllocatorInstance.deallocate(p);
}

#endif

/*----------------------------------------------------------------------------------*/

void OMS_ContainerInfo::Dump(OMS_ContainerDumpInfo& dumpInfo)
{
  dumpInfo.m_addr          = this;
  dumpInfo.m_clsidHashNext = m_clsidHashNext;
  dumpInfo.m_guidHashNext  = m_guidHashNext;
  dumpInfo.m_clsInfo       = m_clsInfo;
  dumpInfo.m_ContainerNo   = m_ContainerNo;
  dumpInfo.m_schema        = m_schema;
  dumpInfo.m_ContainerId   = m_ContainerId;
  dumpInfo.m_PersistentSize= (tsp00_Int4) m_PersistentSize;
  dumpInfo.m_refCnt        = m_refCnt;
  dumpInfo.m_dropped       = m_dropped;
  dumpInfo.m_filler        = false;
}

