#ifndef JOIN_RESULTSETONERESULT_HPP
#define JOIN_RESULTSETONERESULT_HPP
/*!
 * @file
 * @brief implements interface Join_IResultSetOperator which contains only 
 * one record
 *
 * @author GertG
 * @ingroup Join
 *
 * @par last changed by:
 * <br>
 * $Author: d024980 $ $DateTime: 2004/05/03 16:16:26 $
 *
 * @sa Join_Execute.cpp, Join_IResultSetOperator.hpp
 */
/*

    ========== licence begin  GPL
    Copyright (c) 2003-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/
#include "SAPDB/Join/Join_IResultSetOperator.hpp"
#include "SAPDB/Container/Container_Vector.hpp"
#include "hsp41.h"

//! implements interface Join_IResultSetOperator which contains only one record
class Join_ResultSetOneResult : public Join_IResultSetOperator {
public:
    //! @name constructor / destructor
    //@{
    //! constructor
    /*! 
     * @param acv [in] global context
     * @param rec_desc [in] pointer to result record description
     * @param strict_result [in] true: for more than one result throw an error; false: depends on SQL mode
     */
    Join_ResultSetOneResult( 
            tak_all_command_glob&         acv,
            const tgg00_StackList * const rec_desc ) :
    Join_IResultSetOperator( acv, rec_desc, 0, 1 )
    {
        SAPDBTRACE_METHOD_DEBUG( "Join_ResultSetOneResult::ctor", Join_Trace, 1 );
    }
    
    //! finalize operator
    virtual void Close()
    {
        SAPDBTRACE_METHOD_DEBUG( "Join_ResultSetOneResult::Close", Join_Trace, 1 );
        if ( 0 == this->ResultCount() )
        {
            m_acv.a_mblock.mb_data_len() = 0;
            if ( e_ok == m_acv.a_transinf.tri_trans.trError_gg00 )
            {
                m_acv.a_transinf.tri_trans.trError_gg00 = e_no_next_record;
            }
        }
    }
    //@}

    //! @name manipulation of result set
    //@{
    //! add record to result set
    /*!
     * @param record [in] record to be added
     * @return information code <tt>[e_ok, e_no_next_record]</tt> / error code
     */
    virtual tgg00_BasisError Add( tgg00_Rec& record )
    {
        SAPDBTRACE_METHOD_DEBUG( "Join_ResultSetOneResult::Add", Join_Trace, 1 );

        if ( m_ResultCnt < m_MaxResultCnt )
        {
            return add( record );
        }
        else
        {
            if ( sqlm_oracle == m_acv.a_sqlmode )
            {
                SAPDBTRACE_WRITELN( Join_Trace, 3, "accept more results" );
                m_acv.a_transinf.tri_trans.trWarning_gg00.addElement(warn0_exist);
                m_acv.a_transinf.tri_trans.trWarning_gg00.addElement(warn12_rowno_used);
                return e_no_next_record;
            }
            else
            {
                SAPDBTRACE_WRITELN( Join_Trace, 3, "too many results" );
                return e_too_many_resultsets;
            }
        }
    }
    //@}

protected:
    virtual tgg00_BasisError add( tgg00_Rec& record )
    {
        SAPDBTRACE_METHOD_DEBUG( "Join_ResultSetOneResult::add", Join_Trace, 3 );
        
        tsp00_NumError   _ret;

        set_result_counter( record, m_ResultCnt + 1 );

        // put ROWNO
        Container_Vector<SAPDB_Int4>::Iterator _iter;
        for ( _iter = m_RecordCounterPositions.Begin(); _iter != m_RecordCounterPositions.End(); ++_iter) 
        {
            record.buf()[ *_iter - 1 ] = csp_defined_byte;
            s41plint( record.buf(), *_iter + 1,
                  csp_resnum_deflen, 0, m_ResultCnt + 1, _ret );
        }

        SAPDBTRACE_IF( Join_Trace, 2, 
        t01buf( td_always, &record, 1, record.recLen_gg00() <= 300 ? record.recLen_gg00() : 300 ));
        // move record into data part of messblock
        memcpy( &m_acv.a_mblock.mb_data()->mbp_4kbuf(), &record, record.recLen_gg00() );
        m_acv.a_mblock.mb_data_len() = record.recLen_gg00();
        ++m_ResultCnt;
        return e_ok;
    }
};

#endif // JOIN_RESULTSETONERESULT_HPP
