#/*!
#\@file           genSQLDBC_C.pl
#\@author         DL SAP DB INTERFACES
#\@ingroup        SQLDBC
#\@brief          SAP Database Connectivity
#\@see            
#
#       This script generates the C-wrapper implementation 
#       for the c++ interface SQLDBC
#
#\\if EMIT_LICENCE
#
#	========== licence begin  GPL
#	Copyright (c) 2001-2004 SAP AG
#
#	This program is free software; you can redistribute it and/or
#	modify it under the terms of the GNU General Public License
#	as published by the Free Software Foundation; either version 2
#	of the License, or (at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#	========== licence end
#
#
#\\endif
#*/

use strict;
use Env;
use File::Path;

sub printHeader {
	my $fh = shift;
	print $fh <<"ENDE";
/*!
\@file           SQLDBC.cpp
\@author         DL SAP DB INTERFACES
\@ingroup        SQLDBC
\@brief          SAP Database Connectivity
\@see            

\\if EMIT_LICENCE

	========== licence begin  GPL
	Copyright (c) 2001-2004 SAP AG

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
	========== licence end


\\endif
*/
#include \"SAPDB/Interfaces/SQLDBC/SQLDBC.h\"
using namespace SQLDBC; 
#include \"SAPDB/Interfaces/SQLDBC/SQLDBC-sqldbc_c.h\"

#ifdef __cplusplus
extern "C" {
#endif

/*some special coding that cannot be generated by the wrapper generator script*/
  SQLDBC_ConnectProperties* SQLDBC_ConnectProperties_new_SQLDBC_ConnectProperties(){
    return (SQLDBC_ConnectProperties*) new SQLDBC_ConnectProperties();
  }

  void  SQLDBC_ConnectProperties_delete_SQLDBC_ConnectProperties(  SQLDBC_ConnectProperties* hdl){
    SQLDBC_ConnectProperties* tmpVar1 = (SQLDBC_ConnectProperties*)hdl;
    delete tmpVar1;
  }

  SQLDBC_Environment* SQLDBC_Environment_new_SQLDBC_Environment(SQLDBC_IRuntime* runtime){
    return (SQLDBC_Environment*) new SQLDBC_Environment(runtime);
  }

  void  SQLDBC_Environment_delete_SQLDBC_Environment(  SQLDBC_Environment* hdl){
    SQLDBC_Environment* tmpVar1 = (SQLDBC_Environment*)hdl;
    delete tmpVar1;
  }
  SQLDBC_IRuntime* ClientRuntime_GetClientRuntime(char *errorText,SQLDBC_Int4 errorTextSize){
    return GetClientRuntime(errorText, errorTextSize);
  }  
  char *getSDKVersion()
  {
    return SQLDBC_CHeaderVersion;
  }
  /*end special coding*/

ENDE
}

sub printFooter {
	my $fh = shift;
	print $fh <<"ENDE";
#ifdef __cplusplus
}
#endif
ENDE
}

sub filterSession {
  my $TempDir = "$ENV{'WRK'}/src/SAPDB/Interfaces/SQLDBC";
  my $TempFile = "$TempDir/SQLDBC_C.cpp";
  my $filename= shift;
  my $curLine;
  my $methodMap;
  my $typeMap;
  my $ignore = 0;
 
  	File::Path::mkpath($TempDir, 0, 0777) if ( ! -d $TempDir);
    open(FILE_IN, "<$filename")  || die "Can't open $filename (input): $!";
    open(FILE_OUT, ">$TempFile") || die "Can't open $TempFile (output): $!";
	printHeader(\*FILE_OUT);
    while(<FILE_IN>) {
      $curLine.=$_;
	  if ($_=~/\/\*\s*#methodmap\s+(\w+)\s+(\w+)/){
		$methodMap->{$1}=$2;
		$curLine='';  
	  }	  
	  if ($_=~/\s*#typemap\s+(\w+)\s+([\w,:]+)/){
		$typeMap->{$1}=$2;
		$curLine='';  
	  }	  
	  if ($curLine=~/#define[ ]*SQLDBC_DLLEXPORT/){
		$curLine='';  
	  }
	  if ($curLine=~/#ignore/){
		$ignore = 1;  
	  }
	  if ($curLine=~/SQLDBC_DLLEXPORT[\n\r\s]*((.|\s)*\));/){
		if ($ignore==1){
		  $ignore=0;	
          $curLine='';  
		  next;
		}
		my $curCall=$1;  
        $curCall=~/(\w+)(\s*\*?)\s*(\/\*#cast (.*)\*\/)?\s*([a-z]+[_]{1}[a-z]+)[_]{1}(\w+)\s*\((\s*\w+\s*[*]{0,1}\s*(\w+)\s*[,]?\s*((.|\s)*))?\)/i;
		my $orignRetType = $1.$2;
		my $retType = $typeMap->{$1};
		if (! defined $retType){$retType = $1;}
		$retType.=$2;
		my $cast = $4;
		my $objName = $5;
		my $metName = $methodMap->{$5.'_'.$6};
		if (! defined $metName){$metName = $6;}
		my $handle  = $8;
		my $arglist = $9;
		my $sep     = "";
		print FILE_OUT "  $orignRetType $5_$6(";
		if (defined $handle && $handle ne ""){
       	          print FILE_OUT "  $objName* $handle";
		}
		if (defined $arglist && $arglist ne ""){
       		print FILE_OUT ", $arglist){\n";  
		}else{
			print FILE_OUT "){\n";  
		}
    	if (!defined $handle || $handle eq ""){
			
        }else{
			print FILE_OUT "    $objName* tmpVar1 = ($objName*)$handle;\n";
			if ($retType=~/\s*void\s*/){
			print FILE_OUT "    tmpVar1->$metName(";
			} else {	
			print FILE_OUT '    return ('.$orignRetType.') '.$cast.'tmpVar1->'.$metName.'(';
			}  
			foreach (split(/,/,$arglist)){
				$_=~/(\s*const)?\s*(\w+)(\s*\*{0,2})?\s*(\/\*#cast (.*)\*\/)?\s*(\w+)/i;
				my $tmap=$typeMap->{$2};
	#			print FILE_OUT "Type >$2<\n";
				if ( defined $tmap){
				print FILE_OUT $sep.' ('.$tmap.$3.') '.$6;
				}elsif( defined $5){
				print FILE_OUT $sep.$5.$6;
				}else {
				print FILE_OUT $sep.$6;
				}
				$sep = ', ';
			}
            print FILE_OUT ");\n";  
		}	
        print FILE_OUT "  }\n\n";  
        $curLine='';
	  }
    }
	printFooter(\*FILE_OUT);
    close(FILE_OUT); close(FILE_IN);
}

filterSession (@ARGV);

__DATA__

 USAGE: pcvt [-h | [-d dbname] [-u uid,pwd] [-v] <cmd> [<switch>]
                 | -s session [-f protfile] ]

           Switch kernel vtrace on or off or filter the protfile.

 OPTIONS:    -h           (prints this help)
             -d dbname    (default $SERVERDB)
             -u uid,pwd   (default control,control)
             -v           verbose
             -s session   session number in vtrace (T23 -> 23)
             -f protfile  (default ./$SERVERDB.prt)

 <cmd>:
	     on | off | flush | clear | create

 <switch>    Only with create. <switch> is passed to $DBKERNPROT.
             Default for <switch> is "$DBKERNSWITCH".

