/*!
  @file           IFRUtil_Stream.cpp
  @author         D030044
  @ingroup        IFR_Util
  @brief          Implements a class for data streams
  @see            

\if EMIT_LICENCE



    ========== licence begin  GPL
    Copyright (c) 2001-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end






\endif
*/

#include "Interfaces/Runtime/IFR_Common.h"
#include "Interfaces/Runtime/Util/IFRUtil_Stream.h"

IFRUtil_IStream::IFRUtil_IStream (char *data, int len)
  : m_data(data), m_len(len), m_currentPos(0)
{
}

int
IFRUtil_IStream::read (char *readBuf, int readLen)
{
  int toCopy;

  if (m_currentPos >= m_len)
    return -1;

  toCopy = MIN (m_len - m_currentPos, readLen);
  memcpy (readBuf, m_data + m_currentPos, toCopy);
  
  m_currentPos += toCopy;

  return toCopy;
}
