/*!
  @file           Converter_WaitQueue.cpp
  @author         TorstenS
  @author         AlexanderK
  @author         UweH
  @ingroup        Converter
  @brief          wait queue class used in the converter
*/

/* ========== licence begin  GPL
  Copyright (c) 2001-2004 SAP AG

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  ========== licence end
*/

/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/


#include "heo56.h"  // vsuspend
#include "heo55k.h" // vbegexcl
#include "hgg08.h"  // g08ConvWaitQueue

#include "Converter/Converter_WaitQueue.hpp"

/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/



/*===========================================================================*
 *  STATIC/INLINE FUNCTION PROTOTYPES                                        *
 *===========================================================================*/



/*===========================================================================*
 *  INSTANCE METHODS OF THE INTERFACE CLASSES  OF THE CONVERTER CLASS        *
 *===========================================================================*/

Converter_WaitQueue::Converter_WaitQueue( const SAPDB_Int2    suspendReason )
        :
        m_SuspendReason( suspendReason ),
        m_RegionId( g08ConvWaitQueue )
{}

/*---------------------------------------------------------------------------*/

void
Converter_WaitQueue::ResumeAllWaitingTasks( const tsp00_TaskId taskId )
{
    vbegexcl( taskId, m_RegionId );

    m_WaitList.ResumeAll();

    vendexcl( taskId, m_RegionId );
}

/*---------------------------------------------------------------------------*/

void
Converter_WaitQueue::InsertTask( const tsp00_TaskId     taskId,
                                 WaitContext            &waitContext )
{
    vbegexcl( taskId, m_RegionId );

    m_WaitList.InsertAsFirst( taskId,waitContext );

    vendexcl( taskId, m_RegionId );
}

/*---------------------------------------------------------------------------*/

void Converter_WaitQueue::Wait( const tsp00_TaskId taskId ) const
{
    vsuspend( taskId, m_SuspendReason );
}

/*===========================================================================*
 *  END OF CODE                                                              *
 *===========================================================================*/
