#
# RunTime Environment / Memory Handling Descriptions
#
#
#
#    ========== licence begin  GPL
#    Copyright (c) 2000-2004 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
#

#

*         -except 
#
# No exception handling code variant
#
*-noex    -DSAPDB_COMPILE_WITHOUT_EXCEPTION_HANDLING
#
# Singleton RawAllocator (synchronized + minimum overhead)
RTEMem_RawAllocator.hpp inc=SAPDBMem_IRawAllocator.hpp,RTESync_InterlockedCounter.hpp
RTEMem_RawAllocator*.cpp inc=SAPDBMem_NewDestroy.hpp,SAPDB_Types.hpp,RTE_ISystem.hpp,RTEMem_RawAllocator.hpp,RTEMem_BlockAllocator.hpp,RTEMem_AllocatorRegister.hpp,SAPDBMem_Exceptions.hpp,SAPDBErr_Assertions.hpp
#
# Singleton BlockAllocator (synchronized + zero overhead)
RTEMem_BlockAllocator.hpp inc=SAPDBMem_IBlockAllocator.hpp,RTESync_InterlockedCounter.hpp
RTEMem_BlockAllocator*.cpp inc=SAPDBMem_NewDestroy.hpp,RTE_ISystem.hpp,RTEMem_BlockAllocator.hpp,\
                               SAPDBErr_Assertions.hpp,SAPDBMem_Exceptions.hpp,RTEMem_AllocatorRegister.hpp
#
# Singleton PageAllocator (NON synchronized + zero overhead)
RTEMem_PageAllocator.h   inc=SAPDB_Types.h
RTEMem_PageAllocator.hpp inc=SAPDBMem_IRawAllocator.hpp,SAPDB_Singleton.hpp,RTESync_NamedSpinlock.hpp
RTEMem_PageAllocator*.cpp inc=SAPDBMem_NewDestroy.hpp,SAPDBErr_Assertions.hpp,RTEMem_PageAllocator.hpp,RTEMem_BlockAllocator.hpp,SAPDBTrace_Topic.hpp,SAPDBTrace_Usage.hpp
#
# Singleton Allocator (synchronized and nonsynchronized version of SAPDBMem_RawAllocator)
RTEMem_Allocator.hpp inc=SAPDBMem_IRawAllocator.hpp,SAPDBMem_SynchronizedRawAllocator.hpp,RTESync_NamedSpinlock.hpp
RTEMem_Allocator*.cpp inc=SAPDBMem_NewDestroy.hpp,RTEMem_Allocator.hpp,RTEMem_BlockAllocator.hpp,SAPDBErr_Assertions.hpp,RTEMem_AllocatorRegister.hpp
RTEMem_AllocatorSimpleProcess.hpp inc=SAPDBMem_IRawAllocator.hpp,SAPDBMem_DougLeaAllocator.hpp
RTEMem_AllocatorSimpleProcess*.cpp inc=SAPDBMem_NewDestroy.hpp,RTEMem_AllocatorSimpleProcess.hpp,RTEMem_RawAllocator.hpp,SAPDBErr_Assertions.hpp
#
# RTE only used Singleton Allocator (synchronized version of DougLea Allocator)
RTEMem_RteAllocator.hpp inc=SAPDBMem_IRawAllocator.hpp,SAPDBMem_SynchronizedRawAllocator.hpp,RTESync_NamedSpinlock.hpp
RTEMem_RteAllocator*.cpp inc=SAPDBMem_NewDestroy.hpp,RTEMem_RteAllocator.hpp,RTEMem_BlockAllocator.hpp,SAPDBErr_Assertions.hpp,RTEMem_AllocatorRegister.hpp
#
RTEMem_AllocatorRegister.hpp inc=SAPDBMem_IAllocatorInfo.hpp,RTE_ItemRegister.hpp
RTEMem_AllocatorRegister*.cpp inc=RTEMem_AllocatorRegister.hpp,SAPDBMem_NewDestroy.hpp,RTEMem_RteAllocator.hpp
#
RTEMem_AllocatorInfoReader.hpp inc=RTEMem_AllocatorRegister.hpp,SAPDBMem_IRawAllocator.hpp,SAPDBMem_NewDestroy.hpp,Container_List.hpp
RTEMem_AllocatorInfoReader.cpp inc=ggg00,RTEMem_AllocatorRegister.hpp,RTEMem_AllocatorInfoReader.hpp,SAPDBMem_IRawAllocator.hpp,SAPDBMem_NewDestroy.hpp,Container_List.hpp
#
# Self registering 'Allocate only' wrapper allocator for identifying memory using components
RTEMem_AllocatorWrapper.hpp inc=SAPDBMem_IRawAllocator.hpp,RTEMem_AllocatorRegister.hpp,RTESync_InterlockedCounter.hpp,SAPDBErr_Assertions.hpp
#
# Self registering BuddyAllocator
RTEMem_BuddyAllocator.hpp inc=SAPDBMem_BuddyAllocator.hpp,RTEMem_AllocatorRegister.hpp
#
# Self registering IncrementalRawAllocator
RTEMem_IncrementalRawAllocator.hpp inc=SAPDBMem_IncrementalRawAllocator.hpp,RTEMem_AllocatorRegister.hpp
#
# Testing Wrapper Allocator and Register
RTEMem_TestAllocatorRegister.cpp inc=RTEMem_AllocatorWrapper.hpp,RTEMem_DougLeaAllocator.hpp,RTEMem_BuddyAllocator.hpp,RTEMem_IncrementalRawAllocator.hpp,RTEMem_Allocator.hpp,SAPDBMem_NewDestroy.hpp

#
# System page caching
RTEMem_SystemPageCache.hpp inc=SAPDB_Types.hpp,SAPDB_Singleton.hpp,SAPDBMem_IBlockAllocator.hpp,RTESync_NamedSpinlock.hpp,RTESync_InterlockedCounter.hpp
RTEMem_SystemPageCache.cpp inc=SAPDBMem_NewDestroy.hpp,SAPDBErr_Assertions.hpp,RTEMem_SystemPageCache.hpp,SAPDBTrace_Topic.hpp,SAPDBTrace_Usage.hpp,RTESys_SystemInfo.h,RTEMem_AllocatorRegister.hpp,RTE_Message.hpp,RTE_SystemPageCache_Messages.hpp

# Allocator for special cases where registering must be avoided (for example within RTE_ItemRegister...)
RTEMem_UnregisteredAllocator.hpp inc=SAPDBMem_IRawAllocator.hpp
RTEMem_UnregisteredAllocator.cpp inc=RTEMem_UnregisteredAllocator.hpp,RTEMem_RteAllocator.hpp

RTEMem_ProtectingAllocator.h inc=SAPDB_Types.h
RTEMem_ProtectingAllocator.hpp inc=heo07.h,SAPDBCommon/MemoryManagement/SAPDBMem_NewDestroy.hpp,APDBCommon/MemoryManagement/SAPDBMem_IBlockAllocator.hpp,RunTime/Synchronisation/RTESync_InterlockedCounter.hpp
RTEMem_ProtectingAllocator.cpp inc=RTEMem_ProtectingAllocator.hpp,RTE_MessageList.hpp,RTE_Message.hpp,RTE_Messages.hpp,SAPDBTrace_Topic.hpp,SAPDBTrace_Usage.hpp\
&if $OS not in [ WIN32 ]
                               ,gen41.h
&endif

#
# AWE
&if $OS in [ WIN32 ]
RTEMem_AWEAllocator.hpp inc=SAPDB_Singleton.hpp,SAPDBTrace_Usage.hpp dep=RTESys_NTAWE.hpp
&else
RTEMem_AWEAllocator.hpp inc=SAPDB_Singleton.hpp,SAPDBTrace_Usage.hpp
&endif

RTEMem_AWEAllocator.cpp inc=SAPDBMem_NewDestroy.hpp,SAPDBMem_Exceptions.hpp,RTEMem_AWEAllocator.hpp,RTE_Crash.hpp,\
                            RTE_MessageList.hpp,RTE_Message.hpp,SAPDBTrace_Topic.hpp,SAPDBTrace_Usage.hpp

&if $OSSPEC == LINUX && $MACH in [ S390X, IA64 ]
regex(\w+\.cpp) -OPT=-O2
&endif

