# ------------------------------------------------------------------------------
#
# DataAccess Descriptions
#
# ------------------------------------------------------------------------------
#
#
#    ========== licence begin  GPL
#    Copyright (c) 2000-2004 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
#

#


regex(.*\.cpp$)    -except

# ------------------------------------------------------------------------------
# basic types and component test
# ------------------------------------------------------------------------------

Data_Types.hpp inc=ggg91.h,\
                   SAPDB_EnhancedTypes.hpp,\
                   SAPDB_Types.hpp,\
                   SAPDBTrace_Topic.hpp,\
                   SAPDBDiag_CheckTopic.hpp

Data_Types.cpp inc=Data_Types.hpp
                   

# ------------------------------------------------------------------------------
# Exceptions ans Messages
# ------------------------------------------------------------------------------

Data_Messages.genmsg    ascii
Data_Messages.hpp       inc=SAPDBErr_MessageList.hpp

Data_Exceptions.hpp     inc=SAPDB_Types.hpp,SAPDBErr_MessageList.hpp

# ------------------------------------------------------------------------------
# class Data_PageAccessManager
# ------------------------------------------------------------------------------

Data_IPageAccessManager.hpp inc=SAPDB_Types.hpp,Data_Types.hpp

Data_PageAccessManager.hpp  inc=ggg00,gbd00,\
                                Data_IPageAccessManager.hpp,\
                                Data_Page.hpp,\
                                Data_FileTypes.hpp
                                
Data_PageAccessManager.cpp  inc=ggg00,hbd01_1.h,hbd13.h,hgg01_3.h,hgg04.h,\
                                SAPDBErr_Assertions.hpp,\
                                SAPDBTrace_Usage.hpp,\
                                Kernel_VTrace.hpp,\
                                Kernel_IAdminConfig.hpp,\
                                Kernel_Migration.hpp,\
                                Converter_IPageNoManager.hpp,\
                                Converter_IVerify.hpp,\
                                Data_PageAccessManager.hpp,\
                                Data_Exceptions.hpp,\
                                Data_Messages.hpp

# ------------------------------------------------------------------------------
# class Data_SplitSpace
# ------------------------------------------------------------------------------

Data_ISplitSpace.hpp inc=SAPDB_Types.hpp,\
                         SAPDBMem_IRawAllocator.hpp,\
                         SAPDBTrace_Usage.hpp,\
                         Kernel_VTrace.hpp,\
                         Data_Types.hpp

Data_SplitSpace.hpp  inc=SAPDB_Types.hpp,\
                         SAPDB_EnhancedTypes.hpp,\
                         SAPDBErr_Assertions.hpp,\
                         SAPDBMem_IRawAllocator.hpp,\
                         Kernel_VTrace.hpp,\
                         Container_Vector.hpp,\
                         Data_Types.hpp,\
                         Data_Messages.hpp,\
                         Data_Exceptions.hpp,\
                         Data_ISplitSpace.hpp
                                     
# ------------------------------------------------------------------------------
# classes for pages
# ------------------------------------------------------------------------------

Data_BasePage.hpp           inc=gbd00,\
                                 Converter_Version.hpp,\
                                 Data_Types.hpp,\
                                 Kernel_Page72.hpp,\
                                 Kernel_Common.hpp,\
                                 SAPDB_PersistentTypes.hpp

Data_BasePage.cpp           inc=ggg00,\
                                hgg01_3.h,\
                                Data_BasePage.hpp,\
                                Data_Exceptions.hpp,\
                                Data_Messages.hpp,\
                                Kernel_Exception.hpp,\
                                Kernel_Messages.hpp,\
                                Kernel_Page.hpp,\
                                RTE_Message.hpp

Data_Page.hpp               inc=SAPDB_Types.hpp,\
                                Data_BasePage.hpp,\
                                Data_Types.hpp,\
                                Data_IPageAccessManager.hpp,\
                                SAPDBErr_Assertions.hpp,\
                                gbd00

Data_Page.cpp               inc=Data_Page.hpp,\
                                Data_Types.hpp,\
                                Data_Messages.hpp,\
                                Data_Exceptions.hpp,\
                                Kernel_VTrace.hpp,\
                                SAPDB_ToString.hpp,\
                                SAPDBErr_Assertions.hpp,\
                                SAPDB_Types.hpp
                                
Data_ChainPage.hpp          inc=SAPDBErr_Assertions.hpp,\
                                Data_Types.hpp,\
                                Data_Page.hpp

Data_PrimPage.hpp           inc=Data_Page.hpp,\
                                 Data_Types.hpp,\
                                 Kernel_Common.hpp

Data_PageSplitSpace.hpp     inc=SAPDBErr_Assertions.hpp,\
                                Data_ChainPage.hpp

Data_PageSplitSpace.cpp     inc=Data_PageSplitSpace.hpp,\
                                Data_Exceptions.hpp,\
                                Data_Types.hpp,\
                                Data_Messages.hpp,\
                                Data_Exceptions.hpp,\
                                Kernel_VTrace.hpp,\
                                SAPDB_ToString.hpp

Data_PageFixSizeSpace.hpp   inc=SAPDBErr_Assertions.hpp,\
                                Data_ChainPage.hpp

# ------------------------------------------------------------------------------
# classes chains
# ------------------------------------------------------------------------------

Data_Chain.hpp                        inc=SAPDBErr_Assertions.hpp,\
                                          SAPDBTrace_Usage.hpp,\
                                          Kernel_VTrace.hpp,\
                                          Data_Types.hpp,\
                                          Data_ChainPage.hpp,\
                                          Data_Exceptions.hpp,\
                                          Data_Messages.hpp,\
                                          Data_IPageAccessManager.hpp

Data_ChainSplitSpaceBackwardRead.hpp  inc=SAPDBErr_Assertions.hpp,\
                                          SAPDBMem_IRawAllocator.hpp,\
                                          SAPDBTrace_Usage.hpp,\
                                          Data_Exceptions.hpp,\
                                          Data_Chain.hpp,\
                                          Data_SplitSpace.hpp,\
                                          Data_PageSplitSpace.hpp
                                     
Data_ChainSplitSpaceForwardRead.hpp   inc=SAPDBErr_Assertions.hpp,\
                                          SAPDBMem_IRawAllocator.hpp,\
                                          SAPDBTrace_Usage.hpp,\
                                          Data_Exceptions.hpp,\
                                          Data_Chain.hpp,\
                                          Data_SplitSpace.hpp,\
                                          Data_PageSplitSpace.hpp

Data_ChainFixSizeSpace.hpp            inc=Data_Exceptions.hpp,\
                                          Data_Messages.hpp,\
                                          Data_PageFixSizeSpace.hpp,\
                                          Data_Chain.hpp

# Data_ChainVarSizeSpace.hpp          inc=Data_Chain.hpp

# ------------------------------------------------------------------------------
# class Data_PrimTreeAccess
# ------------------------------------------------------------------------------

Data_RandomTreeAccess.hpp               inc=gbd00,\
                                          Container_Vector.hpp,\
                                          Data_Types.hpp,\
                                          Data_PageAccessManager.hpp,\
                                          Data_PrimPage.hpp,\
                                          Kernel_Common.hpp,\
                                          SAPDB_EnhancedTypes.hpp

Data_RandomTreeAccess.cpp               inc=ggg90.h,\
                                          hbd30.h,\
                                          hgg01_3.h,\
                                          Data_Messages.hpp,\
                                          Data_Exceptions.hpp,\
                                          RTE_Crash.hpp,\
                                          Data_RandomTreeAccess.hpp

Data_ScanTreeAccess.hpp                 inc=gsp00,\
                                          ggg00,\
                                          gbd00,\
                                          Data_Types.hpp,\
                                          Data_PageAccessManager.hpp,\
                                          Data_PrimPage.hpp,\
                                          Kernel_Common.hpp,\
                                          SAPDBMem_IRawAllocator.hpp

Data_ScanTreeAccess.cpp                 inc=hbd13.h,\
                                          hbd20_2.h,\
                                          hbd30.h,\
                                          hbd50.h,\
                                          heo56.h,\
                                          hgg05.h,\
                                          hgg01_3.h,\
                                          Data_Messages.hpp,\
                                          Data_Exceptions.hpp,\
                                          Kernel_FileIO.hpp,\
                                          RTE_Message.hpp,\
                                          RTE_Crash.hpp,\
                                          SAPDB_ToString.hpp,\
                                          SQLManErr_Interface.hpp,\
                                          Data_ScanTreeAccess.hpp

Data_IndexScanTreeAccess.hpp              inc=ggg00,\
                                          gbd00,\
                                          Data_Types.hpp,\
                                          Data_PageAccessManager.hpp,\
                                          Data_PrimPage.hpp,\
                                          Kernel_Common.hpp

Data_IndexScanTreeAccess.cpp        inc=ggg90.h,\
                                        Data_IndexScanTreeAccess.hpp

Data_TraverseTreeAccess.hpp         inc=ggg00,\
                                        gbd00,\
                                        Data_Types.hpp,\
                                        Data_PageAccessManager.hpp,\
                                        Data_PrimPage.hpp,\
                                        Kernel_Common.hpp

Data_TraverseTreeAccess.cpp         inc=ggg90.h,\
                                        hbd30.h,\
                                        hgg01_3.h,\
                                        RTE_Crash.hpp,\
                                        Data_Messages.hpp,\
                                        Data_Exceptions.hpp,\
                                        Data_TraverseTreeAccess.hpp

# ------------------------------------------------------------------------------
# class Data_Statistic
# ------------------------------------------------------------------------------

Data_PrimTreeStatistic.hpp              inc=ggg00,\
                                          gbd00,\
                                          Kernel_Common.hpp,\
                                          Data_Types.hpp,\
                                          Data_PrimPage.hpp,\
                                          Kernel_TableStatistic.hpp

Data_PrimTreeStatistic.cpp              inc=hbd01_1.h,\
                                          hbd05.h,\
                                          hbd30.h,\
                                          hgg04.h,\
                                          hgg01_3.h,\
                                          hgg10.h,\
                                          ggg90.h,\
                                          heo50.h,\
                                          hsp30.h,\
                                          Container_Vector.hpp,\
                                          Converter_IPageNoManager.hpp,\
                                          Data_PrimTreeStatistic.hpp,\
                                          Data_RandomTreeAccess.hpp,\
                                          Data_ScanTreeAccess.hpp,\
                                          Data_IndexScanTreeAccess.hpp,\
                                          Data_TraverseTreeAccess.hpp,\
                                          Data_PageAccessManager.hpp,\
                                          Data_Messages.hpp,\
                                          Data_Exceptions.hpp,\
                                          Kernel_FileIO.hpp,\
                                          Kernel_VTrace.hpp,\
                                          RTE_Message.hpp,\
                                          SAPDB_ToString.hpp,\
                                          SQLManErr_Interface.hpp,\
                                          MemoryManagement/SAPDBMem_IRawAllocator.hpp

# ------------------------------------------------------------------------------
# Data_Wrapper Interface for Pascal/Cpp 
# ------------------------------------------------------------------------------

Data_Wrapper.cpp                        inc=gsp00,\
                                            ggg00,\
                                            gbd00,\
                                            DataAccess/Data_PrimTreeStatistic.hpp,\
                                            Kernel_TableStatistic.hpp

# ------------------------------------------------------------------------------
# Data_*File*
# ------------------------------------------------------------------------------
Data_IFile.hpp                          inc=
Data_BaseFile.hpp                       inc=Data_Types.hpp,\
                                            Data_PageAccessManager.hpp,\
                                            Data_IFile.hpp,\
                                            Data_FileTypes.hpp
Data_BaseFile.cpp                       inc=Data_BaseFile.hpp,\
                                            Data_Types.hpp,\
                                            Kernel_VTrace.hpp
# ------------------------------------------------------------------------------
# Data_[Page]PrimaryFile
# ------------------------------------------------------------------------------
Data_PagePrimaryFile.hpp                inc=Data_Page.hpp
Data_PagePrimaryFile.cpp                inc=Data_PagePrimaryFile.hpp

Data_PrimaryFile.hpp                    inc=Data_BaseFile.hpp
Data_PrimaryFile.cpp                    inc=Data_PrimaryFile.hpp,\
                                            Data_PagePrimaryFile.hpp
# ------------------------------------------------------------------------------
# Data_*File*
# ------------------------------------------------------------------------------
Data_TempFile.hpp                       inc=Data_BaseFile.hpp,\
                                            Data_ChainFixSizeSpace.hpp
Data_TempFile.cpp                       inc=Data_TempFile.hpp,\
                                            SAPDB_MemCopyMove.hpp
# ------------------------------------------------------------------------------
# class Data_Test
# ------------------------------------------------------------------------------

Data_Test.hpp  inc=ggg00
Data_Test.cpp  inc=SAPDBErr_Assertions.hpp,\
                   SAPDBMem_IRawAllocator.hpp,\
                   SAPDBTrace_Usage.hpp,\
                   Data_PageAccessManager.hpp,\
                   Data_Chain.hpp,\
                   Data_PageSplitSpace.hpp,\
                   Data_ChainSplitSpaceBackwardRead.hpp,\
                   Data_ChainSplitSpaceForwardRead.hpp,\
                   Data_ChainFixSizeSpace.hpp,\
                   Data_PrimaryFile.hpp,\
                   Data_TempFile.hpp,\
                   Data_Test.hpp,\
                   Kernel_IAdminInfo.hpp,\
                   Container_Vector.hpp

&if $OSSPEC == LINUX && $MACH in [ S390X, IA64 ]
regex(\w+\.cpp) -OPT=-O2
&endif

