/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.powertoys;

import com.sap.dbtech.powertoys.RepmanException;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.rte.comm.SocketComm;
import com.sap.dbtech.util.StructuredMem;
import java.util.Properties;

public class Repman {
    private static final String hostKeyC = "host";
    private static final String hostDefaultC = "localhost";
    private static final String dbnameKeyC = "dbname";
    private static final String dbnameDefaultC = "";
    private static final String dbrootKeyC = "dbroot";
    private static final String dbrootDefaultC = "";
    private static final String userKeyC = "user";
    private static final String pgmNameC = "lserver";
    private static final int alignSizeC = 8;
    static final int indicatorLengthC = 4;
    private SocketComm connection;

    public Repman(Properties properties) throws RTEException {
        String string = properties.getProperty(hostKeyC, hostDefaultC);
        String string2 = properties.getProperty(dbnameKeyC, "");
        String string3 = properties.getProperty(dbrootKeyC, "");
        this.connection = SocketComm.sqlxconnect(string, string2, string3, pgmNameC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws RTEException {
        if (this.connection != null) {
            try {
                this.connection.release();
            }
            finally {
                this.connection = null;
            }
        }
    }

    public void finalize() throws RTEException {
        this.release();
    }

    public String cmd(String string) throws RTEException, RepmanException {
        StructuredMem structuredMem = this.connection.getRequestPacket();
        int n = (string.length() + 8 - 1) / 8 * 8;
        structuredMem.putString(string, 0);
        this.connection.request(structuredMem, n);
        StructuredMem structuredMem2 = this.connection.receive();
        String string2 = structuredMem2.getString(0, Math.min(4, structuredMem2.size()));
        if (!string2.startsWith("OK")) {
            throw RepmanException.create(structuredMem2);
        }
        int n2 = string2.indexOf(10) + 1;
        String string3 = structuredMem2.getString(n2, structuredMem2.size() - n2);
        return string3;
    }

    public static Repman dbRepman(String string, String string2) throws RTEException {
        Properties properties = new Properties();
        if (string != null) {
            properties.put(hostKeyC, string);
        }
        if (string2 != null) {
            properties.put(dbnameKeyC, string2);
        }
        return new Repman(properties);
    }

    public static Repman dbrootRepman(String string, String string2) throws RTEException {
        Properties properties = new Properties();
        if (string != null) {
            properties.put(hostKeyC, string);
        }
        properties.put(dbrootKeyC, string2);
        return new Repman(properties);
    }
}

