/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.packet;

import com.sap.dbtech.jdbc.DBProcParameterInfo;
import com.sap.dbtech.jdbc.exceptions.DatabaseException;
import com.sap.dbtech.jdbc.packet.PartEnumeration;
import com.sap.dbtech.jdbc.packet.PartNotFound;
import com.sap.dbtech.jdbc.packet.SQLPacket;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.jdbc.translators.TranslatorFactory;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StringUtil;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.util.VDNNumber;
import java.io.PrintStream;
import java.sql.SQLException;

public class ReplyPacket
extends SQLPacket {
    private static PartNotFound thePartNotFound = new PartNotFound();
    private int cachedResultCount = Integer.MIN_VALUE;
    private int cachedPartCount = Integer.MIN_VALUE;
    private int[] partIndices;
    private int partIdx = -1;
    private int currentSegment;

    public ReplyPacket(StructuredMem structuredMem) {
        super(structuredMem);
        this.segmOffs = 32;
        this.currentSegment = 1;
        this.clearPartCache();
    }

    public DatabaseException createException() {
        String string = this.sqlState();
        int n = this.returnCode();
        String string2 = this.getErrorMsg();
        int n2 = this.errorPos();
        if (n == -8000) {
            string2 = MessageTranslator.translate("error.restart.required");
        }
        return new DatabaseException(string2, string, n, n2);
    }

    public int partCount() {
        if (this.cachedPartCount == Integer.MIN_VALUE) {
            this.cachedPartCount = super.partCount();
            return this.cachedPartCount;
        }
        return this.cachedPartCount;
    }

    int dumpSegment(PrintStream printStream, int n, int n2) {
        printStream.println("   <SEGMENT ");
        printStream.println("    type=\"REPLY\"");
        printStream.println("    index=\"" + this.getInt2(n2 + 10) + "\"");
        printStream.println("    offset=\"" + this.getInt4(n2 + 4) + "\"");
        printStream.println("    length=\"" + this.getInt4(n2 + 0) + "\"");
        printStream.println("    number_of_parts=\"" + this.getInt2(n2 + 8) + "\"");
        StringUtil.fprintfs(printStream, "    <! %s (%d) Pos: %d  Warnings (%x, %x)  Function: %d >\n", new Object[]{this.getString(n2 + 13, 5), new Integer(this.getInt2(n2 + 18)), new Integer(this.getInt4(n2 + 20)), new Integer(this.getInt2(n2 + 24)), new Integer(this.getInt2(n2 + 26)), new Integer(this.getInt2(n2 + 28))});
        int n3 = this.getInt2(n2 + 8);
        int n4 = n2 + 40;
        for (int i = 0; i < n3; ++i) {
            n4 += this.dumpPart(printStream, n, n4);
        }
        printStream.println("   </SEGMENT> ");
        return this.getInt4(n2 + 0);
    }

    public int errorPos() {
        return this.mem.getInt4(this.segmOffs + 20);
    }

    public boolean existsPart(int n) {
        boolean bl;
        try {
            this.findPart(n);
            bl = true;
        }
        catch (PartNotFound partNotFound) {
            bl = false;
        }
        return bl;
    }

    public int findPart(int n) throws PartNotFound {
        this.partOffs = -1;
        this.partIdx = -1;
        for (int i = this.partCount(); i > 0; --i) {
            this.nextPart();
            if (this.partKind() != n) continue;
            return this.partPos();
        }
        throw thePartNotFound;
    }

    private int firstPart() {
        this.partIdx = 0;
        this.partOffs = this.partIndices[this.partIdx];
        return this.partOffs;
    }

    public int firstSegment() {
        int n = this.segmCount() > 0 ? 32 : -1;
        this.segmOffs = n;
        this.currentSegment = 1;
        this.clearPartCache();
        return n;
    }

    public int functionCode() {
        return this.mem.getInt2(this.segmOffs + 28);
    }

    public byte[] getDataBytes(int n, int n2) {
        byte by = this.mem.getInt1(n);
        if (by == 255) {
            return null;
        }
        byte[] byArray = this.mem.getBytes(n + 1, n2 - 1);
        return byArray;
    }

    public String getErrorMsg() {
        String string;
        try {
            this.findPart(6);
            int n = this.getPartDataPos();
            int n2 = this.partLength();
            string = this.getString(n, n2).trim();
        }
        catch (PartNotFound partNotFound) {
            string = MessageTranslator.translate("error");
        }
        return string;
    }

    public int getPartDataPos() {
        return this.partOffs + 16;
    }

    int nextPart() {
        ++this.partIdx;
        this.partOffs = this.partIndices[this.partIdx];
        return this.partOffs;
    }

    public int nextSegment() {
        if (this.segmCount() <= this.currentSegment++) {
            return -1;
        }
        this.segmOffs += this.segmLength();
        this.clearPartCache();
        return this.segmOffs;
    }

    public String[] parseColumnNames() {
        int n = this.partArguments();
        String[] stringArray = new String[n];
        int n2 = this.getPartDataPos();
        for (int i = 0; i < n; ++i) {
            byte by = this.getInt1(n2);
            stringArray[i] = this.getString(n2 + 1, by);
            n2 += by + 1;
        }
        return stringArray;
    }

    public byte[][] parseLongDescriptors() {
        if (!this.existsPart(18)) {
            return null;
        }
        int n = this.partArguments();
        byte[][] byArrayArray = new byte[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = i * 41 + 1;
            byArrayArray[i] = this.getBytes(this.getPartDataPos() + n2, 40);
        }
        return byArrayArray;
    }

    public DBTechTranslator[] parseShortFields(boolean bl, DBProcParameterInfo[] dBProcParameterInfoArray) throws SQLException {
        int n = this.partArguments();
        DBTechTranslator[] dBTechTranslatorArray = new DBTechTranslator[n];
        int n2 = this.getPartDataPos();
        for (int i = 0; i < n; ++i) {
            DBProcParameterInfo dBProcParameterInfo = null;
            if (dBProcParameterInfoArray != null && dBProcParameterInfoArray.length > i) {
                dBProcParameterInfo = dBProcParameterInfoArray[i];
            }
            byte by = this.getInt1(n2 + 0);
            byte by2 = this.getInt1(n2 + 1);
            byte by3 = this.getInt1(n2 + 2);
            byte by4 = this.getInt1(n2 + 3);
            int n3 = this.getInt2(n2 + 4);
            int n4 = this.getInt2(n2 + 6);
            int n5 = this.getInt4(n2 + 8);
            dBTechTranslatorArray[i] = this.getTranslator(by, by2, by3, by4, n3, n4, n5, bl, dBProcParameterInfo);
            n2 += 12;
        }
        return dBTechTranslatorArray;
    }

    protected DBTechTranslator getTranslator(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, DBProcParameterInfo dBProcParameterInfo) throws SQLException {
        return TranslatorFactory.create(n, n2, n3, n4, n5, n6, n7, bl, dBProcParameterInfo);
    }

    public int partArguments() {
        return this.mem.getInt2(this.partOffs + 2);
    }

    public PartEnumeration partEnumeration() {
        this.partIdx = -1;
        this.partOffs = -1;
        return new PartEnumeration(this);
    }

    int partKind() {
        return this.mem.getInt1(this.partOffs + 0);
    }

    public int partLength() {
        return this.mem.getInt4(this.partOffs + 8);
    }

    int partPos() {
        return this.partOffs;
    }

    public int resultCount(boolean bl) throws SQLException {
        if (this.cachedResultCount == Integer.MIN_VALUE) {
            if (!bl) {
                try {
                    this.findPart(12);
                }
                catch (PartNotFound partNotFound) {
                    this.cachedResultCount = -1;
                    return -1;
                }
            }
            byte[] byArray = this.getDataBytes(this.partOffs + 16, this.partLength());
            this.cachedResultCount = VDNNumber.number2int(byArray);
            return this.cachedResultCount;
        }
        return this.cachedResultCount;
    }

    public int getSessionID() {
        int n;
        try {
            this.findPart(20);
            n = this.mem.getInt4(this.getPartDataPos() + 1);
        }
        catch (PartNotFound partNotFound) {
            n = -1;
        }
        return n;
    }

    public int getKernelMajorVersion() {
        int n;
        try {
            this.findPart(20);
            n = Integer.parseInt(this.mem.getString(this.getPartDataPos() + 2200, 1));
        }
        catch (PartNotFound partNotFound) {
            n = -1;
        }
        return n;
    }

    public int getKernelMinorVersion() {
        int n;
        try {
            this.findPart(20);
            n = Integer.parseInt(this.mem.getString(this.getPartDataPos() + 2201, 2));
        }
        catch (PartNotFound partNotFound) {
            n = -1;
        }
        return n;
    }

    public int getKernelCorrectionLevel() {
        int n;
        try {
            this.findPart(20);
            n = Integer.parseInt(this.mem.getString(this.getPartDataPos() + 2203, 2));
        }
        catch (PartNotFound partNotFound) {
            n = -1;
        }
        return n;
    }

    public final int returnCode() {
        return this.mem.getInt2(this.segmOffs + 18);
    }

    private int segmLength() {
        return this.mem.getInt4(this.segmOffs + 0);
    }

    public String sqlState() {
        return this.mem.getString(this.segmOffs + 13, 5);
    }

    public boolean wasLastPart() {
        byte by = this.getInt1(this.partOffs + 1);
        boolean bl = (by & 1) != 0;
        return bl;
    }

    public final int weakReturnCode() {
        int n = this.returnCode();
        if (n == 100) {
            switch (this.functionCode()) {
                case 34: 
                case 206: 
                case 207: 
                case 208: 
                case 209: 
                case 210: 
                case 211: 
                case 247: 
                case 248: 
                case 1206: 
                case 1207: 
                case 1208: 
                case 1209: 
                case 1210: 
                case 1211: 
                case 1247: {
                    break;
                }
                default: {
                    n = 0;
                }
            }
        }
        return n;
    }

    private final void clearPartCache() {
        this.cachedResultCount = Integer.MIN_VALUE;
        this.cachedPartCount = Integer.MIN_VALUE;
        int n = this.mem.getInt2(this.segmOffs + 8);
        this.partIndices = new int[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (i == 0) {
                n2 = this.partIndices[i] = this.segmOffs + 40;
                continue;
            }
            int n3 = this.mem.getInt4(n2 + 8);
            n2 = this.partIndices[i] = n2 + this.aligned(n3 + 16);
        }
    }

    public int parseABAPTabIDForInput() throws SQLException {
        try {
            this.findPart(25);
        }
        catch (PartNotFound partNotFound) {
            throw new SQLException("Internal error: expected ABAP input stream part.");
        }
        return this.getInt4(this.getPartDataPos());
    }

    public int parseABAPTabIDForOutput() throws SQLException {
        try {
            this.findPart(26);
        }
        catch (PartNotFound partNotFound) {
            throw new SQLException("Internal error: expected ABAP output stream part.");
        }
        return this.getInt4(this.getPartDataPos());
    }
}

