/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc;

import com.sap.dbtech.jdbc.CallableStatementSapDB;
import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.FetchInfo;
import com.sap.dbtech.jdbc.ResultSetSapDB;
import com.sap.dbtech.jdbc.exceptions.DatabaseException;
import com.sap.dbtech.jdbc.exceptions.InternalJDBCError;
import com.sap.dbtech.jdbc.exceptions.InvalidColumnException;
import com.sap.dbtech.jdbc.exceptions.JDBCDriverException;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StringUtil;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Vector;

public class UpdatableResultSetSapDB
extends ResultSetSapDB {
    private String tableName;
    private CallableStatementSapDB insertCmd;
    private CallableStatementSapDB updateCmd;
    private CallableStatementSapDB deleteCmd;
    private CallableStatementSapDB currentChangeCmd;
    private int[] updateColMapping;
    private int savedCurrentRow;
    private int savedPositionState;
    private static final int MODE_READ = 0;
    private static final int MODE_INSERT = 1;
    private static final int MODE_UPDATE = 2;
    private int currentMode = 0;
    private static final int noUpdatedRecordInCache_C = -1;

    UpdatableResultSetSapDB(ConnectionSapDB connectionSapDB, FetchInfo fetchInfo, Statement statement, int n, int n2, String string, boolean bl) throws SQLException {
        super(connectionSapDB, fetchInfo, statement, n, n2, bl);
        this.tableName = string;
    }

    UpdatableResultSetSapDB(ConnectionSapDB connectionSapDB, String string, DBTechTranslator[] dBTechTranslatorArray, String[] stringArray, Statement statement, int n, int n2, String string2, boolean bl) throws SQLException {
        super(connectionSapDB, string, dBTechTranslatorArray, stringArray, statement, n, n2, bl);
        this.tableName = string2;
    }

    public boolean absolute(int n) throws SQLException {
        this.internalCancelRowUpdates();
        return super.absolute(n);
    }

    public void afterLast() throws SQLException {
        this.internalCancelRowUpdates();
        super.afterLast();
    }

    public void beforeFirst() throws SQLException {
        this.internalCancelRowUpdates();
        super.beforeFirst();
    }

    public void cancelRowUpdates() throws SQLException {
        if (this.currentMode == 1) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.cancelupdates.insertrow"));
        }
        this.internalCancelRowUpdates();
    }

    private void internalCancelRowUpdates() throws SQLException {
        if (this.currentChangeCmd != null) {
            this.currentChangeCmd.clearParameters();
        }
        this.currentMode = 0;
    }

    public void deleteRow() throws SQLException {
        this.assertNotClosed();
        if (this.currentMode == 1) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.deleterow.insertrow"));
        }
        int n = this.getRow();
        if (n == 0) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.deleterow.norow"));
        }
        if (this.deleteCmd == null) {
            String string = "DELETE FROM " + this.tableName + " WHERE POS OF \"" + this.getCursorName() + "\" IS ? ";
            this.deleteCmd = (CallableStatementSapDB)this.connection.prepareStatement(string);
        }
        this.deleteCmd.setInt(1, n);
        this.deleteCmd.execute();
        this.initializeFields();
        this.absolute(n);
    }

    private int findUpdateColumn(int n) throws SQLException {
        this.assertNotClosed();
        this.prepareUpdate();
        int n2 = 0;
        try {
            n2 = this.updateColMapping[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new InvalidColumnException(n, (Object)this);
        }
        if (n2 == 0) {
            throw new InvalidColumnException(n, (Object)this);
        }
        return n2;
    }

    private int findUpdateColumn(String string) throws SQLException {
        int n = this.findColumnInfo(string).getColIndex();
        return this.findUpdateColumn(n + 1);
    }

    public boolean first() throws SQLException {
        this.internalCancelRowUpdates();
        return super.first();
    }

    public int getConcurrency() throws SQLException {
        this.assertNotClosed();
        return 1008;
    }

    public void insertRow() throws SQLException {
        if (this.currentMode != 1) {
            throw new SQLException(MessageTranslator.translate("error.insertrow.insertrow"));
        }
        this.insertCmd.executeUpdate();
        this.currentMode = 1;
    }

    public boolean last() throws SQLException {
        this.internalCancelRowUpdates();
        return super.last();
    }

    public void moveToInsertRow() throws SQLException {
        this.assertNotClosed();
        switch (this.currentMode) {
            case 1: {
                break;
            }
            case 2: {
                this.internalCancelRowUpdates();
            }
            case 0: {
                if (this.insertCmd == null) {
                    this.insertCmd = this.prepareHelper(1);
                }
                this.savedPositionState = this.positionState;
                this.savedCurrentRow = this.getRow();
                this.currentChangeCmd = this.insertCmd;
                this.currentMode = 1;
            }
        }
    }

    public void moveToCurrentRow() throws SQLException {
        this.assertNotClosed();
        if (this.currentMode == 1) {
            if (this.currentChangeCmd != null) {
                this.currentChangeCmd.clearParameters();
            }
            this.currentMode = 0;
            switch (this.savedPositionState) {
                case 1: {
                    this.beforeFirst();
                    break;
                }
                case 3: {
                    this.afterLast();
                    break;
                }
                default: {
                    if (this.savedPositionState != 0) {
                        this.absolute(this.savedCurrentRow);
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else {
            return;
        }
    }

    private CallableStatementSapDB prepareHelper(int n) throws SQLException {
        int n2;
        String string;
        String string2;
        switch (n) {
            case 2: {
                string2 = "UPDATE " + this.tableName + " SET \"";
                string = "\" = ? WHERE POS OF \"" + this.getCursorName() + "\" IS ? ";
                break;
            }
            case 1: {
                string2 = "INSERT INTO " + this.tableName + " SET \"";
                string = "\" = ?";
                break;
            }
            default: {
                return null;
            }
        }
        CallableStatementSapDB callableStatementSapDB = null;
        DBTechTranslator[] dBTechTranslatorArray = this.getColInfo();
        int n3 = dBTechTranslatorArray.length;
        Vector<String> vector = new Vector<String>(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            vector.addElement(dBTechTranslatorArray[n2].getColumnName());
        }
        n2 = n3;
        while (callableStatementSapDB == null && vector.size() > 0 && n2 > 0) {
            --n2;
            String string3 = StringUtil.join(vector.elements(), "\" = ?, \"");
            String string4 = string2 + string3 + string;
            try {
                callableStatementSapDB = (CallableStatementSapDB)this.getConnection().prepareCall(string4);
            }
            catch (DatabaseException databaseException) {
                if (databaseException.getErrorCode() == -7032) {
                    throw databaseException;
                }
                int n4 = databaseException.getErrorPos() - 1;
                if (n4 < string2.length()) {
                    throw new InternalJDBCError(MessageTranslator.translate("error.internal.preparehelper"), databaseException);
                }
                int n5 = string4.indexOf(34, n4);
                String string5 = string4.substring(n4, n5);
                vector.removeElement(string5);
            }
        }
        if (callableStatementSapDB == null) {
            throw new JDBCDriverException(MessageTranslator.translate("error.nocolumns.updatable"));
        }
        int n6 = vector.size();
        this.updateColMapping = new int[n3 + 1];
        for (int i = 0; i < n6; ++i) {
            DBTechTranslator dBTechTranslator = this.findColumnInfo((String)vector.elementAt(i));
            dBTechTranslator.allowWrites();
            this.updateColMapping[dBTechTranslator.getColIndex() + 1] = i + 1;
        }
        return callableStatementSapDB;
    }

    private void prepareUpdate() throws SQLException {
        if (this.currentMode == 0) {
            if (this.updateCmd == null) {
                this.updateCmd = this.prepareHelper(2);
            }
            this.currentChangeCmd = this.updateCmd;
            this.currentMode = 2;
            int n = this.numberOfColumns();
            for (int i = 0; i < n; ++i) {
                int n2 = i + 1;
                try {
                    this.updateCmd.setObject(this.findUpdateColumn(n2), this.getObject(n2));
                    continue;
                }
                catch (InvalidColumnException invalidColumnException) {
                    // empty catch block
                }
            }
        }
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        int n3 = this.findUpdateColumn(n);
        this.currentChangeCmd.setAsciiStream(n3, inputStream, n2);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        int n2 = this.findUpdateColumn(string);
        this.currentChangeCmd.setAsciiStream(n2, inputStream, n);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        int n2 = this.findUpdateColumn(n);
        this.currentChangeCmd.setBigDecimal(n2, bigDecimal);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        int n = this.findUpdateColumn(string);
        this.currentChangeCmd.setBigDecimal(n, bigDecimal);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        int n3 = this.findUpdateColumn(n);
        this.currentChangeCmd.setBinaryStream(n3, inputStream, n2);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        int n2 = this.findUpdateColumn(string);
        this.currentChangeCmd.setBinaryStream(n2, inputStream, n);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        int n2 = this.findUpdateColumn(n);
        this.currentChangeCmd.setBoolean(n2, bl);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        int n = this.findUpdateColumn(string);
        this.currentChangeCmd.setBoolean(n, bl);
    }

    public void updateByte(int n, byte by) throws SQLException {
        int n2 = this.findUpdateColumn(n);
        this.currentChangeCmd.setByte(n2, by);
    }

    public void updateByte(String string, byte by) throws SQLException {
        int n = this.findUpdateColumn(string);
        this.currentChangeCmd.setByte(n, by);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        int n2 = this.findUpdateColumn(n);
        this.currentChangeCmd.setBytes(n2, byArray);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        int n = this.findUpdateColumn(string);
        this.currentChangeCmd.setBytes(n, byArray);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        int n3 = this.findUpdateColumn(n);
        this.currentChangeCmd.setCharacterStream(n3, reader, n2);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        int n2 = this.findUpdateColumn(string);
        this.currentChangeCmd.setCharacterStream(n2, reader, n);
    }

    public void updateDate(int n, Date date) throws SQLException {
        int n2 = this.findUpdateColumn(n);
        this.currentChangeCmd.setDate(n2, date);
    }

    public void updateDate(String string, Date date) throws SQLException {
        int n = this.findUpdateColumn(string);
        this.currentChangeCmd.setDate(n, date);
    }

    public void updateDouble(int n, double d) throws SQLException {
        int n2 = this.findUpdateColumn(n);
        this.currentChangeCmd.setDouble(n2, d);
    }

    public void updateDouble(String string, double d) throws SQLException {
        int n = this.findUpdateColumn(string);
        this.currentChangeCmd.setDouble(n, d);
    }

    public void updateFloat(int n, float f) throws SQLException {
        int n2 = this.findUpdateColumn(n);
        this.currentChangeCmd.setFloat(n2, f);
    }

    public void updateFloat(String string, float f) throws SQLException {
        int n = this.findUpdateColumn(string);
        this.currentChangeCmd.setFloat(n, f);
    }

    public void updateInt(int n, int n2) throws SQLException {
        int n3 = this.findUpdateColumn(n);
        this.currentChangeCmd.setInt(n3, n2);
    }

    public void updateInt(String string, int n) throws SQLException {
        int n2 = this.findUpdateColumn(string);
        this.currentChangeCmd.setInt(n2, n);
    }

    public void updateLong(int n, long l) throws SQLException {
        int n2 = this.findUpdateColumn(n);
        this.currentChangeCmd.setLong(n2, l);
    }

    public void updateLong(String string, long l) throws SQLException {
        int n = this.findUpdateColumn(string);
        this.currentChangeCmd.setLong(n, l);
    }

    public void updateNull(int n) throws SQLException {
        int n2 = this.findUpdateColumn(n);
        this.currentChangeCmd.setNull(n2, 0);
    }

    public void updateNull(String string) throws SQLException {
        int n = this.findUpdateColumn(string);
        this.currentChangeCmd.setNull(n, 0);
    }

    public void updateObject(int n, Object object) throws SQLException {
        int n2 = this.findUpdateColumn(n);
        this.currentChangeCmd.setObject(n2, object);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        int n3 = this.findUpdateColumn(n);
        this.currentChangeCmd.setObject(n3, object, n2);
    }

    public void updateObject(String string, Object object) throws SQLException {
        int n = this.findUpdateColumn(string);
        this.currentChangeCmd.setObject(n, object);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        int n2 = this.findUpdateColumn(string);
        this.currentChangeCmd.setObject(n2, object, n);
    }

    public void updateRow() throws SQLException {
        int n = this.currentMode;
        CallableStatementSapDB callableStatementSapDB = this.currentChangeCmd;
        this.currentChangeCmd = null;
        int n2 = this.getRow();
        this.currentMode = n;
        this.currentChangeCmd = callableStatementSapDB;
        if (n2 == 0) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.updaterow.norow"));
        }
        if (this.currentMode == 2) {
            this.updateCmd.setInt(this.updateCmd.parseinfo.inputCount, n2);
            this.updateCmd.executeUpdate();
            this.absolute(n2);
            this.currentMode = 0;
            this.modifiedKernelPos = n2;
        } else if (this.currentMode == 1) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.updaterow.insertrow"));
        }
    }

    public void updateShort(int n, short s) throws SQLException {
        int n2 = this.findUpdateColumn(n);
        this.currentChangeCmd.setShort(n2, s);
    }

    public void updateShort(String string, short s) throws SQLException {
        int n = this.findUpdateColumn(string);
        this.currentChangeCmd.setShort(n, s);
    }

    public void updateString(int n, String string) throws SQLException {
        int n2 = this.findUpdateColumn(n);
        this.currentChangeCmd.setString(n2, string);
    }

    public void updateString(String string, String string2) throws SQLException {
        int n = this.findUpdateColumn(string);
        this.currentChangeCmd.setString(n, string2);
    }

    public void updateTime(int n, Time time) throws SQLException {
        int n2 = this.findUpdateColumn(n);
        this.currentChangeCmd.setTime(n2, time);
    }

    public void updateTime(String string, Time time) throws SQLException {
        int n = this.findUpdateColumn(string);
        this.currentChangeCmd.setTime(n, time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        int n2 = this.findUpdateColumn(n);
        this.currentChangeCmd.setTimestamp(n2, timestamp);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        int n = this.findUpdateColumn(string);
        this.currentChangeCmd.setTimestamp(n, timestamp);
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        int n2 = this.findUpdateColumn(n);
        this.currentChangeCmd.setBlob(n2, blob);
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        int n = this.findUpdateColumn(string);
        this.currentChangeCmd.setBlob(n, blob);
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        int n2 = this.findUpdateColumn(n);
        this.currentChangeCmd.setClob(n2, clob);
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        int n = this.findUpdateColumn(string);
        this.currentChangeCmd.setClob(n, clob);
    }
}

