(**************************************************************************)
(*       ___                                                              *)
(*      ||M||                                                             *)
(*      ||A||       A project by Andrea Asperti                           *)
(*      ||T||                                                             *)
(*      ||I||       Developers:                                           *)
(*      ||T||         The HELM team.                                      *)
(*      ||A||         http://helm.cs.unibo.it                             *)
(*      \   /                                                             *)
(*       \ /        This file is distributed under the terms of the       *)
(*        v         GNU General Public License Version 2                  *)
(*                                                                        *)
(**************************************************************************)

include "properties/relations1.ma".
include "sets/setoids.ma".

nrecord setoid1: Type[2] ≝
 { carr1:> Type[1];
   eq1: equivalence_relation1 carr1
 }.

ndefinition setoid1_of_setoid: setoid → setoid1.
 #s; napply mk_setoid1
  [ napply (carr s)
  | napply (mk_equivalence_relation1 s)
    [ napply eq
    | napply refl
    | napply sym
    | napply trans]##]
nqed.

(*ncoercion setoid1_of_setoid : ∀s:setoid. setoid1 ≝ setoid1_of_setoid
 on _s: setoid to setoid1.*)
(*prefer coercion Type_OF_setoid.*)

interpretation "setoid1 eq" 'eq t x y = (eq_rel1 ? (eq1 t) x y).
interpretation "setoid eq" 'eq t x y = (eq_rel ? (eq t) x y).

notation > "hvbox(a break =_12 b)" non associative with precedence 45
for @{ eq_rel2 (carr2 (setoid2_of_setoid1 ?)) (eq2 (setoid2_of_setoid1 ?)) $a $b }.
notation > "hvbox(a break =_0 b)" non associative with precedence 45
for @{ eq_rel ? (eq ?) $a $b }.
notation > "hvbox(a break =_1 b)" non associative with precedence 45
for @{ eq_rel1 ? (eq1 ?) $a $b }.

interpretation "setoid1 symmetry" 'invert r = (sym1 ???? r).
interpretation "setoid symmetry" 'invert r = (sym ???? r).
notation ".= r" with precedence 50 for @{'trans $r}.
interpretation "trans1" 'trans r = (trans1 ????? r).
interpretation "trans" 'trans r = (trans ????? r).

nrecord unary_morphism1 (A,B: setoid1) : Type[1] ≝
 { fun11:1> A → B;
   prop11: ∀a,a'. eq1 ? a a' → eq1 ? (fun11 a) (fun11 a')
 }.

nrecord binary_morphism1 (A,B,C:setoid1) : Type[1] ≝
 { fun21:2> A → B → C;
   prop21: ∀a,a',b,b'. eq1 ? a a' → eq1 ? b b' → eq1 ? (fun21 a b) (fun21 a' b')
 }.

interpretation "prop11" 'prop1 c = (prop11 ????? c).
interpretation "prop21" 'prop2 l r = (prop21 ???????? l r).
interpretation "refl1" 'refl = (refl1 ???).
