(*
    ||M||  This file is part of HELM, an Hypertextual, Electronic        
    ||A||  Library of Mathematics, developed at the Computer Science     
    ||T||  Department, University of Bologna, Italy.                     
    ||I||                                                                
    ||T||  HELM is free software; you can redistribute it and/or         
    ||A||  modify it under the terms of the GNU General Public License   
    \   /  version 2 or (at your option) any later version.      
     \ /   This software is distributed as is, NO WARRANTY.     
      V_______________________________________________________________ *)

(* $Id: nCicRefiner.mli 9543 2009-02-11 16:27:33Z tassi $ *)

exception RefineFailure of (Stdpp.location * string) Lazy.t;;
exception Uncertain of (Stdpp.location * string) Lazy.t;;
exception AssertFailure of string Lazy.t;;

val typeof :
 NCicUnifHint.db ->
 ?localise:(NCic.term -> Stdpp.location) ->
 look_for_coercion:(
    NCic.metasenv -> NCic.substitution -> NCic.context -> 
    (* inferred type, expected type *)
    NCic.term -> NCic.term -> 
      (* enriched metasenv, new term, its type, metavriable to
       * be unified with the old term *)
      (NCic.metasenv * NCic.term * NCic.term * NCic.term) list
  ) ->
  NCic.metasenv -> NCic.substitution -> NCic.context -> 
  NCic.term -> NCic.term option -> (* term, expected type *)
    NCic.metasenv * NCic.substitution * NCic.term * NCic.term
    (*  menv, subst,refined term, type *)

val typeof_obj :
 NCicUnifHint.db ->
 ?localise:(NCic.term -> Stdpp.location) ->
 look_for_coercion:(
    NCic.metasenv -> NCic.substitution -> NCic.context -> 
    (* inferred type, expected type *)
    NCic.term -> NCic.term -> 
      (* enriched metasenv, new term, its type, metavriable to
       * be unified with the old term *)
      (NCic.metasenv * NCic.term * NCic.term * NCic.term) list
  ) ->
  NCic.obj -> NCic.obj

