/* matchbox - a lightweight window manager

   Copyright 2002 Matthew Allum

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

#include "structs.h"
#include "wm.h"
#include "misc.h"


#ifdef USE_XFT
#include <X11/Xft/Xft.h>
#endif


int main(int argc, char **argv)
{
   wm *w;
   struct sigaction act;
   memset(&act, 0, sizeof(struct sigaction));
   
   act.sa_handler = sig_handler;
   act.sa_flags = 0;
   sigaction(SIGTERM, &act, NULL);
   sigaction(SIGINT, &act,  NULL);
   sigaction(SIGHUP, &act,  NULL);
   sigaction(SIGCHLD, &act, NULL);

   signal (SIGCHLD, SIG_IGN); 	/* as now we exec via keyboard */

   /*   
#ifdef DEBUG
   _Xdebug =1;
#endif 
   */

   w = wm_new(argc, argv);

   wm_init_existing(w);
   wm_event_loop(w);
   
   return 1;
}






