#include "mbdesktop_module.h"

static int trapped_error_code = 0;
static int (*old_error_handler) (Display *d, XErrorEvent *e);

static Atom atom_client_list;

#ifdef USE_PNG
#define NOAPP_FN    "mbnoapp.png"
#else
#define NOAPP_FN    "mbnoapp.xpm"
#endif


static void
tasks_activate_cb (void *data1, void *data2);


static int
error_handler(Display     *display,
	      XErrorEvent *error)
{
   trapped_error_code = error->error_code;
   return 0;
}

static void
trap_errors(void)
{
   trapped_error_code = 0;
   old_error_handler = XSetErrorHandler(error_handler);
}

static int
untrap_errors(void)
{
   XSetErrorHandler(old_error_handler);
   return trapped_error_code;
}


static void *
get_win_prop_data (MBDesktop *mb, 
                   Window     win, 
                   Atom       prop, 
                   Atom       type, 
                   int       *items)
{
	Atom type_ret;
	int format_ret;
	unsigned long items_ret;
	unsigned long after_ret;
	unsigned char *prop_data;

	prop_data = 0;

	XGetWindowProperty (mbdesktop_xdisplay(mb), win, prop, 0, 0x7fffffff, False,
			    type, &type_ret, &format_ret, &items_ret,
			    &after_ret, &prop_data);
	if (items)
		*items = items_ret;

	return prop_data;
}


MBDesktopItem *
tasks_init (MBDesktop *mb, MBDesktopFolderModule *folder_module, char *arg_str)
{
 return mbdesktop_module_folder_create ( mb, "Active Tasks", "mbfolder.png" );
}

void
tasks_open (MBDesktop *mb, MBDesktopItem *item_folder)
{

  //MBDesktop *mb = (MBDesktop *)data1;

  MBDesktopItem *item = NULL, *item_new; 

  MBPixbufImage *img = NULL;
  Window *wins, win_trans_for;
  XWMHints *wmhints;
  XWindowAttributes winattr; 
  int i, num;
  char *icon_name = NULL;
  
  Atom atom_net_name    = XInternAtom(mbdesktop_xdisplay(mb), "_NET_WM_NAME",    False);
  Atom atom_net_win_type = XInternAtom(mbdesktop_xdisplay(mb), "_NET_WM_WINDOW_TYPE", False);
  Atom atom_net_wm_icon = XInternAtom(mbdesktop_xdisplay(mb), "_NET_WM_ICON", False);
  Atom atom_net_win_type_normal 
    = XInternAtom(mbdesktop_xdisplay(mb), "_NET_WM_WINDOW_TYPE_NORMAL", False);
  Atom atom_utf8_str    = XInternAtom(mbdesktop_xdisplay(mb), "UTF8_STRING",    False);

  Atom *atom_tmp;
  
  int *wm_icon_data;

 atom_client_list = XInternAtom(mbdesktop_xdisplay(mb), "_NET_CLIENT_LIST",False);

  item = item_folder->item_child;

  wins = get_win_prop_data (mb, mb->root, atom_client_list, XA_WINDOW, &num);

  if (!wins) return;

 for (i = 0; i < num; i++)
   {
     unsigned char *win_name = NULL;
     img = NULL;

     trap_errors();

     XGetWindowAttributes(mbdesktop_xdisplay(mb), wins[i], &winattr);


     if (winattr.map_state != IsViewable)
       {
	 continue;
       }

     atom_tmp = get_win_prop_data (mb, wins[i], atom_net_win_type, 
				   XA_ATOM, NULL);
     if (atom_tmp && atom_tmp[0] != atom_net_win_type_normal)
       {
	 continue;
       }

     XGetTransientForHint(mbdesktop_xdisplay(mb), wins[i], &win_trans_for);
   
     if ( win_trans_for && (win_trans_for != wins[i]))
       {
	 continue;
       }

     if ((win_name = get_win_prop_data(mb, wins[i], 
				       atom_net_name, atom_utf8_str, 
				       NULL)) == NULL)
       {
	 XFetchName(mbdesktop_xdisplay(mb), wins[i], (char **)&win_name); 
	 if (!win_name) win_name = (unsigned char *)"<unnamed>";
       }

     wmhints = XGetWMHints(mbdesktop_xdisplay(mb), wins[i]);

     if ((wm_icon_data = get_win_prop_data(mb, wins[i], 
					  atom_net_wm_icon, XA_CARDINAL, 
					   NULL)) != NULL)
       {
	 unsigned char *p;
	 int i;
	 MBPixbufImage *tmp_img;

	 img = mb_pixbuf_img_new(mb->pixbuf,wm_icon_data[0],wm_icon_data[1] ); 

	 p = img->rgba;
	 for (i =0 ; i < (wm_icon_data[0]*wm_icon_data[1]); i++)
	   {
	     *p++ = (wm_icon_data[i+2] >> 16) & 0xff;  
	     *p++ = (wm_icon_data[i+2] >> 8) & 0xff;  
	     *p++ = wm_icon_data[i+2] & 0xff;  
	     *p++ = wm_icon_data[i+2] >> 24; 
	   }

	 if (img)
	   {
	     if (wm_icon_data[0] != 32 || wm_icon_data[1] != 32) 
	       {
		 tmp_img = mb_pixbuf_img_scale(mb->pixbuf, img, 32, 32); 
		 mb_pixbuf_img_free(mb->pixbuf, img);
		 img = tmp_img;
	       }
	   }
	 
	 XFree(wm_icon_data);
       }
     else if (wmhints && wmhints->flags & IconPixmapHint
	 && wmhints->flags & IconMaskHint)
       {
	 Window duh;
	 int x,y,w,h,b,d;
	 MBPixbufImage *tmp_img;

	 if (XGetGeometry(mbdesktop_xdisplay(mb), wmhints->icon_pixmap, &duh, 
			  &x, &y, &w, &h, &b, &d))
	   {
	     img = mb_pixbuf_img_new_from_drawable(mb->pixbuf, 
						   (Drawable)wmhints->icon_pixmap, 
						   (Drawable)wmhints->icon_mask,
						   0, 0, w, h);
	 
	     if ( (img) && (w != 32 || h != 32))
	       {
		 tmp_img = mb_pixbuf_img_scale(mb->pixbuf, img, 32, 32); 
		 
		 mb_pixbuf_img_free(mb->pixbuf, img);
		 img = tmp_img;
	       }
	   }

       } 

     item_new = mbdesktop_item_new_with_params( mb,
						win_name,
						NULL,
						(void *)wins[i],
						ITEM_TYPE_MODULE_ITEM
						);

     if (img != NULL && !untrap_errors())
       mbdesktop_item_set_icon_data(mb, item_new, img);

     mbdesktop_item_set_activate_callback (mb, item_new, tasks_activate_cb); 
	
     mbdesktop_items_append( mb, item, item_new);

     if (img) mb_pixbuf_img_free(mb->pixbuf, img);

     if (icon_name) free(icon_name);

   }

 XFree(wins);


}

void
tasks_close (MBDesktop *mb, MBDesktopItem *item_folder)
{
  mbdesktop_item_folder_contents_free(mb, item_folder); 
}

void
tasks_xevent (MBDesktop     *mb, 
	      MBDesktopItem *item_folder,
	      XEvent        *xevent)
{
  if (xevent->xproperty.atom == atom_client_list)
    {
      mbdesktop_item_folder_contents_free(mb, item_folder); 
      tasks_open (mb, item_folder);
      mbdesktop_view_paint(mb, False);
    }
}


static void
tasks_activate_cb (void *data1, void *data2)
{
  XEvent ev;
  MBDesktop *mb = (MBDesktop *)data1; 
  MBDesktopItem *item = (MBDesktopItem *)data2; 
  Atom atom_net_active 
    = XInternAtom(mbdesktop_xdisplay(mb), "_NET_ACTIVE_WINDOW", False);

  memset(&ev, 0, sizeof ev);
  ev.xclient.type = ClientMessage;
  ev.xclient.window = (Window)item->data;
  ev.xclient.message_type = atom_net_active;
  ev.xclient.format = 32;

  ev.xclient.data.l[0] = 0; 

  XSendEvent(mbdesktop_xdisplay(mb), mb->root, False, 
	     SubstructureRedirectMask, &ev);
}


#define MODULE_NAME         "Active Tasks"
#define MODULE_DESC         "Simple task switcher for desktop"
#define MODULE_AUTHOR       "Matthew Allum"
#define MODULE_MAJOR_VER    0
#define MODULE_MINOR_VER    0
#define MODULE_MICRO_VER    1
#define MODULE_API_VERSION  0
 
MBDesktopModuleInfo tasks_info = 
  {
    MODULE_NAME         ,
    MODULE_DESC         ,
    MODULE_AUTHOR       ,
    MODULE_MAJOR_VER    ,
    MODULE_MINOR_VER    ,
    MODULE_MICRO_VER    ,
    MODULE_API_VERSION
  };

MBDesktopFolderModule folder_module =
  {
    &tasks_info,
    tasks_init,
    tasks_open,
    tasks_close, 
    tasks_xevent,
    NULL
  };


