#include "mbdesktop_module.h"

static void
item_activate_cb(void *data1, void *data2);

static char* RootMatchStr = NULL;
static int ItemTypeDotDesktop = 0;

#ifdef USE_LIBSN

static void
item_activate_sn_cb(void *data1, void *data2);

static void
item_activate_si_cb(void *data1, void *data2);

static SnDisplay *SnDpy;

#endif 


static MBDesktopItem *
match_folder ( MBDesktop *mb, char *category )
{
  MBDesktopItem *item, *item_fallback = NULL;
  char          *match_str;

  match_str = (char *)mb->top_head_item->data;

  /* Add to root window */
  if (RootMatchStr)
    {
      if (!strcmp("fallback", RootMatchStr))
	{
	  item_fallback = mb->top_head_item;
	}
      else if (category && strstr(category, RootMatchStr))
	{
	  return mb->top_head_item;
	}
    }

  /* Each root child folder */
  mbdesktop_items_enumerate_siblings(mb->top_head_item->item_child, item)
    {
      if (item->type == ItemTypeDotDesktop)
	{
	  match_str = (char *)item->data;
	  if (match_str != NULL)
	    {
	      if (item_fallback == NULL && !strcmp("fallback", match_str))
		{
		  item_fallback = item;
		  continue;
		}
	      if (category && strstr(category, match_str))
		{
		  return item;
		}
	    }
	}
    }
  return item_fallback; 
}

static void
add_a_dotdesktop_item (MBDesktop *mb, MBDotDesktop *dd)
{
  MBDesktopItem  *item_new = NULL, *found_folder_item = NULL;

  found_folder_item = match_folder ( mb, mb_dotdesktop_get(dd, "Categories") );
      
  item_new = mbdesktop_item_new_with_params( mb,
					     mb_dotdesktop_get(dd, "Name"),
					     mb_dotdesktop_get(dd, "Icon"),
					     (void *)strdup(mb_dotdesktop_get(dd, "Exec")),
					     ITEM_TYPE_DOTDESKTOP_ITEM
					     );
  if (item_new == NULL ) return;

#ifdef USE_LIBSN
  if (mb_dotdesktop_get(dd, "SingleInstance")
      && !strcasecmp(mb_dotdesktop_get(dd, "SingleInstance"), 
		     "true"))
    {
      mbdesktop_item_set_activate_callback (mb, item_new, 
					    item_activate_si_cb); 
    }
  else if (mb_dotdesktop_get(dd, "StartupNotify")
	   && !strcasecmp(mb_dotdesktop_get(dd, "StartupNotify"), "true"))
    mbdesktop_item_set_activate_callback (mb, item_new, 
					  item_activate_sn_cb); 
  else
#endif
    mbdesktop_item_set_activate_callback (mb, item_new, 
					  item_activate_cb); 
	
  mbdesktop_items_append( mb, found_folder_item->item_child, item_new);
  
}



MBDesktopItem *
dotdesktop_init (MBDesktop *mb, MBDesktopFolderModule *folder_module, char *arg_str)
{
  DIR *dp;
  struct dirent *dir_entry;
  struct stat stat_info;

  char vfolder_path_root[512];
  char vfolder_path[512];
  char orig_wd[256];

  int i;

  MBDotDesktopFolders     *ddfolders;
  MBDotDesktopFolderEntry *ddentry;
  MBDesktopItem           *item_new = NULL;
  MBDotDesktop            *dd;

#define APP_PATHS_N 4

  char app_paths[APP_PATHS_N][256];

#ifdef USE_LIBSN
  SnDpy = sn_display_new (mb->dpy, NULL, NULL);
#endif

  ItemTypeDotDesktop = mbdesktop_module_get_register_type ( mb );
  
  snprintf( vfolder_path_root, 512, "%s/.matchbox/vfolders/Root.directory", getenv("HOME"));
  snprintf( vfolder_path, 512, "%s/.matchbox/vfolders", getenv("HOME"));


  if (stat(vfolder_path_root, &stat_info))
    {
      snprintf(vfolder_path_root, 512, PKGDATADIR "/vfolders/Root.directory");
      snprintf(vfolder_path, 512, PKGDATADIR "/vfolders" );
    }

  dd = mb_dotdesktop_new_from_file(vfolder_path_root);

  if (!dd) 			/* XXX improve */
    { fprintf( stderr, "mbdesktop: cant open %s\n", vfolder_path ); exit(1); }

  RootMatchStr = mb_dotdesktop_get(dd, "Match");

  /* XXX Below is potentially evil 
     - need to figure out a safe way so only one module can
       access the 'root props' at once. 
  */
  mbdesktop_item_set_name (mb, mb->top_head_item, 
			   mb_dotdesktop_get(dd, "Name"));  

  /* Now grab the vfolders */
  ddfolders = mb_dot_desktop_folders_new(vfolder_path);

  mb_dot_desktop_folders_enumerate(ddfolders, ddentry)
    {
      item_new 
	= mbdesktop_item_new_with_params( mb, 
					  mb_dot_desktop_folder_entry_get_name(ddentry),
					  mb_dot_desktop_folder_entry_get_icon(ddentry),
					  (void *)mb_dot_desktop_folder_entry_get_match(ddentry),
					  ItemTypeDotDesktop
					  );

      mbdesktop_item_set_activate_callback (mb, item_new, mbdesktop_item_folder_activate_cb); 

      item_new->item_child 
	= mbdesktop_item_new_with_params(mb,
					 "Up", 
					 "mbfolderprev.png", 
					 NULL,
					 ITEM_TYPE_PREVIOUS
					 );

      item_new->item_child->item_parent = item_new;

      mbdesktop_item_set_activate_callback (mb, item_new->item_child, 
					    mbdesktop_item_folder_prev_activate_cb); 

      /* Adding like this, may come back and haunt me */
      if (mb->top_head_item->item_child == NULL)
	mb->top_head_item->item_child = item_new;
      else
	mbdesktop_items_append( mb, mb->top_head_item->item_child, item_new);

    }

  snprintf(app_paths[0], 256, "/usr/share/applications");
  snprintf(app_paths[1], 256, "/usr/local/share/applications");
  snprintf(app_paths[2], 256, "%s/.applications", getenv("HOME"));
  snprintf(app_paths[3], 256, "%s/applications", PKGDATADIR);

  if (getcwd(orig_wd, 255) == (char *)NULL)
    {
      fprintf(stderr, "Cant get current directory\n");
      exit(0);
    }

  for (i = 0; i < APP_PATHS_N; i++)
    {
#ifdef USE_DNOTIFY
      int fd;
#endif

      if ((dp = opendir(app_paths[i])) == NULL)
	{
	  fprintf(stderr, "mbdesktop: failed to open %s\n", app_paths[i]);
	  continue;
	}

#ifdef USE_DNOTIFY
      fd = open(app_paths[i], O_RDONLY);
      fcntl(fd, F_SETSIG, SIGRTMIN);
      fcntl(fd, F_NOTIFY, DN_RENAME|DN_MODIFY|DN_CREATE|DN_DELETE|DN_MULTISHOT);
#endif USE_DNOTIFY

  
      chdir(app_paths[i]);

      while((dir_entry = readdir(dp)) != NULL)
	{
	  lstat(dir_entry->d_name, &stat_info);
	  if (!(S_ISDIR(stat_info.st_mode)))
	    {
	      MBDotDesktop *dd;
	      dd = mb_dotdesktop_new_from_file(dir_entry->d_name);
	      if (dd)
		{
		  if (mb_dotdesktop_get(dd, "Type") 
		      && !strcmp(mb_dotdesktop_get(dd, "Type"), "Application")
		      && mb_dotdesktop_get(dd, "Name")
		      && mb_dotdesktop_get(dd, "Exec"))
		    {
		      add_a_dotdesktop_item (mb, dd);
		    }
		  else fprintf(stderr, 
			       "mbdesktop: %s no good, ignoring\n", 
			       dir_entry->d_name);
		 
		  mb_dotdesktop_free(dd);
		}
	    }
	}
      closedir(dp);
    }
  chdir(orig_wd);



  return NULL;
}

/* Activate callbacks */


#ifdef USE_LIBSN
static void
item_activate_sn_cb(void *data1, void *data2)
{
  MBDesktop *mb = (MBDesktop *)data1;
  MBDesktopItem *item = (MBDesktopItem *)data2;

  SnLauncherContext *context;
  pid_t child_pid = 0;

  context = sn_launcher_context_new (SnDpy, mb->scr);

  sn_launcher_context_set_name (context, item->name);
  if (item->comment)
    sn_launcher_context_set_description (context, item->comment);
  sn_launcher_context_set_binary_name (context, (char *)item->data);

  sn_launcher_context_initiate (context, "mbdesktop launch", 
				(char *)item->data, CurrentTime);

  switch ((child_pid = fork ()))
    {
    case -1:
      fprintf (stderr, "Fork failed\n" );
      break;
    case 0:
      sn_launcher_context_setup_child_process (context);
      mb_exec((char *)item->data);
      // execlp(item->exec_str, item->exec_str, NULL);
      fprintf (stderr, "Failed to exec %s \n", (char *)item->data);
      _exit (1);
      break;
    }
}
#endif

#ifdef USE_LIBSN
static void
item_activate_si_cb(void *data1, void *data2)
{
  MBDesktop *mb = (MBDesktop *)data1;
  MBDesktopItem *item = (MBDesktopItem *)data2;
  Window win_found;

  if (mb_single_instance_is_starting(mb->dpy, (char *)item->data))
    return;

  win_found = mb_single_instance_get_window(mb->dpy, (char *)item->data);

  if (win_found != None)
    {
      mb_util_window_activate(mb->dpy, win_found);
    }
  else item_activate_sn_cb((void *)mb, (void *)item);

}
#endif

static void
item_activate_cb(void *data1, void *data2)
{
  MBDesktopItem *item = (MBDesktopItem *)data2;

  switch (fork())
    {
    case 0:
      mb_exec((char *)item->data);
      fprintf(stderr, "exec failed, cleaning up child\n");
      exit(1);
    case -1:
      fprintf(stderr, "can't fork\n");
      break;
    }
}

#define MODULE_NAME         "DotDesktop App Launcher"
#define MODULE_DESC         "DotDesktop App Launcher"
#define MODULE_AUTHOR       "Matthew Allum"
#define MODULE_MAJOR_VER    0
#define MODULE_MINOR_VER    0
#define MODULE_MICRO_VER    1
#define MODULE_API_VERSION  0
 
MBDesktopModuleInfo dotdesktop_info = 
  {
    MODULE_NAME         ,
    MODULE_DESC         ,
    MODULE_AUTHOR       ,
    MODULE_MAJOR_VER    ,
    MODULE_MINOR_VER    ,
    MODULE_MICRO_VER    ,
    MODULE_API_VERSION
  };

MBDesktopFolderModule folder_module =
  {
    &dotdesktop_info,
    dotdesktop_init,
    NULL,
    NULL, 
    NULL,
    NULL
  };
