#include "mbdesktop_item.h"

MBDesktopItem *
mbdesktop_item_new()
{
  MBDesktopItem *ditem;
  ditem = malloc(sizeof(MBDesktopItem));
  memset(ditem, 0, sizeof(MBDesktopItem));
  
  ditem->type = ITEM_TYPE_UNKNOWN;

  return ditem;
}

void
mbdesktop_item_free(MBDesktop     *mb, 
		    MBDesktopItem *item)
{
  /* XXX callback to free item->data */

  if (item->name)      free(item->name);
  if (item->icon_name) free(item->icon_name);
  if (item->icon)      mb_pixbuf_img_free(mb->pixbuf, item->icon);

  /* XXX check for children to free ? */

  free(item);

}

void
mbdesktop_item_folder_contents_free(MBDesktop     *mb, 
				    MBDesktopItem *item)
{
  MBDesktopItem *item_tmp = NULL, *item_cur = NULL;

  if (item->item_child && item->item_child->item_next_sibling)
    {
      item_cur = item->item_child->item_next_sibling;
      while (item_cur != NULL)
	{
	  item_tmp = item_cur->item_next_sibling;
	  mbdesktop_item_free(mb, item_cur); 
	  item_cur = item_tmp;
	}
      item->item_child->item_next_sibling = NULL;
    }
}

MBDesktopItem *
mbdesktop_item_new_with_params (MBDesktop     *mb,
			        char          *name, 
			        char          *icon_name,
			        void          *data,
			        int            type)
{
  MBDesktopItem *ditem;
  ditem = mbdesktop_item_new();

  if (name) ditem->name           = strdup(name);
  if (icon_name)
    {
      ditem->icon_name = strdup(icon_name);
    }

  mbdesktop_item_set_icon_from_theme(mb, ditem);

  if (data) ditem->data           = data;

  /*
  if (exec_str) ditem->exec_str   = strdup(exec_str);
  if (exec_cb) ditem->exec_cb     = exec_cb;
  if (populate_cb) ditem->populate_cb  = populate_cb;
  */

  if (type) ditem->type           = type;

  ditem->view = VIEW_ICONS;

  return ditem;
}

void
mbdesktop_item_set_icon_from_theme (MBDesktop     *mb,
				    MBDesktopItem *item)
{
#ifdef USE_PNG
  char *default_icon_name = "mbnoapp.png";
#else
  char *default_icon_name = "mbnoapp.xpm";
#endif


  char *icon_path = NULL;
  icon_path = mb_dot_desktop_icon_get_full_path (mb->theme_name, 
						 mb->icon_size, 
						 item->icon_name);

  if (icon_path == NULL)
    icon_path = mb_dot_desktop_icon_get_full_path (mb->theme_name, 
						   mb->icon_size, 
						   default_icon_name);

  if (item->icon) mb_pixbuf_img_free(mb->pixbuf, item->icon);

  if ((item->icon = mb_pixbuf_img_new_from_file(mb->pixbuf, icon_path)) 
      == NULL)
    {
      fprintf(stderr, "mbdesktop: could not load %s\n", icon_path);
      exit(1);
    }

  if (icon_path) free(icon_path);

  return;
}

void
mbdesktop_items_append (MBDesktop     *mb,
			MBDesktopItem *item_head,
			MBDesktopItem *item )
{
  MBDesktopItem *item_tmp = NULL;

  item_tmp = item_head;

  while ( item_tmp->item_next_sibling != NULL )
    item_tmp = item_tmp->item_next_sibling;

  item_tmp->item_next_sibling = item;
  item->item_prev_sibling = item_tmp;

}

void
mbdesktop_items_append_to_folder (MBDesktop      *mb,
				  MBDesktopItem  *item_folder,
				  MBDesktopItem  *item )
{
  if (!item_folder->item_child) return;

  item->module_handle = item_folder->module_handle;

  mbdesktop_items_append (mb, item_folder->item_child, item);

}

void
mbdesktop_items_prepend (MBDesktop      *mb,
			 MBDesktopItem **item_head,
			 MBDesktopItem  *item )
{
  MBDesktopItem *item_tmp = NULL;

  /*
  if ((*item_head)->type == ITEM_TYPE_PREVIOUS)
    item_tmp = (*item_head)->item_next_sibling;
  else
  */

  item_tmp = *item_head;
  item->item_next_sibling = item_tmp;
  item_tmp->item_prev_sibling = item;

  *item_head = item;

  /*
  old_item = item_tmp->item_next_sibling;

  item_tmp->item_next_sibling = item;
  item->item_prev_sibling     = item_tmp;
  item->item_next_sibling     = old_item;
  old_item->item_prev_sibling = item;

  if ((*item_head)->type != ITEM_TYPE_PREVIOUS)
    *item_head = item;
    */
}

MBDesktopItem *
mbdesktop_item_get_first_sibling(MBDesktopItem *item)
{
  while (item->item_prev_sibling != NULL )
    item = item->item_prev_sibling;
  return item;
}

void
mbdesktop_item_set_icon_data (MBDesktop     *mb, 
			      MBDesktopItem *item, 
			      MBPixbufImage *img)
{
  if (item->icon) mb_pixbuf_img_free(mb->pixbuf, item->icon);
  item->icon = mb_pixbuf_img_clone(mb->pixbuf, img);
}

void
mbdesktop_item_set_name (MBDesktop     *mb, 
			 MBDesktopItem *item, 
			 char          *name)
{
  if (item->name) free(item->name);
  item->name = strdup(name);
}


void
mbdesktop_item_set_image (MBDesktop     *mb, 
			  MBDesktopItem *item, 
			  char          *full_img_path)
{
  if (item->icon) mb_pixbuf_img_free(mb->pixbuf, item->icon);
  item->icon = mb_pixbuf_img_new_from_file(mb->pixbuf, full_img_path);
}

void
mbdesktop_item_set_activate_callback (MBDesktop     *mb, 
				      MBDesktopItem *item, 
				      MBDesktopCB    activate_cb)
{
  item->activate_cb = activate_cb;
}


/* Should these live here ?? */

void
mbdesktop_item_folder_activate_cb(void *data1, void *data2)
{
  MBDesktop *mb = (MBDesktop *)data1; 
  MBDesktopItem *item = (MBDesktopItem *)data2; 

  mb->scroll_offset_item = mb->kbd_focus_item 
    = mb->current_head_item = item->item_child;

  mb->current_folder_item = item; 

  /* XXX set current folder item, for module call backs */

  if (item->module_handle)
    {
      if (item->module_handle->folder_open)
	item->module_handle->folder_open(mb, item);
    }

  mbdesktop_view_paint(mb, False);
}

void
mbdesktop_item_folder_prev_activate_cb(void *data1, void *data2)
{
  MBDesktop *mb = (MBDesktop *)data1; 
  MBDesktopItem *item = (MBDesktopItem *)data2; 

  mb->scroll_offset_item = mb->kbd_focus_item 
    = mb->current_head_item = item->item_child;

  mb->kbd_focus_item = item->item_parent;
  mb->scroll_offset_item  = mb->current_head_item 
    = mbdesktop_item_get_first_sibling(item->item_parent);

  mb->current_folder_item = item->item_parent->item_parent; 

  /* Make sure if its a module it gets notified */
  if (item->item_parent->module_handle)
    {
      if (item->item_parent->module_handle->folder_open)
	item->item_parent->module_handle->folder_close(mb, item->item_parent);
    }

  mbdesktop_view_paint(mb, False);
}

MBDesktopItem *
mbdesktop_item_get_from_coords(MBDesktop *mb, int x, int y)
{
  MBDesktopItem *item;
  for(item = mb->scroll_offset_item; 
      (item != NULL && item != mb->last_visible_item); 
      item = item->item_next_sibling)
    {
      if (x > item->x && x < (item->x + item->width)
	  && y > item->y && y < (item->y + item->height))
	{
	  return item;
	} 
    }
  return NULL;
}
