/* massXpert - the true massist's program.

   Copyright(C) 2006,2007 Filippo Rusconi

   http://www.massxpert.org/massXpert

   This file is part of the massXpert project.

   The massxpert project is the successor to the "GNU polyxmass"
   project that is an official GNU project package(see
   www.gnu.org). The massXpert project is not endorsed by the GNU
   project, although it is released ---in its entirety--- under the
   GNU General Public License. A huge part of the code in massXpert
   is actually a C++ rewrite of code in GNU polyxmass. As such
   massXpert was started at the Centre National de la Recherche
   Scientifique(FRANCE), that granted me the formal authorization to
   publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License version 3, as published by the Free Software Foundation.
   

   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this software; if not, write to the

   Free Software Foundation, Inc.,

   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
*/


/////////////////////// Local includes
#include "fragOptions.hpp"


namespace massXpert
{

  FragOptions::FragOptions(PolChemDef *polChemDef, 
			    QString name, QString formula,
			    MxtFragEnd fragEnd,
			    const QString &comment, 
			    bool sequenceEmbedded)
    : FragSpec(polChemDef, name, formula, fragEnd, comment), 
      m_sequenceEmbedded(sequenceEmbedded)
  {
    // Have to be 1 and not 0, otherwise the setting functions ensuring
    // that m_startIonizeLevel>=m_endIonizeLevel will bug.
    m_startIonizeLevel = 1;
    m_endIonizeLevel = 1;
  }


  FragOptions::FragOptions(const FragSpec &fragSpec,
			    int startIndex, int endIndex,
			    bool sequenceEmbedded)
    : FragSpec(fragSpec), 
      m_startIndex(startIndex), m_endIndex(endIndex), 
      m_sequenceEmbedded(sequenceEmbedded)
  {
    // Have to be 1 and not 0, otherwise the setting functions ensuring
    // that m_startIonizeLevel>=m_endIonizeLevel will bug.
    m_startIonizeLevel = 1;
    m_endIonizeLevel = 1;
  }

 
  FragOptions::FragOptions(const FragOptions &other)
    : FragSpec(other), 
      m_startIndex(other.m_startIndex), m_endIndex(other.m_endIndex), 
      m_startIonizeLevel(other.m_startIonizeLevel),
      m_endIonizeLevel(other.m_endIonizeLevel),
      m_sequenceEmbedded(other.m_sequenceEmbedded)
  {
  }



  FragOptions::~FragOptions()
  {
  }


  FragOptions *
  FragOptions::clone() const
  {
    FragOptions *other = new FragOptions(*this);
  
    return other;
  }


  void 
  FragOptions::clone(FragOptions *other) const
  {
    Q_ASSERT(other);
  
    FragSpec::clone(other);

    other->m_sequenceEmbedded = m_sequenceEmbedded;
  }


  void 
  FragOptions::mold(const FragOptions &other)
  {
    if (&other == this)
      return;

    FragSpec::mold(other);
  
    m_sequenceEmbedded = other.m_sequenceEmbedded;
  }


  void 
  FragOptions::setStartIndex(int value)
  {
    m_startIndex = value;
  }


  int 
  FragOptions::startIndex() const
  {
    return m_startIndex;
  }


  void 
  FragOptions::setEndIndex(int value)
  {
    m_endIndex = value;
  }


  int 
  FragOptions::endIndex() const
  {
    return m_endIndex;
  }


  void 
  FragOptions::setStartIonizeLevel(int value)
  {
    int local =(value < 0 ) ? abs(value) : value;
  
    if (local <= m_endIonizeLevel)
      {
	m_startIonizeLevel = local;
      }
    else
      {
	m_startIonizeLevel = m_endIonizeLevel; 
	m_endIonizeLevel = local;
      }
  }


  int 
  FragOptions::startIonizeLevel() const
  {
    return m_startIonizeLevel;
  }


  void 
  FragOptions::setEndIonizeLevel(int value)
  {
    int local =(value < 0) ? abs(value) : value;
  
    if (local > m_startIonizeLevel)
      {
	m_endIonizeLevel = local;
      }
    else
      {
	m_startIonizeLevel = m_endIonizeLevel; 
	m_endIonizeLevel = local;
      }
  }


  int 
  FragOptions::endIonizeLevel() const
  {
    return m_endIonizeLevel;
  }



  void 
  FragOptions::setSequenceEmbedded(bool value)
  {
    m_sequenceEmbedded = value;
  }

  
  bool 
  FragOptions::isSequenceEmbedded() const
  {
    return m_sequenceEmbedded;
  }

} // namespace massXpert
