/* massXpert - the true massist's program.
   --------------------------------------
   Copyright(C) 2006,2007 Filippo Rusconi

   http://www.massxpert.org/massXpert

   This file is part of the massXpert project.

   The massxpert project is the successor to the "GNU polyxmass"
   project that is an official GNU project package(see
   www.gnu.org). The massXpert project is not endorsed by the GNU
   project, although it is released ---in its entirety--- under the
   GNU General Public License. A huge part of the code in massXpert
   is actually a C++ rewrite of code in GNU polyxmass. As such
   massXpert was started at the Centre National de la Recherche
   Scientifique(FRANCE), that granted me the formal authorization to
   publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License version 3, as published by the Free Software Foundation.
   

   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this software; if not, write to the

   Free Software Foundation, Inc.,

   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
*/


#ifndef MZ_LAB_INPUT_OLIGOMER_TREEVIEW_DLG_HPP
#define MZ_LAB_INPUT_OLIGOMER_TREEVIEW_DLG_HPP


/////////////////////// Qt includes
#include <QMainWindow>
#include <QSortFilterProxyModel>


/////////////////////// Local includes
#include "ui_mzLabInputOligomerTreeViewDlg.h"
#include "mzLabInputOligomerTreeViewModel.hpp"
#include "mzLabInputOligomerTreeViewSortProxyModel.hpp"


namespace massXpert
{

  class MzLabInputOligomerTreeViewModel;
  class MzLabInputOligomerTreeViewSortProxyModel;

  class MzLabInputOligomerTreeViewDlg : public QDialog
  {
    Q_OBJECT
  
    private:
    Ui::MzLabInputOligomerTreeViewDlg m_ui;

    MzLabWnd *mp_mzLabWnd;
    
    QString m_name;
    QString m_history;
    
    // Are the m/z--z data for FragmentOligomers?
    bool m_isFragment;
    
    MassType m_massType;
    // Indicates if data were already imported with a mass type, so
    // that if another import is done with another mass type, then the
    // user is alerted that he is mixing masses of different mass
    // types.
    MassType m_previousMassType;
        
    MzLabInputOligomerTreeViewModel *mpa_oligomerTreeViewModel;

    void closeEvent(QCloseEvent *event);
    
  public:
    MzLabInputOligomerTreeViewDlg(QWidget *, const QString & = QString());
    
    ~MzLabInputOligomerTreeViewDlg();
    
    void setName(const QString &);
    QString name();
    
    const OligomerList *oligomerList();
				      
    int duplicateOligomerData(const OligomerList *);
    
    MassType massType();
    MassType previousMassType();
    void setPreviousMassType(MassType);
    
    bool isFragment();
    void setFragment(bool);
    
    void applyFormula(const Formula &, bool);
    void applyMass(double, bool);
    void applyThreshold(double, bool, bool);
    void applyChargeIncrement(int, bool);
    void applyIonizeRule(const IonizeRule &, bool);
    
  public slots:
    void monoMassRadioButtonToggled(bool);
    void avgMassRadioButtonToggled(bool);
    void isFragmentCheckBoxChanged(int);
  };
  
} // namespace massXpert


#endif // MZ_LAB_INPUT_OLIGOMER_TREEVIEW_DLG_HPP
