/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

/***************************************************************************/
#ifdef _POSIX_C_SOURCE
#include <sys/time.h>
#include <time.h>
#include <limits.h>
#include <sys/times.h>
#include <unistd.h>
#endif /* POSIX */

/***************************************************************************/
#include "mas/mas_common.h"

int32
masc_cpu_us( uint32* user, uint32* sys )
{
#ifdef _POSIX_C_SOURCE
    static uint32 cps = 0;
    struct tms tmsval;

    if (cps == 0) cps = (uint32) sysconf(_SC_CLK_TCK); /* clocks per second */
    times( &tmsval );
/*     *sys = tmsval.tms_stime*1000000/cps; */
/*     *user = tmsval.tms_utime*1000000/cps; */
    *sys = tmsval.tms_stime;
    *user = tmsval.tms_utime;
    return 0;
    
#else
    *user = *sys = 0;
    return mas_error(MERR_INVALID);
#endif
}
