/*
 * Copyright (C) 2007 Intel Corporation
 *
 * Author:  Bob Spencer <bob.spencer@intel.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef STATUSBAR_PLUGIN_H
#define STATUSBAR_PLUGIN_H

#include <glib-object.h>
#include <libhildondesktop/tasknavigator-item.h>
#include <libhildonwm/hd-wm.h>

G_BEGIN_DECLS

typedef struct _StatusbarPlugin StatusbarPlugin;
typedef struct _StatusbarPluginClass StatusbarPluginClass;
typedef struct _StatusbarPluginPrivate StatusbarPluginPrivate;

#define STATUSBAR_TYPE_PLUGIN            (statusbar_plugin_get_type ())
#define STATUSBAR_PLUGIN(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), STATUSBAR_TYPE_PLUGIN, StatusbarPlugin))
#define STATUSBAR_PLUGIN_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  STATUSBAR_TYPE_PLUGIN, StatusbarPluginClass))
#define STATUSBAR_IS_PLUGIN(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), STATUSBAR_TYPE_PLUGIN))
#define STATUSBAR_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  STATUSBAR_TYPE_PLUGIN))
#define STATUSBAR_PLUGIN_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  STATUSBAR_TYPE_PLUGIN, StatusbarPluginClass))

struct _StatusbarPlugin 
{
   TaskNavigatorItem tnitem;
   HDWM *hdwm;
   GtkWidget *imgUp;
   GtkWidget *imgDn;
   GtkWidget *btn;
   StatusbarPluginPrivate *priv;
};

struct _StatusbarPluginClass 
{
   TaskNavigatorItemClass parent_class;
};

GType  statusbar_plugin_get_type  (void);

G_END_DECLS

#endif //STATUSBAR_PLUGIN_H
