/*
 * Copyright (C) 2007 Intel Corporation
 *
 * Author:  Bob Spencer <bob.spencer@intel.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <libhildondesktop/libhildondesktop.h>

#include "close-app-plugin.h"

HD_DEFINE_PLUGIN (CloseAppPlugin, close_app_plugin, TASKNAVIGATOR_TYPE_ITEM);
#define BTN_HEIGHT  52
#define BTN_WIDTH   52

static void close_app_finalize (GObject *object);

/* show/hide close button */
static void active_window_update (HDWM *hdwm, CloseAppPlugin *close_plugin)
{
/* Commented out until we get something reliable
   HDWMWindow *wnd = hd_wm_get_active_window();
   if (wnd) {
      gtk_widget_show_all (close_plugin->btn);
   } else {
      gtk_widget_hide_all (close_plugin->btn);
   }
*/
}

static void on_clicked (GtkWidget *button, CloseAppPlugin *close_plugin )
{
   //close active app
   g_print ("Closing active application");
   HDWMWindow *wnd = hd_wm_get_active_window();

   g_print ("Active window:%ld", (long)wnd);
   if (wnd != NULL) {
      hd_wm_window_close (wnd);
   }
}

static void close_app_plugin_init (CloseAppPlugin *close_plugin)
{
   GtkWidget *btn;

   close_plugin->hdwm = hd_wm_get_singleton ();
   g_object_ref (close_plugin->hdwm);
   //gtk_widget_push_composite_child ();

   btn = close_plugin->btn = gtk_button_new();
   //close_plugin->imgUp = gtk_image_new_from_file (THEME_DIR "/images/close_app_btn.png");
   //gtk_button_set_image ((GTK_BUTTON (btn)),(GtkWidget*) close_plugin->imgUp);

   gtk_widget_set_size_request (btn, BTN_WIDTH, BTN_HEIGHT);

   //gtk_misc_set_alignment ((GtkMisc*)close_plugin->imgUp, 0,0);
   //gtk_misc_set_padding ((GtkMisc*)close_plugin->imgUp, 0,0);

   g_signal_connect (btn, "clicked", 
		     G_CALLBACK (on_clicked), (gpointer)close_plugin);
   g_signal_connect (close_plugin->hdwm, "active-window-update",  
		     G_CALLBACK (active_window_update), (gpointer)close_plugin);

   gtk_widget_show_all (btn);
   gtk_container_add (GTK_CONTAINER (close_plugin), btn);

   //gtk_widget_pop_composite_child ();
}


static void close_app_plugin_class_init (CloseAppPluginClass *class)
{
  GObjectClass   *object_class = G_OBJECT_CLASS (class);
  //object_class->constructor = close_app_constructor;
  object_class->finalize    = close_app_finalize;
}

static void close_app_finalize (GObject *object)
{
   CloseAppPlugin *close_plugin = CLOSE_APP_PLUGIN (object);	
   g_object_unref (close_plugin->hdwm);
   //g_object_unref (close_plugin->imgDn);
   //g_object_unref (close_plugin->imgUp);
   G_OBJECT_CLASS (close_app_plugin_parent_class)->finalize (object);
}
