/******************************************************************************
 *
 * Project:  MapServer
 * Purpose:  Functions copied from GDAL's CPL.
 * Author:   Y. Assefa, DM Solutions Group (assefa@dmsolutions.ca)
 * 
 * This file contain utility functions that come from the GDAL/OGR cpl
 * library. The idea behind it is to have access in mapserver to all these
 * utilities, without being constarined to link with GDAL/OGR.
 * Note : Names of functions used here are the same as those in the cpl
 *         library with the exception the the CPL prefix is changed to ms
 *         (eg : CPLGetBasename() would become msGetBasename())
 *
 ******************************************************************************
 * Copyright (c) 1996-2005 Regents of the University of Minnesota.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies of this Software or works derived from this Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 ******************************************************************************
 *
 * $Log: mapcpl.c,v $
 * Revision 1.4  2005/06/14 16:03:33  dan
 * Updated copyright date to 2005
 *
 * Revision 1.3  2004/10/21 04:30:55  frank
 * Added standardized headers.  Added MS_CVSID().
 *
 */

/* $Id: mapcpl.c,v 1.4 2005/06/14 16:03:33 dan Exp $ */

#include <assert.h>
#include "map.h"

MS_CVSID("$Id: mapcpl.c,v 1.4 2005/06/14 16:03:33 dan Exp $")

/* should be size of largest possible filename */
#define MS_PATH_BUF_SIZE 2048
static char     szStaticResult[MS_PATH_BUF_SIZE]; 


/************************************************************************/
/*                        msFindFilenameStart()                         */
/************************************************************************/

static int msFindFilenameStart( const char * pszFilename )

{
    int         iFileStart;

    for( iFileStart = strlen(pszFilename);
         iFileStart > 0
             && pszFilename[iFileStart-1] != '/'
             && pszFilename[iFileStart-1] != '\\';
         iFileStart-- ) {}

    return iFileStart;
}

/************************************************************************/
/*                           msGetBasename()                            */
/************************************************************************/

/**
 * Extract basename (non-directory, non-extension) portion of filename.
 *
 * Returns a string containing the file basename portion of the passed
 * name.  If there is no basename (passed value ends in trailing directory
 * separator, or filename starts with a dot) an empty string is returned.
 *
 * <pre>
 * msGetBasename( "abc/def.xyz" ) == "def"
 * msGetBasename( "abc/def" ) == "def"
 * msGetBasename( "abc/def/" ) == ""
 * </pre>
 *
 * @param pszFullFilename the full filename potentially including a path.
 *
 * @return just the non-directory, non-extension portion of the path in
 * an internal string which must not be freed.  The string
 * may be destroyed by the next ms filename handling call.
 */

const char *msGetBasename( const char *pszFullFilename )

{
    int iFileStart = msFindFilenameStart( pszFullFilename );
    int iExtStart, nLength;

    for( iExtStart = strlen(pszFullFilename);
         iExtStart > iFileStart && pszFullFilename[iExtStart] != '.';
         iExtStart-- ) {}

    if( iExtStart == iFileStart )
        iExtStart = strlen(pszFullFilename);

    nLength = iExtStart - iFileStart;

    assert( nLength < MS_PATH_BUF_SIZE );

    strncpy( szStaticResult, pszFullFilename + iFileStart, nLength );
    szStaticResult[nLength] = '\0';

    return szStaticResult;
}
