/* This file is part of Malaga, a system for Natural Language Analysis.
 * Copyright (C) 1995-1999 Bjoern Beutel
 *
 * Bjoern Beutel
 * Universitaet Erlangen-Nuernberg
 * Abteilung fuer Computerlinguistik
 * Bismarckstrasse 12
 * D-91054 Erlangen
 * e-mail: malaga@linguistik.uni-erlangen.de 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

/* description ==============================================================*/

/* Manages the storage of analysis results for faster access. */

/* variables ================================================================*/

GLOBAL int_t cache_accesses; /* Number of calls of "word_in_cache". */
GLOBAL int_t cache_hits; /* Number of successful calls of "word_in_cache". */

/* functions ================================================================*/

extern bool_t word_in_cache (string_t surf_start, 
			     string_t surf_end);
/* Return whether the word form <surf_start>..<surf_end> is in the cache. */

extern value_t next_result_in_cache (void);
/* Return the next result category for a word form.
 * Use this function after calling "word_in_cache". */

extern void enter_in_cache (string_t surf_start,
			    string_t surf_end,
			    int_t num_cats,
			    value_t cats[]);
/* Enter the word form <surf_start>..<surf_end> in the cache 
 * with <num_cats> categories <cats[]>. */

extern void clear_cache (void);
/* Delete all cache entries. */

extern void set_cache_size (int_t size);
/* Set max. number of cache entries to <size>. */

extern int_t get_cache_size (bool_t maximum);
/* Get number of cache entries. */

/* end of file ==============================================================*/
