/* This file is part of the KDE project
    Copyright (C) 2006-2007 KovoKs <info@kovoks.nl>

   It has been copied from RSIBreak:
     Copyright (C) 2005-2006 Bram Schoenmakers <bramschoenmakers@kde.nl>
     Copyright (C) 2006 Tom Albers <tomalbers@kde.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include <qlabel.h>
#include <qpixmap.h>
#include <qvbox.h>
#include <qtimer.h>
#include <qapplication.h>
#include <qsimplerichtext.h>

#include <kapplication.h>
#include <kdebug.h>
#include <kglobalsettings.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <klocale.h>

#include <math.h>

#include "tooltip.h"

namespace Mailody {

ToolTip::ToolTip( QWidget *parent, const char *name )
  : KPassivePopup( parent, name )
{
   setTimeout( 5 * 1000 );

   QHBox *hbox = new QHBox( this );
   hbox->setSpacing( 10 );

   QLabel* mIcon = new QLabel( hbox );
   mIcon->resize( 32, 32 );
   mIcon->setPixmap(KGlobal::iconLoader()->loadIcon( "mailody", KIcon::Desktop ));

   QVBox *vbox = new QVBox( hbox );
   vbox->setSpacing( 5 );
   new QLabel( "<qt><strong>Mailody</strong></qt>", vbox );
   mText = new QLabel( vbox );

   setView( hbox );

   m_clearTimer = new QTimer( this );
   connect( m_clearTimer , SIGNAL(timeout()), SLOT(clearBlockList()) );
}

ToolTip::~ToolTip()
{
}

void ToolTip::addToBlockList(const QString& mb)
{
    m_blockList[mb] = true;
    m_clearTimer->start(10000, true);
}

void ToolTip::clearBlockList()
{
    m_blockList.clear();
}

void ToolTip::setText( const QString &mb, const QString& text)
{
    if (m_blockList[mb])
        return;

    if (isVisible())
        mText->setText( mText->text() + "<br>" + text );
    else
        mText->setText( text );

    adjustSize();

    // this is needed so the popup does not popup on random locations...
    kapp->processEvents();
    show();
}

void ToolTip::setText(const QPoint& point,  const QString& text)
{
    mText->setText( text );
    adjustSize();
    show();
    moveNear(QRect(point,point));
}

void ToolTip::mouseReleaseEvent( QMouseEvent * e )
{
    QSimpleRichText rt(mText->text(), font());
    rt.setWidth(mText->width());
    QString link = rt.anchorAt( mText->mapFrom(this,e->pos()) );

    // Delete the popup before emitting
    KPassivePopup::mouseReleaseEvent(e);
    if (link)
        emit leftClicked( link );
}

void ToolTip::contextMenuEvent( QContextMenuEvent * e )
{
    QSimpleRichText rt(mText->text(), font());
    rt.setWidth(mText->width());
    QString link = rt.anchorAt( mText->mapFrom(this,e->pos()) );
    if (link)
        rightClicked(link);

    hide();
}


}

#include "tooltip.moc"
