/*
   Copyright (C) 2006-2007 KovoKs <info@kovoks.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include <qpainter.h>
#include <qcursor.h>
#include <qdragobject.h>
#include <qdatetime.h>
#include <qtimer.h>
#include <klistview.h>
#include <klocale.h>
#include <kdebug.h>
#include "../libkmime/kmime_message.h"

#include "mailodybaselistview.h"

namespace Mailody {

MailodyBaseListView::MailodyBaseListView(QWidget* parent)
    : KListView(parent)
{
}

void MailodyBaseListView::leaveEvent(QEvent*)
{
    emit leftWidget();
}


//-------------------------------------------------------------------//


MailodyBaseListViewItem::MailodyBaseListViewItem( KListView* parent)
    : KListViewItem( parent ), m_level(1), m_fancyColumn(-1)
{
}

MailodyBaseListViewItem::MailodyBaseListViewItem( MailodyBaseListViewItem* parent)
    : KListViewItem( parent ), m_level(parent->level()), m_fancyColumn(-1)
{
}

void MailodyBaseListViewItem::setFancyDate( int column,
                                            const QDateTime& datetime)
{
    m_fancyColumn = column;
    m_dateTime = datetime;

    KMime::DateFormatter* i = new KMime::DateFormatter();
    setText(m_fancyColumn, i->dateString(m_dateTime));
}

int MailodyBaseListViewItem::compare( QListViewItem *i, int col,
                              bool ascending ) const
{
    MailodyBaseListViewItem* item = static_cast<MailodyBaseListViewItem*>(i);
    int levelcomp = 0;

    if (level() > item->level())
        levelcomp = 1;

    if (level() < item->level())
        levelcomp = -1;

    if (levelcomp == 0)
    {
        if (col == m_fancyColumn)
        {
            if (m_dateTime == item->getOriginalDate())
                levelcomp = 0;
            else if (m_dateTime > item->getOriginalDate())
                levelcomp = 1;
            else
                levelcomp = -1;
        }
        else
            levelcomp = key( col, ascending ).lower()
                        .compare( item->key( col, ascending).lower() );
    }

    return levelcomp;
}


}
#include "mailodybaselistview.moc"
