// Connection.cc - source file for the mailfilter program
// Copyright (c) 2000 - 2004  Andreas Bauer <baueran@in.tum.de>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

#include <string>
#include "Connection.hh"

using namespace std;

namespace conn {

  Connection::~Connection() {
  }

  // Returns true if the string buffer contains the end of an e-mail message header otherwise the function returns false.
  // Note: according to the POP3 specs the end of messages are seperated by <CR><LF><.><CR><LF>
  bool Connection::isHeaderEnd(const string& buffer) {
    if (buffer.length() >= 4)
      for (unsigned int i = 0; i+4 <= buffer.length(); i++)
	if ( (i+4 <= buffer.length()) &&
	     (buffer[i] == '\r') && (buffer[i+1] == '\n') && (buffer[i+2] == '.') && (buffer[i+3] == '\r') && (buffer[i+4] == '\n') )
	  return true;

    return false;
  }

}
