/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.tools.ant.util.FileUtils;
import org.mortbay.log.LogFactory;
import org.openqa.selenium.server.BrowserConfigurationOptions;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.browserlaunchers.AsyncExecute;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.LauncherUtils;
import org.openqa.selenium.server.browserlaunchers.ResourceExtractor;
import org.openqa.selenium.server.browserlaunchers.WindowsUtils;
import org.openqa.selenium.server.browserlaunchers.locators.InternetExplorerLocator;

public class HTABrowserLauncher
implements BrowserLauncher {
    static Log log = LogFactory.getLog(HTABrowserLauncher.class);
    private String sessionId;
    private File dir;
    private String htaCommandPath;
    private Process htaProcess;
    private Process iexploreProcess;
    private RemoteControlConfiguration configuration;
    private BrowserConfigurationOptions browserOptions;

    public HTABrowserLauncher(BrowserConfigurationOptions browserOptions, RemoteControlConfiguration configuration, String sessionId, String browserLaunchLocation) {
        if (browserLaunchLocation == null) {
            browserLaunchLocation = HTABrowserLauncher.findHTALaunchLocation();
        }
        this.htaCommandPath = browserLaunchLocation;
        this.sessionId = sessionId;
        this.configuration = configuration;
        this.browserOptions = browserOptions;
    }

    private static String findHTALaunchLocation() {
        File defaultLocation;
        String defaultPath = System.getProperty("mshtaDefaultPath");
        if (defaultPath == null) {
            defaultPath = WindowsUtils.findSystemRoot() + "\\system32\\mshta.exe";
        }
        if ((defaultLocation = new File(defaultPath)).exists()) {
            return defaultLocation.getAbsolutePath();
        }
        File mshtaEXE = AsyncExecute.whichExec("mshta.exe");
        if (mshtaEXE != null) {
            return mshtaEXE.getAbsolutePath();
        }
        throw new RuntimeException("MSHTA.exe couldn't be found in the path!\nPlease add the directory containing mshta.exe to your PATH environment\nvariable, or explicitly specify a path to mshta.exe like this:\n*mshta c:\\blah\\mshta.exe");
    }

    private void launch(String url, String htaName) {
        String query = LauncherUtils.getQueryString(url);
        query = query + "&baseUrl=http://localhost:" + this.getPort() + "/selenium-server/";
        this.createHTAFiles();
        String hta = new File(this.dir, "core/" + htaName).getAbsolutePath();
        log.info("Launching Embedded Internet Explorer...");
        AsyncExecute exe = new AsyncExecute();
        exe.setCommandline(new String[]{new InternetExplorerLocator().findBrowserLocationOrFail().launcherFilePath(), "-Embedding"});
        try {
            this.iexploreProcess = exe.asyncSpawn();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        log.info("Launching Internet Explorer HTA...");
        AsyncExecute htaExe = new AsyncExecute();
        htaExe.setCommandline(new String[]{this.htaCommandPath, hta, query});
        try {
            this.htaProcess = htaExe.asyncSpawn();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void createHTAFiles() {
        this.dir = LauncherUtils.createCustomProfileDir(this.sessionId);
        File coreDir = new File(this.dir, "core");
        try {
            coreDir.mkdirs();
            ResourceExtractor.extractResourcePath(HTABrowserLauncher.class, "/core", coreDir);
            FileUtils f = FileUtils.getFileUtils();
            File selRunnerSrc = new File(coreDir, "RemoteRunner.html");
            File selRunnerDest = new File(coreDir, "RemoteRunner.hta");
            File testRunnerSrc = new File(coreDir, "TestRunner.html");
            File testRunnerDest = new File(coreDir, "TestRunner.hta");
            File userExt = this.configuration.getUserExtensions();
            if (userExt != null) {
                File selUserExt = new File(coreDir, "scripts/user-extensions.js");
                f.copyFile(userExt, selUserExt, null, true);
            }
            f.copyFile(selRunnerSrc, selRunnerDest);
            f.copyFile(testRunnerSrc, testRunnerDest);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        int exitValue;
        if (this.browserOptions.is("killProcessesByName")) {
            WindowsUtils.tryToKillByName("iexplore.exe");
        }
        if (this.browserOptions.is("killProcessesByName")) {
            WindowsUtils.tryToKillByName("mshta.exe");
        }
        if (this.iexploreProcess != null && (exitValue = AsyncExecute.killProcess(this.iexploreProcess)) == 0) {
            log.warn("Embedded iexplore seems to have ended on its own (did we kill the real browser???)");
        }
        if (this.htaProcess == null) {
            return;
        }
        AsyncExecute.killProcess(this.htaProcess);
        LauncherUtils.recursivelyDeleteDir(this.dir);
    }

    public Process getProcess() {
        return this.htaProcess;
    }

    public void launchHTMLSuite(String suiteUrl, String browserURL) {
        this.launch(LauncherUtils.getDefaultHTMLSuiteUrl(browserURL, suiteUrl, !this.browserOptions.isSingleWindow(), this.getPort()), "TestRunner.hta");
    }

    private int getPort() {
        return this.configuration.getPortDriversShouldContact();
    }

    public void launchRemoteSession(String url) {
        this.launch(LauncherUtils.getDefaultRemoteSessionUrl(url, this.sessionId, !this.browserOptions.isSingleWindow(), this.getPort(), this.browserOptions.is("browserSideLog")), "RemoteRunner.hta");
    }
}

