
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file CoastPlottingAttributes.h
    \\brief Definition of CoastPlotting Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2018-06-04
*/

#include "CoastPlottingAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

CoastPlottingAttributes::CoastPlottingAttributes():
	thickness_(ParameterManager::getInt("map_coastline_thickness"))
	,
	colour_(MagTranslator<string, Colour>().magics("map_coastline_colour")),
	style_(MagTranslator<string, LineStyle>().magics("map_coastline_style"))
	 
{
} 


CoastPlottingAttributes::~CoastPlottingAttributes()
{
	
}

    
void CoastPlottingAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(2);
	int i = 0;
	prefix[i++] = "map";
	prefix[i++] = "map_coastline";
	
	setAttribute(prefix, "map_coastline_thickness", thickness_, params);
	
	setMember(prefix, "map_coastline_colour", colour_, params);
	setAttribute(prefix, "map_coastline_style", style_, params);
	
}

void CoastPlottingAttributes::copy(const CoastPlottingAttributes& other)
{
	thickness_ = other.thickness_;
	colour_ = unique_ptr<Colour>(other.colour_->clone());
	style_ = other.style_;
	
} 


bool CoastPlottingAttributes::accept(const string& node)
{	
	if ( magCompare(node, "coast")  )
		return true;
	
	return false;
}

void CoastPlottingAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "coast") )
		set(node.attributes());
	else {
		
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
		
	}
}

void CoastPlottingAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " thickness = " <<  thickness_;
	out << " colour = " <<  *colour_;
	out << " style = " <<  style_;
	
	out << "]" << "\n";
}

void CoastPlottingAttributes::toxml(ostream& out)  const
{
	out <<  "\"coast\""; 
	out << ", \"map_coastline_thickness\":";
	niceprint(out,thickness_);
	out << ", \"map_coastline_colour\":";
	niceprint(out, *colour_);
	out << ", \"map_coastline_style\":";
	niceprint(out, style_);
	
}

static MagicsParameter<int> map_coastline_thickness("map_coastline_thickness", 1, "");
static MagicsParameter<string> map_coastline_colour("map_coastline_colour", "black", ""); 
static MagicsParameter<string> map_coastline_style("map_coastline_style", "solid", ""); 
