
extern "C" {
#include <magics_api.h>
}

void init() {
  mag_open ();
}

void finalize() {
  mag_close();
}

void coast() {
  mag_coast();
} 

void grib() {
  mag_grib();
}

void test() {
  mag_test();
}

void odb() {
  mag_odb();
}

void netcdf() {
  mag_netcdf();
}

void cont() {
  mag_cont();
}

void obs() {
  mag_obs();
}

void raw() {
  mag_raw();
}

void image() {
  mag_image();
}

void plot() {
  mag_plot();
}

void text() {
  mag_text();
}

void wind() {
  mag_wind();
}

void symb() {
  mag_symb();
}

void new_page(const char* page)
{
  mag_new(page);
}

void reset(const char* name) {
  mag_reset(name);
}

void setc(const char* name, const char* value)
{
  mag_setc(name, value);
}

void setr(const char* name, const double value)
{
  mag_setr(name, value);
}

void seti(const char* name, const int value) {
  mag_seti(name, value);
}

void set1r(const char* name, const double *data, const int dim)
{
  mag_set1r(name, data, dim);
}

void set2r(const char* name, const double *data, const int dim1, const int dim2)
{
 mag_set2r(name, data, dim1, dim2);
}

void set3r(const char* name, const double *data, const int dim1, const int dim2, const int dim3)
{
 mag_set3r(name, data, dim1, dim2, dim3);
}

void set1i(const char* name, const int* data, const int dim)
{
 mag_set1i(name, data, dim);
}

void set2i(const char* name, const int *data, const int dim1, const int dim2)
{
 mag_set2i(name, data, dim1, dim2);
}

void set3i(const char* name, const int *data, const int dim1, const int dim2, const int dim3)
{
 mag_set3i(name, data, dim1, dim2, dim3);
}

void set1c(const char* name, const char** data, const int dim)
{
 mag_set1c(name, data, dim);
}

void pie() {
 mag_pie();
}

void graph() {
  mag_graph();
}

void axis() {
  mag_axis();
}

void geo() {
  mag_geo();
}

void eps() {
  mag_eps();
}

void info() {
  mag_info();
}
