/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file Contour.cc
    \brief Implementation of the Template class Contour.
    
    Magics Team - ECMWF 2004
    
    Started: Wed 3-Mar-2004
    
    Changes:
    
*/

#include "Contour.h"
#include "Layout.h"
#include "Layer.h"
#include "Text.h"

using namespace magics;

template <class P>
Contour<P>::Contour() 
{

}

template <class P>
Contour<P>::~Contour() 
{
}

/*!
 Class information are given to the output-stream.
*/	
template <class P>	
void Contour<P>::print(ostream& out)  const
{
	out << "Contour<P>[";
	ContourAttributes<P>::print(out);
	out << "]";
}

template <class P> 
class MatrixTreshold : public MatrixHandler<P>
{
public :
	MatrixTreshold(const AbstractMatrix& matrix, double min, double max) : 
		MatrixHandler<P>(matrix), min_(min), max_(max)
	{
	}
	double operator()(int row, int column) const {
		if (this->matrix_(row, column)  < min_) return min_;
		if (this->matrix_(row, column)  > max_) return max_;
		return this->matrix_(row, column); 
	}
	
	double min_;
	double max_;


};

template <class P>	
void Contour<P>::operator()(Data<P>& data, BasicGraphicsObjectContainer& parent)
{
    try {
    	
		BoxMatrixHandler<P> box(data.matrix(), (parent.transformation()));
		auto_ptr<MatrixHandler<P> > handler((*this->method_).handler(box, parent));     
		
		bool treshold = false;
		if ( this->ceiling_ < int_MAX ) treshold = true;
		if ( this->floor_ > -int_MAX ) treshold = true;
		 MatrixTreshold<P> matrix(*handler, this->floor_, this->ceiling_);
		CacheMatrixHandler<P> cache(treshold ? matrix : *handler);
		(*this->contour_).adjust(cache.min(), cache.max());
		(*this->contour_)(cache, parent);
		if ( magCompare( this->grid_->getType(), "akima" ) ) 
			(*this->grid_)(cache, parent);
		else 

			(*this->grid_)(box, parent);
		(*this->hilo_)(cache, parent);
   
    }
    catch (MagicsException& e) 
    {
    	// Do nothing! 
    }
}

template <class P>	
void Contour<P>::visit(LegendVisitor& legend)
{

	// if ( !this->legend_ ) return;
	this->contour_->visit(legend);
	//this->grid_->visit(legend);
	//this->hilo_->visit(legend);

}

