#include "MagPlus.h"
#include <iostream>

#include <FortranRootSceneNodeWrapper.h>
#include <FortranSceneNodeWrapper.h>
#include <FortranViewNodeWrapper.h>
#include <CoastlinesWrapper.h>
#include <AxisWrapper.h>
#include <VisualAction.h>

#include <GribDecoderWrapper.h>
#include <GribLoopWrapper.h>
#include <GeoPointsDecoderWrapper.h>
#include <NetcdfDecoderWrapper.h>
#include <ImportPlotWrapper.h>
#include <ImportActionWrapper.h>

#include <ContourWrapper.h>
//#include "OpenGLDriver.h"

#include <TextVisitor.h>
#include <TextVisitorWrapper.h>
//#include <TextActionMigrationWrapper.h>
//#include <TextBoxWrapper.h>

#include <SymbolPlottingWrapper.h>
#include <WindWrapper.h>

#include <GeoPoint.h>
#include "MagicsEvent.h"


#include <PostScriptDriverWrapper.h>
/*
 * #include <CairoDriverWrapper.h>
 */
#include <SVGDriverWrapper.h>
#include <KMLDriverWrapper.h>



//#include <Xm/Xm.h>

#include <OpenGLDriver.h>

template <class T>
void replace(MvRequest& request, const string& name, T from, T to)
{
	if (request.countValues(name.c_str()) == 0 ) {
		request(name.c_str()) = to;
		return;
	}
	T val = request(name.c_str());
	if (val == from) 
		request(name.c_str()) = to;
	
}

void replace_string(MvRequest& request, const string& name, const string& from, const string& to)
{
	if (request.countValues(name.c_str()) == 0 ) {
		request(name.c_str()) = to.c_str();
		return;
	}
	string val = (const char*) request(name.c_str());
	if (val == from) 
		request(name.c_str()) = to.c_str();
	
}

template <class T>
void replace(MvRequest& request, const string& name, T from, const string& newname, T to)
{
	if (request.countValues(name.c_str()) == 0 ) {
		request(newname.c_str()) = to;
		return;
	}
	T val = request(name.c_str());
	if (val == from) 
		request(newname.c_str()) = to;
	else 
		request(newname.c_str()) = val;
}

string get(MvRequest& request, const string& param, const string& val)
{
	if (request.countValues(param.c_str()) == 0) return val;
	const char* v = request(param.c_str());
	return string(v); 
} 

using namespace std;
using namespace magics;




map<string,  MagPlus::ObjectCreator > MagPlus::sceneCreators_;
map<string,  MagPlus::ObjectCreator > MagPlus::driverCreators_;





MagPlus::MagPlus() : root_(0), superpage_(-1), geographical_(true)

{
 	if ( sceneCreators_.empty()) { 		
 		sceneCreators_["PAGE"] = &MagPlus::page;
 		sceneCreators_["PCOAST"] = &MagPlus::coastlines;
 		sceneCreators_["PAXIS"] = &MagPlus::axis;
 		sceneCreators_["PGRIB"] = &MagPlus::gribloop;
        sceneCreators_["GRIBLOOP"] = &MagPlus::gribloop;
        sceneCreators_["GEOPOINTS"] = &MagPlus::geopoints;
 		sceneCreators_["NETCDF_GEOPOINTS"] = &MagPlus::geonetcdf;
        sceneCreators_["NETCDF_GEOVECTORS"] = &MagPlus::geonetcdf;
        sceneCreators_["NETCDF_GEOMATRIX"] = &MagPlus::geonetcdf;
        sceneCreators_["NETCDF_POINTS"] = &MagPlus::xynetcdf;
        sceneCreators_["NETCDF_VECTORS"] = &MagPlus::xynetcdf;
        sceneCreators_["NETCDF_MATRIX"] = &MagPlus::xynetcdf;
 		sceneCreators_["PCONT"] = &MagPlus::contour;
 		sceneCreators_["PSYMB"] = &MagPlus::symbol;
        sceneCreators_["PSYMBPLUS"] = &MagPlus::symbol;
        sceneCreators_["PWIND"] = &MagPlus::wind;
 		sceneCreators_["SUPERPAGE"] = &MagPlus::superpage;
        sceneCreators_["PTEXT"] = &MagPlus::text;
        sceneCreators_["DEVICE"] = &MagPlus::device;
        sceneCreators_["PIMPORT"] = &MagPlus::import; 
        sceneCreators_["PRASTER"] = &MagPlus::raster;
 	}
    
    if ( driverCreators_.empty()) {
    	driverCreators_["OpenGLDriver"] = &MagPlus::opengldriver;
 		driverCreators_["PSDriver"] = &MagPlus::psdriver;
        driverCreators_["PNGDriver"] = &MagPlus::pngdriver;
        driverCreators_["KMLDriver"] = &MagPlus::kmldriver;
        driverCreators_["PDFDriver"] = &MagPlus::pdfdriver;
        driverCreators_["SVGDriver"] = &MagPlus::svgdriver;
 	}
    
   
}

bool MagPlus::superpage(MvRequest& in)
{
	Log::dev()<< "superpage--->" << endl;
	
	int superpage = in("SUPERPAGE_INDEX");
	
	
	if ( superpage == superpage_) return false;
	superpage_ = superpage;
	in("LAYOUT") = "positional";
    
    
    in("SUPER_PAGE_FRAME_COLOUR") = "grey";
    in.print();
    FortranRootSceneNodeWrapper helper;
	helper.set(in);
		
	root_ = helper.object();
    
	Log::dev()<< "<----superpage" << endl;
	return false;
}



bool MagPlus::psdriver(MvRequest& in)
{
	PostScriptDriverWrapper helper;
	helper.set(in); 
	  
	drivers_.push_back(helper.object());   
	return false;
}

bool MagPlus::pngdriver(MvRequest& /*in*/)
{
     /* 
	CairoDriverWrapper helper;
	helper.set(in); 
	helper.me()->setPNG();
	drivers_.push_back(helper.object());   
*/
	return false;
}

bool MagPlus::pdfdriver(MvRequest& /*in*/)
{
   /*   
	   CairoDriverWrapper helper;
	   helper.set(in); 
	   helper.me()->setPDF();
       drivers_.push_back(helper.object());   
*/
       return false;
}

bool MagPlus::opengldriver(MvRequest& /*in*/)
{
	if ( !root_)
	{	  
		ParameterManager::set("opengl_observer", this);        
		 
		OpenGLDriver* ogl = new magics::OpenGLDriver();
		drivers_.push_back(ogl);   
	}
	if (root_)
	{
		delete root_;
		root_ = 0;
		superpage_ = -1;
	}
	return false;
}

bool MagPlus::svgdriver(MvRequest& in)
{
	SVGDriverWrapper helper;
	helper.set(in); 

	drivers_.push_back(helper.object());   

	return false;
}
bool MagPlus::kmldriver(MvRequest& in)
{
	KMLDriverWrapper helper;
	helper.set(in); 

	drivers_.push_back(helper.object());   

	return false;
}

bool MagPlus::page(MvRequest& in)
{
	Log::dev()<< "page and subpage--->" << endl;

	//in("LAYOUT") = "positional";

	while ( !empty() ) pop();
	in("PAGE_FRAME_COLOUR") = "grey";
	in.print();
	FortranSceneNodeWrapper scenehelper;
	scenehelper.set(in);

	root_->insert(scenehelper.object());
	push(scenehelper.object());
	replace(in, "SUBPAGE_Y_LENGTH", 17.85, -1.); // reset to the default!
	in("SUBPAGE_MAP_PREVIEW") = "on";
	FortranViewNodeWrapper viewhelper;
	viewhelper.set(in);
	FortranViewNode* view = viewhelper.object();
	if ( in.countValues("METVIEW_ID") )
	{
		string id = (const char*) in("METVIEW_ID");
		view->setInteractiveInfo(id.c_str(), 
		in("ZOOM_NUMBER_OF_LEVELS"), in("ZOOM_CURRENT_LEVEL"));
	}

	top()->insert(view);
	push(view);

	Log::dev()<< "<----page and subpage" << endl;
	return false; // do not exit
}


bool MagPlus::coastlines(MvRequest& in)
{
	Log::dev()<< "add coastlines" << endl;
	
	replace_string(in, "MAP_COASTLINE_RESOLUTION", "MEDIUM", "automatic");

	CoastlinesWrapper helper;
	
	helper.set(in);
	
	top()->push_back(helper.object());
	Log::dev()<< top() << endl;
	Log::dev()<< *helper.object() << endl;
	
	return false; // do not exit
}

bool MagPlus::axis(MvRequest& in)
{
	Log::dev()<< "add axis" << endl;
	 string orientation = (const char*) in("AXIS_ORIENTATION");
	 Axis* axis = 0;
	 if ( magCompare(orientation, "vertical") ) 
		 axis = new VerticalAxis();
	 else 
		 axis = new HorizontalAxis();
	 
	AxisWrapper helper(axis);				
	helper.set(in);
	
	top()->push_back(axis);
	Log::dev() << *axis << "\n";

	return false; // do not exit
}

bool MagPlus::import(MvRequest& /*in*/)
{
	Log::dev()<< "ignore for now!!!" << endl;
	return false; // do not exit
}

bool MagPlus::raster(MvRequest& in)
{
	Log::dev()<< "import a raster object" << endl;
	
	in.print();

	in("IMPORT_FILE_NAME") = (const char*) in("IMPORT_FILE_PATH");
	in("IMPORT_FORMAT") = (const char*) in("IMPORT_FILE_TYPE");
	
	ImportActionWrapper<GeoPoint> object;
	ImportPlotWrapper<GeoPoint> visdef;
	
	object.set(in);
	visdef.set(in);
	
	VisualAction<GeoPoint>* action = new VisualAction<GeoPoint>();
	top()->push_back(action);
	push(action);	
	  

	top()->data(object.object());
	top()->visdef(visdef.object());
	pop();

	return false; // do not exit
}

bool MagPlus::grib(MvRequest& in)
{
	Log::dev()<< "add grib" << endl;
	in.print();
	
	VisualAction<GeoPoint>* action = new VisualAction<GeoPoint>();
	top()->push_back(action);
	push(action);	
  
	GribDecoderWrapper grib;
	grib.set(in);
	top()->data(grib.object());

	return false; // do not exit
}

bool MagPlus::gribloop(MvRequest& in)
{
	Log::dev()<< "add gribloop" << endl;
	in.print();

	int position=  in("GRIB_FIELD_POSITION");
	if ( position ) 
		// we assume it is not an animation...
		return grib(in);
	string file =  get(in, "GRIB_INPUT_FILE_NAME", "");
	string iconname =  get(in, "_NAME", "");
	string iconclass =  get(in, "_CLASS", "");
	in("GRIB_SCALING") = "off";
	in("GRIB_LOOP_PATH") = file.c_str();
	VisualAnimation<GeoPoint>* action = new VisualAnimation<GeoPoint>();
	top()->push_back(action);
	push(action);	
  
	GribLoopWrapper grib;
	grib.set(in);
	grib.object()->icon(iconname, iconclass);
	action->loop(grib.object());
	
	return false; // do not exit
}

bool MagPlus::geonetcdf(MvRequest& in)
{

	Log::dev()<< "add geo netcdf" << endl;
	in.print();
	string path(in("NETCDF_FILENAME"));
	if (path == "OFF") {
		MvRequest netcdf = in("NETCDF_DATA");
		path = string(netcdf("PATH"));
	}
	in("NETCDF_FILENAME") = path.c_str();
    static map<string, string> types;
    if ( types.empty() ) {
        types["NETCDF_GEOPOINTS"] = "geopoint";
        types["NETCDF_GEOVECTORS"] = "geovector";
        types["NETCDF_GEOMATRIX"] = "geomatrix";
    }
        
	in("NETCDF_TYPE") = types[in.getVerb()].c_str();
	VisualAnimation<GeoPoint>* action = new VisualAnimation<GeoPoint>();
	top()->push_back(action);
	push(action);	
  
	NetcdfDecoderWrapper<GeoPoint> geonet;
	geonet.set(in);
	
	NetcdfLoop<GeoPoint>* loop = new NetcdfLoop<GeoPoint>(geonet.object());

	action->loop(loop);
	
	return false; // do not exit
}

bool MagPlus::xynetcdf(MvRequest& in)
{

	Log::dev()<< "add xy netcdf" << endl;
	in.print();
	string path(in("NETCDF_FILENAME"));
	if (path == "OFF") {
		MvRequest netcdf = in("NETCDF_DATA");
		path = string(netcdf("PATH"));
	}
	in("NETCDF_FILENAME") = path.c_str();
    static map<string, string> types;
    if ( types.empty() ) {
        types["NETCDF_POINTS"] = "xypoint";
        types["NETCDF_VECTORS"] = "vector";
        types["NETCDF_MATRIX"] = "matrix";
    }
        
	in("NETCDF_TYPE") = types[in.getVerb()].c_str();
	VisualAnimation<UserPoint>* action = new VisualAnimation<UserPoint>();
	top()->push_back(action);
	push(action);	
  
	NetcdfDecoderWrapper<UserPoint> xynet;
	xynet.set(in);
	
	NetcdfLoop<UserPoint>* loop = new NetcdfLoop<UserPoint>(xynet.object());
	
	geographical_ = false;
	
	action->loop(loop);
	
	return false; // do not exit
}

bool MagPlus::geopoints(MvRequest& in)
{
	// Extract the path ..
	MvRequest record = in("RECORD");
	
	in("GEO_INPUT_FILE_NAME") = record("PATH");
	in.print();
	VisualAction<GeoPoint>* action = new VisualAction<GeoPoint>();
	top()->push_back(action);
	push(action);	
  
	GeoPointsDecoderWrapper geopoints;
	geopoints.set(in);
	top()->data(geopoints.object());

	return false; // do not exit
}

bool MagPlus::symbol(MvRequest& in)
{
	if ( in.countValues("SYMBOL_INPUT_MARKER_LIST") ) {
		in("SYMBOL_MARKER") = in("SYMBOL_INPUT_MARKER_LIST");
	}
    string verb = in.getVerb();
    if ( verb == "PSYMBPLUS" ) {
        in("SYMBOL_TABLE_MODE") = "advanced"; 
        in("SYMBOL_TYPE") = "marker"; 
    } 
	SymbolPlottingWrapper<GeoPoint> symbol;
	symbol.set(in);
	Log::dev()<< "add symbol" << *symbol.object() << endl;
	top()->visdef(symbol.object());
	pop();

	return false; // do not exit
}

bool MagPlus::wind(MvRequest& in)
{
	
	WindWrapper<GeoPoint> wind;
	wind.set(in);
	Log::dev()<< "add wind" << *wind.object() << endl;
	top()->visdef(wind.object());
	pop();

	return false; // do not exit
}

bool MagPlus::contour(MvRequest& in)
{
	Log::dev()<< "add contour" << endl;

	replace(in, "CONTOUR_LABEL_HEIGHT", 0.3, 0.2);
	string legend = get(in, "LEGEND", "ON" );
	string iconname =  get(in, "_NAME", "");
	string iconclass =  get(in, "_CLASS", "");
	if ( magCompare(legend, "ON") ) {
		FortranAutomaticLegendVisitor* node = new FortranAutomaticLegendVisitor();	
		top()->legend(node);
	}
	if ( geographical_) {
		ContourWrapper<GeoPoint> contour;
		contour.set(in);
		top()->visdef(contour.object());
		contour.object()->icon(iconname, iconclass);
		pop();
	}
	else {
		ContourWrapper<UserPoint> contour;
		contour.set(in);
		contour.object()->icon(iconname, iconclass);
		top()->visdef(contour.object());
		pop();
	}

	return false; // do not exit
}

bool MagPlus::text(MvRequest& in)   
{
	Log::dev()<< "add Text" << endl;
	in.print();

	string mode = get(in, "TEXT_MODE", "automatic");
	
	replace(in, "TEXT_REFERENCE_CHARACTER_HEIGHT", 2.0 , "TEXT_FONT_SIZE", 0.3);
	replace_string(in, "TEXT_COLOUR", "BLUE", "navy"); 
	in("TEXT_HTML") = "on";
//	FortranTextVisitor* node;

	if (magCompare(mode, "positional") )
	{
		Log::dev()<< "positional mode --> not yet implemented!" << endl;
		/*
		FortranPositionalTextVisitor* node = new FortranPositionalTextVisitor();
		TextVisitorWrapper helper1(node);
		TextActionMigrationWrapper helper2(node);
		TextBoxWrapper helper3(node);
		helper1.set(in);
		helper2.set(in);
		helper3.set(in);
		top()->text(node);
		*/
		
	}
	else
	{ 
		FortranAutomaticTextVisitor* node = new FortranAutomaticTextVisitor();	
		TextVisitorWrapper helper1(node);
		//TextActionMigrationWrapper helper2(node);
		//TextBoxWrapper helper3(node);	
		helper1.set(in);
		//helper2.set(in);
		//helper3.set(in);
		top()->text(node);
	}

	return false; // do not exit
}

bool MagPlus::device(MvRequest& in)
{
	Log::dev()<< "add device" << endl;
	in.print();
	XmlNode* driver = 0;
	if ( !in.countValues("FORMAT") ) return false;
    const char* fmt = (const char*) in("FORMAT");
    
   
    string format(fmt);
    
    if ( format == "POSTSCRIPT") {
    	
    	map<string, string> attributes;
    	attributes["output_fullname"] = (const char*) in("FILE");
    
    	driver = new XmlNode("ps", attributes);
    }
	
	output_.set(*driver, drivers_);
    if ( driver) delete(driver);
	return false; // do not exit
}


/*
void MagPlus::serve( MvRequest& in, MvRequest& out, Widget widget, Widget top )
{

   if (widget && !root_)
   {
	   ParameterManager::set("opengl_parent_widget", widget);
       ParameterManager::set("opengl_widget", "motif");
       ParameterManager::set("opengl_top_level_widget", top);
	   ParameterManager::set("opengl_observer", this);        
	   ParameterManager::set("opengl_parent_widget", widget);
	   OpenGLDriver* ogl = new magics::OpenGLDriver();
	   drivers_.push_back(ogl);   
    }
   
   
   if (root_) {
   	  delete root_;
   	  root_ = 0;
   	  superpage_ = -1;
   }
   execute(in, out);
}
*/
 
void MagPlus::serve( MvRequest& in, MvRequest& out)
{
   execute(in, out);
}


void MagPlus::execute( MvRequest& in, MvRequest& /*out*/)
{
   while ( in ) {
   		string verb = in.getVerb();
   	    Log::dev()<< "create-->" << verb <<endl;
        {
   	    map<string,  ObjectCreator >::iterator creator = sceneCreators_.find(verb);
   	    if ( creator != sceneCreators_.end() ) {
   	    	  MvRequest request = in.justOneRequest();
   	    	  if ( (this->*creator->second)(request) ) return;
   	    }
        }
        { 
        map<string,  ObjectCreator >::iterator creator = driverCreators_.find(verb);
   	    if ( creator != driverCreators_.end() ) {
   	    	  MvRequest request = in.justOneRequest();
   	    	  if ( (this->*creator->second)(request) ) return;
   	    }
   	    }
   		in.advance();
   }
   try {
		assert(root_);
		root_->getReady();
		drivers_.setDriversWidth(root_->absoluteWidth());
		drivers_.setDriversHeight(root_->absoluteHeight());
	    
		root_->execute();
		drivers_.openDrivers();
		drivers_.dispatch(root_->root());
		drivers_.closeDrivers();
   }
   catch (MagicsException& e) 
   {
   	/*! \todo Why is this exception empty???  */
   } 
}

void  MagPlus::ready()
{
	Log::dev() << "MagPlus::ready()---> to be implemented" << endl;
}

void  MagPlus::update()
{
	Log::dev() << "MagPlus::update()---> to be implemented" << endl;
}


		
/*void  MagPlus::input(const string& area, float x, float y, BoxInfo*)
{
	Log::dev() << "MagPlus::input( " << area << ", " << x << ", " << y << ")---> to be implemented" << endl;
}*/

void  MagPlus::resize(float width, float height)
{
	Log::dev() << "MagPlus::resize(" << width << ", " << height << ")--> to be implemented" << endl;
}


	//! Method called in ToolTipMode :  x and y are in magics coordinates
	void MagPlus::tooltip(SelectionObject*)  {}
	//! Method called in PointSelectionMode  :  x and y are in magics coordinates
	void MagPlus::pointSelection(SelectionObject*)  {}
	//! Method called in AreaSelectionMode  :  x and y are in magics coordinates
	void MagPlus::areaSelection(SelectionObject* objects)  { 
	
	const Transformation& transformation = objects->layout().transformation();

	vector<double> lon;
	vector<double> lat;
	
	GeoPoint ll, ur;
	transformation.revert(objects->at(3), ll);
	transformation.revert(objects->at(1), ur);

	for (vector<MagicsObserver*>::iterator observer = observers_.begin(); observer != observers_.end(); ++observer) 
		(*observer)->areaCB(objects->layout().id(), ll.x(), ll.y(), ur.x(), ur.y());
}

	//! Method called in LineSelectionMode  :  x and y are in magics coordinates
	void MagPlus::lineSelection(SelectionObject*)  {}
	//! Method called in polygoneSelectionMode  :  x's and y's are in magics coordinates
	void MagPlus::polygonSelection(SelectionObject*)  {}
	//! Method called in polylineSelectionMode  :  x's and y's are in magics coordinates
	void MagPlus::polylineSelection(SelectionObject*)  {}
	void MagPlus::selection(SelectionObject*)  {}

	void MagPlus::zoomSelection(SelectionObject* object)  {
		Log::dev() << "zoomCB " <<  object->layout().zoomCurrentLevel() << endl;
		for (vector<MagicsObserver*>::iterator observer = observers_.begin(); observer != observers_.end(); ++observer) {
			(*observer)->zoomCB("id", object->layout().zoomCurrentLevel());
			Log::dev() << "zoomCB observer " <<  object->layout().zoomCurrentLevel() << endl;
		}
		//(*observer)->zoomCB(object->info()->id(), object->info()->zoomLevel());
    
	}

	void MagPlus::zoomLevelSelection(SelectionObject* object)  {
		for (vector<MagicsObserver*>::iterator observer = observers_.begin(); observer != observers_.end(); ++observer) {
			(*observer)->zoomCB(object->layout().id(), object->zoomLevel());
			Log::dev() << "zoomCB observer " <<  object->zoomLevel() << endl;
		}
		//(*observer)->zoomCB(object->info()->id(), object->info()->zoomLevel());
	}

void MagPlus::redraw()  {
		drivers_.openDrivers();
		//for (GraphicsList::const_iterator object = root_->begin(); object != root_->end(); ++object)
        	//drivers_.dispatch(*object);
		drivers_.closeDrivers();
}


void MagPlus::notify(MagicsEvent& event)
{
	Log::dev()<< "NOTIFY---" << event << endl;
	 for (vector<MagicsObserver*>::iterator observer = observers_.begin(); observer != observers_.end(); ++observer) 
			event.notify(**observer);
}

void MagPlus::unregisterObserver(MagicsObserver* observer)
{
//    vector<MagicsObserver*> observers;
//    
//    for ( vector<MagicsObserver*>::iterator obs = observers_.begin(); obs != observers_.end(); ++obs ) {
//    	if ( *obs != observer ) observers.push_back(*obs);
//    }
//    
//    observers_ = observers;
    // Trying new code!
    
    observers_.erase(std::remove_if(observers_.begin(), observers_.end(), 
    	bind2nd(equal_to<MagicsObserver*>(), observer)), observers_.end());
    	  
}


//_____________________________________________________________________

#ifdef STANDALONE
int main( int argc, char** argv )
{
    MvApplication theApp( argc, argv );
    MagPlusService magplus;
    theApp.run();
}
#endif
