/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file OpenGLTextureItem.h
    \brief Definition of OpenGLTextureItem.
    \author Graphics Section, ECMWF

    Started: May 2004
*/


#ifndef _OpenGLTextureManager_H
#define _OpenGLTextureManager_H

#define GL_GLEXT_PROTOTYPES

#include <GL/gl.h>
#include <PaperPoint.h>

namespace magics 
{
class OpenGLTextureItem
{
public:		
	OpenGLTextureItem();
	~OpenGLTextureItem();

	void transparent(bool b) {transparent_=b;};
	void generate();
	bool isEmpty();
	bool isFilled();
	void clear();	
	void setBlending(GLenum,GLenum,float);
	void setBlendingAlpha(float); 
	void setDplMode(bool);
	bool dplMode() {return dplMode_;}
	void bind();
	void unBind();

	void generateFromFb(const int,const int,const int,const int,GLenum img_type = GL_RGBA);
	void modifyFromFb(const int,const int,const int,const int,const float,const float);
	void generateFromImage(GLubyte *, int, int, GLenum);
	int  generateFromPng(const char*);

	void mapTexture(const float, const float, const float, const float,
		                   const int, const int, const int, const int);	
	void mapTexture(const float,const float,const float,const float);
	void mapTexture(const vector<PaperPoint>&,const vector<PaperPoint>&);

	void setFading(bool f) {fading_=f;}

	GLuint id() {return texId_;}

	int x() {return x_;};
	int y() {return y_;};
	int width()  {return width_;};
	int height() {return height_;};
		
private:
	GLuint 	texId_;
	bool 	transparent_;
	GLenum  blendingSrcFactor_;
	GLenum  blendingDestFactor_;    
	float   blendingAlpha_;
	
	int x_;
	int y_;
	int width_;
	int height_;	

	bool filled_;
	bool fading_;
	float fadingFactor_;
	bool dplMode_;
	
};


}

#endif
