/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*! \file OpenGLPushButtonWidget.h
    \brief Definition of the OpenGLPushButtonWidget.
    \author Graphics Section, ECMWF
    
    Started: July 2008    
*/

#ifndef OpenGLPushButtonWidget_H
#define OpenGLPushButtonWidget_H

#include <GL/gl.h>

#include <magics.h>
#include <OpenGLLabelWidget.h>

namespace magics 
{

class OpenGLPushButtonWidget : public OpenGLLabelWidget
{
public:			
	OpenGLPushButtonWidget(OpenGLDriver *driver,OpenGLBaseWidget *parent,string name,int x=0, int y=0, int width=0, int height=0);	
				
	bool active();
	void event(MtInputEvent*);
	void render();
	void input(int,int);
	void release(int,int);
	void focus(int,int);

	void setEnabled(bool);
	void setBorder(bool b) {border_=b;}
	
	bool pressed_;
	bool enabled_;
	bool border_;
};	

	
}	
#endif	
