/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file OpenGLPickObjectManager.h
    \brief Definition of OpenGLPickObjectManager
    \author Graphics Section, ECMWF

    Started: May 2004
*/

#ifndef _OpenGLPickObjectManager_H
#define _OpenGLPickObjectManager_H

#include <SelectionMode.h>
#include <OpenGLDriverObserver.h>
#include <OpenGLBaseTool.h>

namespace magics
{

class OpenGLPickObject;
class OpenGLDriver;

typedef	list<OpenGLPickObject*> OpenGLPickObjectList;


class OpenGLPickObjectManager : public OpenGLDriverObserver, public OpenGLBaseTool
{

public:
	OpenGLPickObjectManager(OpenGLDriver* d);	
	
protected:	
	void setInteractiveMode(InteractiveMode);

	void select(const int, const int);
	void unselect();
	void begin(const int, const int);
	void replace(const int, const int);
	void resize(const int, const int);
	void reshape(const int, const int);
	void end(const int, const int);
	void enterMode();
	void leaveMode();
			
	void drawAllObjects();
				
	OpenGLPickObject* identifyPickObject(const int, const int);
		
	void deletePickObjects();	
		
	void event(MtInputEvent*);		
			
	mutable InteractiveMode interactiveMode_;
	mutable PickMode pickMode_;	
	
	mutable OpenGLPickObject* currentPickObject_;

	mutable SelectionMode pickObjectAttr_;
	
	mutable int pickX_;
	mutable int pickY_;	
	mutable int prevX_;
	mutable int prevY_;
	
	OpenGLDriver *driver_;
};	

}

#endif
