/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*! \file PickObject.h
    \brief Definition of the PickObject.
    \author Graphics Section, ECMWF
    
    Started: October 2007    
*/

#ifndef OpenGLPickObject_H
#define OpenGLPickObject_H

#include <magics.h>
#include <Log.h>
#include <PaperPoint.h>
#include <OpenGLCommon.h>
#include <OpenGLDriver.h>

namespace magics {

typedef enum PickObjectType {POT_POINT,POT_LINE,POT_POLYLINE,POT_AREA,POT_POLYGON,POT_MAGBOX,POT_ZOOMRECT};

class OpenGLPickObject  
{
public:
	OpenGLPickObject(OpenGLBox*, double, double, double, double, OpenGLBox*);
	OpenGLPickObject(OpenGLBox*,PickObjectType);		
	~OpenGLPickObject();

	void initBox();
//	void inputCB(XEvent*) {};	

	OpenGLBox*  getMagBox() {return magBox_;};	
	OpenGLBox*  getBoundingBox() {return &bBox_;};	
	OpenGLBox*  getParentBox() {return parentBox_;};	
	vector<PaperPoint>* getObject() {return &obj_;};
	vector<OpenGLBox*>* getObjectBox() {return &objBox_;};
	vector<OpenGLBox*>* getCornerBox() {return &cornerBox_;};
	vector<OpenGLBox*>* getSideBox() {return &sideBox_;};
	bool getModifyStatus() {return modifyStatus_;};		

	PickObjectType getType() {return type_;};

	bool addPoint(PaperPoint&);
	bool setLastPoint(PaperPoint&);
	void deleteLastPoint();

	bool  replaceObject(const double,const double);
	bool  resizeObject(const double,const double);	
	void  finishModification() {modifyStatus_=false;};

	bool checkPointInBoundingBox(const double, const double);
	bool checkPointInCornerBox(const double, const double);
	bool checkPointInSideBox(const double, const double);
	bool checkPointInObjectBox(const double, const double);

	void getBoundingBoxCover(float &,float &, float &, float &, 
				const float, const float, const float, const float);

	void renderObject(bool);
	void renderPickBox(bool,bool);
	void renderTmpPickObject(bool,bool);
	
	void driver(OpenGLDriver* d) {driver_=d;};
					
protected:
	void  setBoundingBox();
	void  createPickBox();
	void  updatePickBox();
	void  updateObject(float,float,float,float);
	
	bool  checkNewPositionInParent(double &,double &,double,double);
	
	OpenGLBox *magBox_;
	OpenGLBox *parentBox_;
	OpenGLBox bBox_;	
	vector<PaperPoint> obj_;
	vector<OpenGLBox*> objBox_;
	vector<OpenGLBox*> cornerBox_;
	vector<OpenGLBox*> sideBox_;
	
	PickObjectType type_;	
	bool modifyStatus_;
	OpenGLBox* currentBox_;
	
	OpenGLDriver* driver_;
};



}// namespace magics
#endif
