/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*! \file OpenGLMagnifierScale.h
    \brief Definition of the OpenGLMagnifierScale.
    \author Graphics Section, ECMWF
    
    Started: August 2008    
*/

#ifndef OpenGLMagnifierScale_H
#define OpenGLMagnifierScale_H

#include <GL/gl.h>

#include <magics.h>
#include <Log.h>

class MtInputEvent;

namespace magics {

class OpenGLMagnifier;
class OpenGLTextureItem;

class OpenGLMagnifierScaleItem
{
public:
	OpenGLMagnifierScaleItem(float v, Colour &c1, Colour &c2,Colour &c3,Colour &c4) : 
	               value_(v), colour_(c1), dimColour_(c2) ,
		       brightColour_(c3),selectorColour_(c4) {};
	
	void 	set(float,float,float,float);
	
public:
	float 	value_;		
	Colour 	colour_;
	Colour 	dimColour_;
	Colour 	brightColour_;
	Colour 	selectorColour_;	

	float 	startAngle_;
	float 	endAngle_;
	float 	radIn_;
	float 	radOut_;
};

class OpenGLMagnifierScaleSlider
{
public:
	OpenGLMagnifierScaleSlider();
	~OpenGLMagnifierScaleSlider();
	bool checkPointInSlider(int,int);
	void setX(int i, float x) {x_[i]=x;};
	void setY(int i, float y) {y_[i]=y;};
	void setCentre(int,int);
        void getCentre(int&,int&);
        bool shiftSlider(int,int,float,float);
        void render(); 

protected:	

	float x_[4];
	float y_[4];
	OpenGLTextureItem* tex_;
 	
};


class OpenGLMagnifierScale : public vector<OpenGLMagnifierScaleItem>
{
public:	
	OpenGLMagnifierScale() {};
	OpenGLMagnifierScale(vector<float>&,int,OpenGLMagnifier*,Colour,Colour);
	~OpenGLMagnifierScale();
	
	void    setFactors(vector<float>&,int);
	int	identifyPointInScale(float,float);
	int	identifyPointInScale(float,float,float);
	void 	set(float);
	void 	render();
	void 	renderScale();
	float   actValue() {return at(actIndex_).value_;};
	float   maxValue() {return back().value_;}
	int     valueNum() {return size();}
	void    actIndex(int i) {actIndex_=i;};
	int    	actIndex() {return actIndex_;};

	void event(MtInputEvent*,float,float);	
	bool active();

protected:	
	void setSlider(int);
	void setSlider();
        bool setActIndex(int);
	void renderPanel();
	void renderTextPanel();

	void input(int,int);
	void sliderDrag_start(int,int);
	void sliderDrag(int,int);
	void sliderDrag_end(int,int);

	int actIndex_;

	float   cellAngleSize_;	
	float 	cellStartAngle_;
	float 	cellEndAngle_;
	Colour 	cellOutlineColour_;	
	float 	cellWidth_;
	float 	cellHeight_;
	float 	cellSelectionLineWidth_;
	
	//Cell area
	Colour 	areaOutlineColour_;
	Colour 	areaTopFillColour_;
	Colour 	areaBottomFillColour_;
	float 	areaBorderSize_; 
	int 	areaResolution_;
	float 	areaWidth_;
	float   areaRadIn_;

	Colour  minColour_;
	Colour  maxColour_;

	Colour textColour_;
	Colour textSelectionColour_;

	OpenGLMagnifierScaleSlider slider_;
	bool drag_;
	int prevX_;
	int prevY_;
        
        OpenGLMagnifier *magnifier_;

};

}

#endif