/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*! \file OpenGLMagnifierButton.h
    \brief Definition of the OpenGLMagnifierButton.
    \author Graphics Section, ECMWF
    
    Started: August 2008    
*/

#ifndef OpenGLMagnifierButton_H
#define OpenGLMagnifierButton_H

#include <GL/gl.h>

#include <magics.h>
#include <Log.h>

class MtInputEvent;

namespace magics {

class OpenGLMagnifier;

class OpenGLMagnifierButton
{
public:	
	OpenGLMagnifierButton() {};
	OpenGLMagnifierButton(OpenGLMagnifier*);
	
	void 	set(float,float,float,float);
	void    set(float);

	bool	checkPoint(float,float);
	bool	checkPoint(float,float,float);

	void 	render();
	bool    status() {return status_;};

	void    event(MtInputEvent*,float,float);	
	bool    active() {return false;}

protected:	
	void renderButton();

	void input(int,int);
	
	bool    status_;
	string  name_;

	Colour 	colour_;

	float 	startAngle_;
	float 	endAngle_;
	float 	radIn_;
	float 	radOut_;
	
	float   angleSize_;	
	
	Colour 	outlineColour_;	
	float 	width_;
	float 	height_;
	float 	selectionLineWidth_;
	
	//Cell area
	Colour 	topFillColour_;
	Colour 	bottomFillColour_;
	float 	borderSize_; 
	
        OpenGLMagnifier *magnifier_;

};

}

#endif