/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*! \file OpenGLLabelWidget.h
    \brief Definition of the OpenGLLabelWidget.
    \author Graphics Section, ECMWF
    
    Started: May 2008    
*/

#ifndef OpenGLLabelWidget_H
#define OpenGLLabelWidget_H

#include <GL/gl.h>
#include <magics.h>
#include <OpenGLBaseWidget.h>
#include "Label.h"
#include "PaperPoint.h"
#include "Text.h"

namespace magics 
{

class OpenGLTextureItem;

typedef enum OpenGLLabelType {MGLW_LabelPixmap,MGLW_LabelText,MGLW_LabelArea};

class OpenGLLabelWidget : public OpenGLBaseWidget
{
public:
	OpenGLLabelWidget(OpenGLDriver*,string name,int x=0, int y=0, int width=0, int height=0);
	~OpenGLLabelWidget();

	void setPixmap(string,string);
	void setText(string);
	void setFontSize(int);
	void render();
	void setLabelType( OpenGLLabelType t) {type_=t;};
	void setLabelItemOnly(bool t) {labelItemOnly_=t;};
	void setFitPixmapToWidget(bool f) {fitPixmapToWidget_=f;};
	void setPixmapFading(bool);

protected:	
	string 			pixmap_;	
	OpenGLTextureItem 	*pixmapTex_;

	//GLuint pixmapTexId_;			
	
	bool labelItemOnly_; //no bg rendered
	bool fitPixmapToWidget_;

	string text_;
	int fontSize_; //pixels
	
	OpenGLLabelType type_;

private:	
	void renderPixmap();
	void renderText();
	void renderArea();
	//int read_png_to_texture(const char*,GLuint&);
};	

}	

#endif	
