/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file OpenGLDplManager.h
    \brief Definition of OpenGLDplManager.
    \author Graphics Section, ECMWF

    Started: May 2008
*/

#ifndef _OpenGLDplManager_H
#define _OpenGLDplManager_H

#include <magics.h>
#include <Text.h>
#include <PaperPoint.h>

#include <GL/gl.h>
#include <GL/glu.h>


namespace magics 
{

enum mglDplType {M_DPL_NORMAL, M_DPL_TEXT, M_DPL_TEXT_MAGNIFY, M_DPL_TEXT_NOMAGNIFY};
enum mglDplStatus {M_DPL_EMPTY,M_DPL_CREATED, M_DPL_COMPILED, M_DPL_BEING_COMPILED};

class OpenGLLayoutNode;
class OpenGLTextureItem;

class OpenGLDplItem
{	

public:
	OpenGLDplItem(mglDplType t=M_DPL_NORMAL) : dpl_(0), type_(t), status_(M_DPL_EMPTY), text_(0), 
					           areaIndex_(-1), clipping_(false), texture_(0) {};
	~OpenGLDplItem();

	GLuint dpl() {return dpl_;};	
	mglDplType type() {return type_;};	
	void text(const Text* t) {text_=t;};
	const Text* text() {return text_;};
	bool compiled() {return status_== M_DPL_COMPILED;};		

	void create();
	void clear(set<mglDplType>&);
	void clear();
	bool compileStart();
	bool compileEnd();
	void call(set<mglDplType>&);
	void call();	

	void parentLayout(OpenGLLayoutNode *p) {parentLayout_=p;};
	OpenGLLayoutNode* parentLayout() {return parentLayout_;};
	
	void setTexture(OpenGLTextureItem* t) {texture_=t;}
	OpenGLTextureItem* texture() {return texture_;}

	void setAreaIndex(int i) {areaIndex_=i;}
	int areaIndex() {return areaIndex_;}

	void setClipping(bool b) {clipping_=b;}
	bool clipping() {return clipping_;} 

	
protected:
	GLuint dpl_;
	mglDplType   type_;
	mglDplStatus status_;	
	const Text* text_;
	OpenGLLayoutNode *parentLayout_;
	int areaIndex_;	
	bool clipping_;	
	OpenGLTextureItem* texture_;				
};



class OpenGLDplManager : public list<OpenGLDplItem*>
{
public:
	OpenGLDplManager() {};
	~OpenGLDplManager();
		
	void clearDplContent(set<mglDplType>&);
	void clearDplContent();
	void erase();
	OpenGLDplItem* add(mglDplType t=M_DPL_NORMAL);	
	
	void call(set<mglDplType>&);
	void call();
	int getSize() {return size();};	
	


	typedef list<OpenGLDplItem*>::const_iterator DplIterator;
	DplIterator firstItem() { return begin();};
	DplIterator lastItem() {return end();};
};

}

#endif

