/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file OpenGLAreaGroup.h
    \brief Definition of OpenGLAreaGroup.
    \author Graphics Section, ECMWF

    Started: May 2009
*/

#ifndef _OpenGLAreaGroup_H
#define _OpenGLAreaGroup_H

#include <magics.h>
#include <OpenGLBox.h>

using namespace std;

namespace magics 
{

class OpenGLAreaGroupItem : public OpenGLBox, public list<unsigned int> 
{
public:
	OpenGLAreaGroupItem(float x,float y,float w,float h) :  OpenGLBox(x,y,w,h) {};
};



class OpenGLAreaGroup: public vector<OpenGLAreaGroupItem*>
{
public:
	OpenGLAreaGroup(float,float,float,float,int,int);
	~OpenGLAreaGroup();
 
	void addItemIndex(unsigned int,float,float);
	void clearItemIndex();
	void findAreas(float,float,float,float,std::set<int>&);
	
private:	
	OpenGLAreaGroupItem* groupItem(float, float);

	typedef vector<OpenGLAreaGroupItem*>::iterator AreaGroupIterator;
	AreaGroupIterator firstItem() { return begin();};
	AreaGroupIterator lastItem() {return end();};

	float xmin_;
	float xmax_;
	float ymin_;
	float ymax_;

	int nx_;
	int ny_;
};
	


}


#endif 
