#include "FontMap.h"

using namespace magics;

FontMap* FontMap::instance_ = 0;
bool     FontMap::hasFonts_=false;
std::map<string, magFont, RuntimeStringCompare> FontMap::fonts_;


FontMap* FontMap::instance()
{
	if(instance_ == 0)	
	{
		instance_= new FontMap;
		instance_->readFonts();
		return instance_;
	}
	else
	{
		return instance_;
	}
}

void FontMap::readFonts()
{
	const string s = getEnvVariable("MAGPLUS_HOME") + MAGPLUS_PATH_TO_SHARE_ + "Fonts.dat";
	ifstream psfile(s.c_str());

	if(psfile)
	{
		int	id;
		char	temp[128];
		char	magics_name[64];
		char	ps_name[128];
		char	ps_filename[128];
		char	ttf_filename[128];
		char	css_name[128];

		// read header (4 lines) and ignore
		psfile.getline(temp,128);psfile.getline(temp,128);
		psfile.getline(temp,128);psfile.getline(temp,128);

		while (!psfile.eof())
		{
			magFont font;
			psfile >> id >> magics_name >> ps_name >> ps_filename >> ttf_filename >> css_name;
			font.id = id;
			font.magics_name = magics_name;
			font.ps_name = ps_name;
			font.ps_filename = ps_filename;
			font.ttf_filename = ttf_filename;
			font.css_name = css_name;
			fonts_[string(magics_name)]= font;
		}
		psfile.close();
		hasFonts_ = true;
	}
	else 
	{
		Log::fatal() << "FontMap::readFonts() --> Cannot open Font file " << s << " ! No text can be plotted.\n";
	}
}	


void FontMap::ttfFileName(const MagFont &magfont,string &ttf)
{	
	const std::set<string>& styles = magfont.styles();

	string style = "";
	if(styles.find("bold") != styles.end()) style = "bold";
	if(styles.find("italic") != styles.end()) style += "italic";
	if(style == "") style = "normal";
	
	const bool underlined = (styles.find("underlined") != styles.end()) ? true : false;
		
	const string lowFont = lowerCase(magfont.name()+"_"+style);

	FontIterator iter = fonts_.find(lowFont);
                				
	ttf = getEnvVariable("MAGPLUS_HOME") + "/" + MAGICS_TTF_PATH;
	if(iter != fonts_.end())
	{
		ttf += iter->second.ttf_filename;
	}	
	else
	{
		// if not found get default
		ttf += fonts_["sansserif_normal"].ttf_filename;
	}

	//Check if file is really available
	/*struct stat st_buf; 						
	if(stat(ttf.c_str(),&st_buf) == 0)
	{		
		Log::warning() << "OpenGLPainter: TTF font file "<< ttf <<" could not be found! Font "<< new_font<< " is used instead!"<< endl;
		
		//fontMapIter iter = FontMap_.find(new_font);

		ttf = getEnvVariable("MAGPLUS_HOME") + "/" + MAGICS_TTF_PATH;
		if(iter!=FontMap_.end())
			ttf += iter->second.ttf_filename;
			
				
	}*/
}